/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.net.messages.client.loader;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.net.NetworkPacket;
import software.bluelib.internal.BlueResource;
import software.bluelib.loader.geckolib.constant.dataticket.SerializableDataTicket;

public record SingletonDataSyncPacket<D>(@NotNull String syncableId, @NotNull Long instanceId, @NotNull SerializableDataTicket<D> dataTicket, @NotNull D data) implements NetworkPacket<SingletonDataSyncPacket<D>>
{
    @NotNull
    public static final ResourceLocation ID = BlueResource.resource("singleton_data_sync");

    @Override
    public void encode(@NotNull RegistryFriendlyByteBuf pBuffer) {
        pBuffer.writeUtf(this.syncableId);
        pBuffer.writeVarLong(this.instanceId.longValue());
        SerializableDataTicket.STREAM_CODEC.encode((Object)pBuffer, this.dataTicket);
        this.dataTicket.streamCodec().encode((Object)pBuffer, this.data);
    }

    @NotNull
    public static <D> SingletonDataSyncPacket<D> decode(@NotNull RegistryFriendlyByteBuf pBuffer) {
        String syncableId = pBuffer.readUtf();
        Long instanceId = pBuffer.readVarLong();
        SerializableDataTicket dataTicket = (SerializableDataTicket)SerializableDataTicket.STREAM_CODEC.decode((Object)pBuffer);
        Object data = dataTicket.streamCodec().decode((Object)pBuffer);
        return new SingletonDataSyncPacket<Object>(syncableId, instanceId, dataTicket, data);
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return ID;
    }
}

