/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.platform;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.loader.model.BlueModel;
import software.bluelib.loader.renderer.armor.BlueArmorRenderer;
import software.bluelib.loader.renderer.base.BlueRenderer;
import software.bluelib.loader.renderer.client.BlueRenderProvider;
import software.bluelib.platform.IPlatformClient;

@OnlyIn(value=Dist.CLIENT)
public class NeoForgePlatformClientHelper
implements IPlatformClient {
    @NotNull
    public <T extends LivingEntity> HumanoidModel<T> getArmorModelForItem(@NotNull T pAnimatable, @NotNull ItemStack pStack, @NotNull EquipmentSlot pSlot, @NotNull HumanoidModel<LivingEntity> pDefaultModel) {
        HumanoidModel<?> humanoidModel;
        Item item = pStack.getItem();
        HumanoidModel model = IClientItemExtensions.of((Item)item).getHumanoidArmorModel(pAnimatable, pStack, pSlot, pDefaultModel);
        if (model == pDefaultModel && (humanoidModel = BlueRenderProvider.of(item).getBlueArmorRenderer(pAnimatable, pStack, pSlot, pDefaultModel)) instanceof BlueArmorRenderer) {
            BlueArmorRenderer blueArmorRenderer = (BlueArmorRenderer)humanoidModel;
            return blueArmorRenderer;
        }
        return model;
    }

    @Override
    @Nullable
    public BlueModel<?> getBlueModelForItem(@NotNull ItemStack pItem) {
        BlockEntityWithoutLevelRenderer blockEntityWithoutLevelRenderer = IClientItemExtensions.of((ItemStack)pItem).getCustomRenderer();
        if (blockEntityWithoutLevelRenderer instanceof BlueRenderer) {
            BlueRenderer blueRenderer = (BlueRenderer)blockEntityWithoutLevelRenderer;
            return blueRenderer.getBlueModel();
        }
        blockEntityWithoutLevelRenderer = BlueRenderProvider.of(pItem).getBlueItemRenderer();
        if (blockEntityWithoutLevelRenderer instanceof BlueRenderer) {
            BlueRenderer blueRenderer = (BlueRenderer)blockEntityWithoutLevelRenderer;
            return blueRenderer.getBlueModel();
        }
        return null;
    }

    @Override
    @Nullable
    public BlueModel<?> getBlueModelForArmor(@NotNull ItemStack pArmour) {
        HumanoidModel<?> humanoidModel = IClientItemExtensions.of((ItemStack)pArmour).getHumanoidArmorModel(null, pArmour, null, null);
        if (humanoidModel instanceof BlueArmorRenderer) {
            BlueArmorRenderer armorRenderer = (BlueArmorRenderer)humanoidModel;
            return armorRenderer.getBlueModel();
        }
        humanoidModel = BlueRenderProvider.of(pArmour).getBlueArmorRenderer(null, pArmour, null, null);
        if (humanoidModel instanceof BlueArmorRenderer) {
            BlueArmorRenderer armorRenderer = (BlueArmorRenderer)humanoidModel;
            return armorRenderer.getBlueModel();
        }
        return null;
    }
}

