/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.recipe.brewing;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import software.bluelib.internal.registry.BlueRecipeSerializerRegistry;
import software.bluelib.internal.registry.BlueRecipeTypeRegistry;
import software.bluelib.recipe.brewing.BrewingInput;

public record BrewingRecipe(@NotNull String groupName, @NotNull Ingredient input, @NotNull Ingredient bottle, @NotNull ItemStack result) implements Recipe<BrewingInput>
{
    public boolean matches(@NotNull BrewingInput pInputData, @NotNull Level pLevel) {
        boolean ingredientMatches = this.input.test(pInputData.ingredient());
        List<ItemStack> bottles = pInputData.bottles();
        boolean validBottles = bottles.stream().filter(stack -> !stack.isEmpty()).allMatch((Predicate<ItemStack>)this.bottle);
        return ingredientMatches && validBottles;
    }

    @NotNull
    public ItemStack assemble(@NotNull BrewingInput pInput, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int pWidth, int pHeight) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider pRegistries) {
        return this.result.copy();
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return BlueRecipeSerializerRegistry.BREWING.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return BlueRecipeTypeRegistry.BREWING.get();
    }

    @NotNull
    public Ingredient getInputIngredient() {
        return this.input;
    }

    @NotNull
    public Ingredient getBottleIngredient() {
        return this.bottle;
    }

    public static boolean isBottle(@NotNull ItemStack pItemStack, @NotNull RecipeManager pRecipeManager) {
        return pRecipeManager.getAllRecipesFor(BlueRecipeTypeRegistry.BREWING.get()).stream().anyMatch(recipe -> ((BrewingRecipe)recipe.value()).getBottleIngredient().test(pItemStack));
    }

    public static boolean isInput(@NotNull ItemStack pItemStack, @NotNull RecipeManager pRecipeManager) {
        return pRecipeManager.getAllRecipesFor(BlueRecipeTypeRegistry.BREWING.get()).stream().anyMatch(recipe -> ((BrewingRecipe)recipe.value()).getInputIngredient().test(pItemStack));
    }

    public static class Serializer
    implements RecipeSerializer<BrewingRecipe> {
        @NotNull
        public static final MapCodec<BrewingRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(BrewingRecipe::groupName), (App)Ingredient.CODEC.fieldOf("input").forGetter(BrewingRecipe::getInputIngredient), (App)Ingredient.CODEC.fieldOf("bottle").forGetter(BrewingRecipe::getBottleIngredient), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(BrewingRecipe::result)).apply((Applicative)instance, BrewingRecipe::new));
        @NotNull
        public static final StreamCodec<RegistryFriendlyByteBuf, BrewingRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        private static BrewingRecipe fromNetwork(@NotNull RegistryFriendlyByteBuf pBuffer) {
            String group = pBuffer.readUtf(Short.MAX_VALUE);
            Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer);
            Ingredient bottle = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)pBuffer);
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)pBuffer);
            return new BrewingRecipe(group, input, bottle, result);
        }

        private static void toNetwork(@NotNull RegistryFriendlyByteBuf pBuffer, @NotNull BrewingRecipe pRecipe) {
            pBuffer.writeUtf(pRecipe.groupName());
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.getInputIngredient());
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.getBottleIngredient());
            ItemStack.STREAM_CODEC.encode((Object)pBuffer, (Object)pRecipe.result());
        }

        @NotNull
        public MapCodec<BrewingRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, BrewingRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

