/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd;

import com.bdc.bdd.BddCommon;
import com.bdc.bdd.BddConstants;
import com.bdc.bdd.client.BddClient;
import com.bdc.bdd.registry.VariantProvider;
import com.bdc.bdd.registry.builders.entity.BddEntityBuilder;
import com.bdc.bdd.registry.helpers.EntityAttributeRegistry;
import com.bdc.bdd.world.gen.FabricSpawnRegistry;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import software.bluelib.api.entity.variant.IVariantProvider;
import software.bluelib.config.LoggerConfig;
import software.bluelib.event.ReloadHandler;

public class BddFabric
implements ModInitializer,
DataGeneratorEntrypoint {
    public void onInitialize() {
        BddCommon.init();
        if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            BddClient.init();
        }
        ReloadHandler.registerProvider((IVariantProvider)new VariantProvider());
        FabricSpawnRegistry.addSpawns();
        ItemGroupEvents.MODIFY_ENTRIES_ALL.register(this::addSpawnEggsToTab);
        EntityAttributeRegistry.registerAttributes(FabricDefaultAttributeRegistry::register);
        LoggerConfig.isLoggingEnabled = BddConstants.enableLogging;
        LoggerConfig.isBlueLibLoggingEnabled = false;
    }

    private void addSpawnEggsToTab(class_1761 group, FabricItemGroupEntries entries) {
        for (Supplier<class_1792> spawnEgg : BddEntityBuilder.getSpawnEggsForTab(group)) {
            entries.method_45421((class_1935)spawnEgg.get());
        }
    }

    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        BddCommon.doDatagen();
    }
}

