/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.ai.behaviors;

import com.bdc.bdd.api.ai_stuffs.DragonBehavior;
import com.bdc.bdd.api.entity.BddDragon;
import java.util.logging.Level;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;

public class AggressionBehavior
implements DragonBehavior<BddDragon> {
    private static final double AGGRESSION_RADIUS = 3.0;
    private static final double ATTACK_DISTANCE = 2.5;
    private static final int BITE_WINDUP_TICKS = 6;
    private static final int BITE_RECOVERY_TICKS = 8;
    private static final int ATTACK_COOLDOWN_TICKS = 10;
    private class_1309 targetPlayer = null;
    private int biteTicks = -1;
    private int attackCooldown = 0;

    @Override
    public boolean canStart(BddDragon dragon, class_1937 level) {
        if (level.field_9236) {
            return false;
        }
        class_238 searchBox = dragon.method_5829().method_1014(3.0);
        this.targetPlayer = level.method_8390(class_1657.class, searchBox, p -> !p.method_7337() && !p.method_7325()).stream().findFirst().orElse(null);
        return this.targetPlayer != null && dragon.canMove();
    }

    @Override
    public void start(BddDragon dragon, class_1937 level) {
        boolean inRange;
        if (level.field_9236) {
            return;
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.targetPlayer == null || !this.targetPlayer.method_5805()) {
            this.resetState(dragon);
            return;
        }
        dragon.method_5980(this.targetPlayer);
        double distSqr = dragon.method_5858((class_1297)this.targetPlayer);
        boolean bl = inRange = distSqr <= 6.25;
        if (inRange) {
            dragon.method_5942().method_6340();
            dragon.method_18799(class_243.field_1353);
            dragon.method_5728(false);
            dragon.method_5988().method_20248(this.targetPlayer.method_23317(), this.targetPlayer.method_23320(), this.targetPlayer.method_23321());
            if (this.biteTicks < 0 && this.attackCooldown == 0) {
                this.biteTicks = 0;
                dragon.setBiting(true);
            }
            if (this.biteTicks >= 0) {
                if (this.biteTicks == 6) {
                    this.applyBiteDamage(dragon, this.targetPlayer, level);
                }
                ++this.biteTicks;
                if (this.biteTicks >= 14) {
                    this.biteTicks = -1;
                    dragon.setBiting(false);
                    this.attackCooldown = 10;
                }
            }
        } else {
            if (this.biteTicks >= 0) {
                this.biteTicks = -1;
                dragon.setBiting(false);
            }
            class_243 playerPos = this.targetPlayer.method_19538().method_1031(0.0, 0.25, 0.0);
            double speed = dragon.isAbleToFly() && dragon.getAltitude() > 5.0 ? (double)dragon.method_49484() : (double)dragon.method_6029() * 8.0;
            dragon.method_5728(true);
            dragon.setFlying(dragon.isAbleToFly() && dragon.getAltitude() > 5.0);
            dragon.method_5942().method_6337(playerPos.field_1352, playerPos.field_1351, playerPos.field_1350, speed);
        }
    }

    @Override
    public void stop(BddDragon dragon, class_1937 level) {
        this.resetState(dragon);
    }

    private void resetState(BddDragon dragon) {
        dragon.method_5980(null);
        dragon.method_5942().method_6340();
        dragon.method_18799(class_243.field_1353);
        dragon.setBiting(false);
        dragon.setFlying(false);
        dragon.method_5728(false);
        this.targetPlayer = null;
        this.biteTicks = -1;
    }

    private void applyBiteDamage(BddDragon dragon, class_1309 target, class_1937 level) {
        if (level.field_9236) {
            return;
        }
        if (target == null || !target.method_5805()) {
            return;
        }
        if (dragon.method_5858((class_1297)target) > 9.0) {
            return;
        }
        float damage = dragon.getPower();
        boolean hit = target.method_5643(level.method_48963().method_48812((class_1309)dragon), damage);
        if (hit) {
            BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Bite damage (vanilla) applied to " + target.method_5477().getString() + " dmg=" + damage + " hpAfter=" + target.method_6032()));
            return;
        }
        boolean generic = target.method_5643(level.method_48963().method_48830(), damage);
        if (generic) {
            BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Bite damage (generic) applied to " + target.method_5477().getString() + " dmg=" + damage + " hpAfter=" + target.method_6032()));
            return;
        }
        float remaining = damage;
        float abs = target.method_6067();
        if (abs > 0.0f) {
            float use = Math.min(abs, remaining);
            target.method_6073(abs - use);
            remaining -= use;
        }
        if (remaining > 0.0f) {
            float before = target.method_6032();
            float after = Math.max(0.0f, before - remaining);
            target.method_6033(after);
            BaseLogger.log((Level)BaseLogLevel.WARNING, (String)("Bite damage (brute) applied to " + target.method_5477().getString() + " dmg=" + remaining + " hpBefore=" + before + " hpAfter=" + after));
        } else {
            BaseLogger.log((Level)BaseLogLevel.WARNING, (String)("Bite damage (brute) fully absorbed by " + target.method_5477().getString()));
        }
    }
}

