/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.ai.behaviors;

import com.bdc.bdd.api.ai_stuffs.DragonBehavior;
import com.bdc.bdd.api.entity.BddDragon;
import com.bdc.bdd.util.BddUtil;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_3532;

public class FlyWanderBehavior
implements DragonBehavior<BddDragon> {
    protected static Random random = new Random();
    protected static final double FOOD_SEARCH_RADIUS = 16.0;
    protected int ticksUntilNewTarget = 0;
    protected int ticksUntilFlightCheck = 0;
    protected int ticksSinceLanding = 0;
    protected int ticksSinceFlying = 0;
    protected int ticksUntilVerticalChange = 0;
    protected int verticalActionDuration = 0;
    protected final int TARGET_REFRESH_TICKS;
    protected final int FLIGHT_CHECK_TICKS;
    protected final int LANDING_GRACE_TICKS = BddUtil.secondsToTicks(5);
    protected final int MIN_FLYING_TICKS = BddUtil.secondsToTicks(3);
    protected final int VERTICAL_CHECK_TICKS;
    protected final int VERTICAL_ACTION_MIN_TICKS = BddUtil.secondsToTicks(2);
    protected final int VERTICAL_ACTION_MAX_TICKS = BddUtil.secondsToTicks(5);

    public FlyWanderBehavior() {
        this.TARGET_REFRESH_TICKS = random.nextInt(BddUtil.secondsToTicks(7), BddUtil.secondsToTicks(14));
        this.FLIGHT_CHECK_TICKS = random.nextInt(BddUtil.secondsToTicks(3), BddUtil.secondsToTicks(6));
        this.VERTICAL_CHECK_TICKS = random.nextInt(BddUtil.secondsToTicks(5), BddUtil.secondsToTicks(10));
    }

    @Override
    public boolean canStart(BddDragon dragon, class_1937 level) {
        class_238 searchBox = dragon.method_5829().method_1014(16.0);
        boolean foodNearby = level.method_8390(class_1542.class, searchBox, item -> item.method_5805() && dragon.method_6481(item.method_6983())).stream().anyMatch(item -> dragon.method_5858((class_1297)item) <= 256.0);
        return !foodNearby && dragon.isDragonWandering() && !dragon.isArmed() && dragon.method_5968() == null && dragon.isAbleToFly() && dragon.canMove();
    }

    @Override
    public void start(BddDragon dragon, class_1937 level) {
        if (!dragon.isFlying()) {
            ++this.ticksSinceLanding;
            this.ticksSinceFlying = 0;
        } else {
            ++this.ticksSinceFlying;
        }
        if (dragon.isDiving() && dragon.method_24828()) {
            dragon.setDiving(false);
            dragon.setFlying(false);
            this.ticksSinceLanding = 0;
            this.ticksSinceFlying = 0;
            dragon.method_5942().method_6340();
            dragon.method_18800(dragon.method_18798().field_1352, 0.0, dragon.method_18798().field_1350);
            this.selectRandomTarget(dragon, level);
        }
        if (this.ticksUntilFlightCheck > 0) {
            --this.ticksUntilFlightCheck;
        } else {
            this.ticksUntilFlightCheck = this.FLIGHT_CHECK_TICKS;
            if (!dragon.isFlying() && dragon.isAbleToFly() && dragon.random.nextFloat() < 0.35f && dragon.method_24828() && this.ticksSinceLanding >= this.LANDING_GRACE_TICKS) {
                dragon.method_6043();
                dragon.setFlying(true);
                this.selectRandomTarget(dragon, level);
            } else if (dragon.isFlying() && !dragon.isDiving() && dragon.random.nextFloat() < 0.8f) {
                dragon.setFlying(false);
                dragon.setDiving(true);
                this.ticksSinceLanding = 0;
                this.ticksSinceFlying = 0;
                dragon.method_5942().method_6340();
                dragon.method_18800(dragon.method_18798().field_1352, 0.0, dragon.method_18798().field_1350);
                dragon.setDiving(false);
                this.selectRandomTarget(dragon, level);
            }
        }
        if (dragon.isFlying() && !dragon.isHovering() && !dragon.isGoingUp() && !dragon.isDiving()) {
            if (this.ticksUntilVerticalChange > 0) {
                --this.ticksUntilVerticalChange;
            } else if (this.ticksSinceFlying >= this.MIN_FLYING_TICKS) {
                this.ticksUntilVerticalChange = this.VERTICAL_CHECK_TICKS;
                if (dragon.random.nextFloat() < 0.5f) {
                    boolean shouldDive = dragon.random.nextBoolean();
                    if (shouldDive) {
                        dragon.setDiving(true);
                        dragon.setGoingUp(false);
                    } else {
                        dragon.setGoingUp(true);
                        dragon.setDiving(false);
                    }
                    this.verticalActionDuration = dragon.random.nextInt(this.VERTICAL_ACTION_MIN_TICKS, this.VERTICAL_ACTION_MAX_TICKS + 1);
                }
            }
        } else if (dragon.isFlying() && (dragon.isGoingUp() || dragon.isDiving())) {
            if (this.verticalActionDuration > 0) {
                --this.verticalActionDuration;
            } else {
                dragon.setGoingUp(false);
                dragon.setDiving(false);
                this.ticksUntilVerticalChange = this.VERTICAL_CHECK_TICKS;
            }
        }
        if (dragon.isFlying()) {
            this.selectRandomTarget(dragon, level);
        }
        if (dragon.targetPosition != null && dragon.isFlying()) {
            dragon.method_5942().method_6337((double)dragon.targetPosition.method_10263() + 0.5, (double)dragon.targetPosition.method_10264(), (double)dragon.targetPosition.method_10260() + 0.5, (double)(dragon.method_49484() * 8.0f));
        }
    }

    @Override
    public void stop(BddDragon dragon, class_1937 level) {
        dragon.method_5942().method_6340();
        dragon.method_18800(dragon.method_18798().field_1352, 0.0, dragon.method_18798().field_1350);
        dragon.setFlying(false);
        dragon.setDiving(false);
        dragon.setGoingUp(false);
        this.ticksUntilNewTarget = 0;
        this.ticksUntilFlightCheck = 0;
        this.ticksSinceLanding = 0;
        this.ticksSinceFlying = 0;
        this.ticksUntilVerticalChange = 0;
        this.verticalActionDuration = 0;
        dragon.targetPosition = null;
    }

    private void selectRandomTarget(BddDragon dragon, class_1937 level) {
        if (!dragon.method_18410()) {
            dragon.targetPosition = null;
            return;
        }
        class_2338 restrictCenter = dragon.method_18412();
        float restrictRadius = dragon.method_18413();
        double angle = dragon.random.nextDouble() * 2.0 * Math.PI;
        double radius = Math.sqrt(dragon.random.nextDouble()) * (double)restrictRadius * 0.9;
        double offsetX = radius * Math.cos(angle);
        double offsetZ = radius * Math.sin(angle);
        double offsetY = radius * Math.sin(angle);
        double targetX = (double)restrictCenter.method_10263() + offsetX;
        double targetY = (double)restrictCenter.method_10264() + offsetY;
        double targetZ = (double)restrictCenter.method_10260() + offsetZ;
        targetY = class_3532.method_15350((double)targetY, (double)(level.method_31607() + 1), (double)(level.method_31600() - 1));
        dragon.targetPosition = new class_2338((int)targetX, (int)targetY, (int)targetZ);
        if (!dragon.method_5942().method_6333(dragon.targetPosition)) {
            dragon.targetPosition = null;
        }
    }
}

