/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.ai.behaviors;

import com.bdc.bdd.api.ai_stuffs.DragonBehavior;
import com.bdc.bdd.api.entity.BddDragon;
import com.bdc.bdd.util.BddUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;

public class FollowingBehavior
implements DragonBehavior<BddDragon> {
    protected final double ASCEND_START = 2.0;
    protected final double ASCEND_STOP = 1.0;
    protected final double DESCEND_START = 2.0;
    protected final double DESCEND_STOP = 1.0;
    protected final int VSTATE_MIN_HOLD = BddUtil.secondsToTicks(1) / 2;
    protected final double FOLLOW_RADIUS_SQR = 100.0;
    protected final double HOVER_MIN_DISTANCE_SQR = 4.0;
    protected final double HOVER_START_BELOW = 0.5;
    protected final double HOVER_STOP_BELOW = 1.5;
    protected static final double FOLLOW_STOP_DISTANCE = 5.0;
    protected static final double FOLLOW_START_DISTANCE = 5.5;
    protected static final double FOLLOW_STOP_SQR = 25.0;
    protected static final double FOLLOW_START_SQR = 30.25;
    protected double lastPlayerY = 0.0;
    private VState vState = VState.NEUTRAL;
    protected int vHoldTicks = 0;
    protected boolean followActive = true;

    @Override
    public boolean canStart(BddDragon dragon, class_1937 level) {
        return dragon.isDragonFollowing() && dragon.method_35057() instanceof class_1657 && !dragon.method_35057().method_7325() && dragon.canMove();
    }

    @Override
    public void start(BddDragon dragon, class_1937 level) {
        boolean canHover;
        boolean withinHoverRange;
        class_1657 owner = (class_1657)dragon.method_35057();
        if (owner == null) {
            dragon.method_5942().method_6340();
            return;
        }
        double distanceToOwnerSqr = dragon.method_5858((class_1297)owner);
        double ownerY = owner.method_23318();
        double dragonY = dragon.method_23318();
        double verticalDistance = Math.abs(dragonY - ownerY);
        boolean bl = withinHoverRange = distanceToOwnerSqr <= 100.0;
        if (this.followActive) {
            if (distanceToOwnerSqr <= 25.0) {
                this.followActive = false;
            }
        } else if (distanceToOwnerSqr >= 30.25) {
            this.followActive = true;
        }
        if (verticalDistance > 10.0 && dragon.isAbleToFly()) {
            if (!dragon.isFlying()) {
                dragon.method_6043();
                dragon.setFlying(true);
                dragon.ticksSinceLanding = 0;
                dragon.ticksSinceFlying = 0;
            }
            dragon.setHovering(false);
            dragon.method_5942().method_6337(owner.method_23317(), owner.method_23318(), owner.method_23321(), (double)dragon.method_49484());
            dragon.targetPosition = new class_2338((int)owner.method_23317(), (int)owner.method_23318(), (int)owner.method_23321());
            this.lastPlayerY = ownerY;
            return;
        }
        boolean currentlyHovering = dragon.isHovering();
        double yDeltaRelative = dragonY - ownerY;
        boolean bl2 = canHover = dragon.isFlying() && withinHoverRange && distanceToOwnerSqr > 4.0;
        if (!this.followActive) {
            if (currentlyHovering) {
                boolean leaveHover;
                boolean bl3 = leaveHover = !canHover || yDeltaRelative < -1.5;
                if (leaveHover) {
                    dragon.setHovering(false);
                } else {
                    dragon.setGoingUp(false);
                    dragon.setDiving(false);
                    dragon.method_5942().method_6340();
                    dragon.method_18799(class_243.field_1353);
                    dragon.targetPosition = null;
                    this.lastPlayerY = ownerY;
                    return;
                }
            }
            if (canHover && yDeltaRelative >= -0.5) {
                dragon.setHovering(true);
                dragon.setFlying(true);
                dragon.setGoingUp(false);
                dragon.setDiving(false);
                dragon.method_5942().method_6340();
                dragon.method_18799(class_243.field_1353);
                dragon.targetPosition = null;
                this.lastPlayerY = ownerY;
                return;
            }
            dragon.setHovering(false);
            dragon.setGoingUp(false);
            dragon.setDiving(false);
            dragon.method_5942().method_6340();
            dragon.method_18799(class_243.field_1353);
            dragon.targetPosition = null;
            this.lastPlayerY = ownerY;
            return;
        }
        dragon.setHovering(false);
        this.updateVerticalState(dragon, ownerY - dragonY);
        double speed = dragon.isFlying() ? (double)dragon.method_49484() * 8.0 : (double)dragon.method_6029() * 8.0;
        dragon.method_5942().method_6337(owner.method_23317(), owner.method_23318(), owner.method_23321(), speed);
        dragon.targetPosition = new class_2338((int)owner.method_23317(), (int)owner.method_23318(), (int)owner.method_23321());
        this.lastPlayerY = ownerY;
    }

    private void updateVerticalState(BddDragon dragon, double vDelta) {
        if (this.vHoldTicks > 0) {
            --this.vHoldTicks;
        }
        switch (this.vState.ordinal()) {
            case 1: {
                if (!(vDelta <= 1.0) || this.vHoldTicks != 0) break;
                this.vState = VState.NEUTRAL;
                break;
            }
            case 2: {
                if (!(vDelta >= -1.0) || this.vHoldTicks != 0) break;
                this.vState = VState.NEUTRAL;
                break;
            }
            case 0: {
                if (vDelta >= 2.0) {
                    this.vState = VState.ASCEND;
                    this.vHoldTicks = this.VSTATE_MIN_HOLD;
                    break;
                }
                if (!(vDelta <= -2.0)) break;
                this.vState = VState.DESCEND;
                this.vHoldTicks = this.VSTATE_MIN_HOLD;
            }
        }
        if (this.vState == VState.ASCEND) {
            dragon.setGoingUp(true);
            dragon.setDiving(false);
        } else if (this.vState == VState.DESCEND) {
            dragon.setGoingUp(false);
            dragon.setDiving(true);
        } else {
            dragon.setGoingUp(false);
            dragon.setDiving(false);
        }
    }

    @Override
    public void stop(BddDragon dragon, class_1937 level) {
        dragon.method_5942().method_6340();
        dragon.method_18800(dragon.method_18798().field_1352, 0.0, dragon.method_18798().field_1350);
        dragon.setFlying(false);
        dragon.setHovering(false);
        dragon.setGoingUp(false);
        dragon.setDiving(false);
        dragon.targetPosition = null;
        this.lastPlayerY = 0.0;
        this.vState = VState.NEUTRAL;
        this.vHoldTicks = 0;
        this.followActive = true;
    }

    private static enum VState {
        NEUTRAL,
        ASCEND,
        DESCEND;

    }
}

