/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.ai.behaviors;

import com.bdc.bdd.api.ai_stuffs.DragonBehavior;
import com.bdc.bdd.api.entity.BddDragon;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;

public class FoodSeekingBehavior
implements DragonBehavior<BddDragon> {
    private static final double SEARCH_RADIUS = 16.0;
    private static final double EAT_DISTANCE = 2.5;
    private static final int EATING_DURATION_TICKS = 20;
    private int eatingTicks = 0;
    private class_1542 targetFood = null;

    @Override
    public boolean canStart(BddDragon dragon, class_1937 level) {
        if (dragon.isEating() && this.eatingTicks > 0) {
            return true;
        }
        if (!dragon.needsFood() || !dragon.canMove()) {
            return false;
        }
        this.targetFood = this.findClosestFood(dragon, level);
        return this.targetFood != null && this.targetFood.method_5805();
    }

    @Override
    public void start(BddDragon dragon, class_1937 level) {
        if (this.eatingTicks > 0 || dragon.isEating()) {
            ++this.eatingTicks;
            if (this.eatingTicks >= 20 && this.targetFood != null) {
                if (this.targetFood.method_5805()) {
                    dragon.onFoodEaten();
                    this.targetFood.method_6983().method_7934(1);
                    BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Dragon consumed food item: " + this.targetFood.method_6983().method_7954().getString() + " at position: " + String.valueOf(this.targetFood.method_19538())));
                    if (this.targetFood.method_6983().method_7960()) {
                        this.targetFood.method_31472();
                        this.targetFood.method_31745(class_1297.class_5529.field_26999);
                        BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Food item removed from world at: " + String.valueOf(this.targetFood.method_19538())));
                    }
                    this.targetFood = null;
                }
                dragon.setEating(false);
                this.eatingTicks = 0;
                dragon.method_5942().method_6340();
                return;
            }
            dragon.setEating(true);
            dragon.method_5942().method_6340();
            dragon.method_18799(class_243.field_1353);
            return;
        }
        if (this.targetFood != null && this.targetFood.method_5805()) {
            class_243 foodPos = this.targetFood.method_19538().method_1031(0.0, 0.25, 0.0);
            double distanceToFood = dragon.method_5858((class_1297)this.targetFood);
            if (distanceToFood <= 6.25) {
                dragon.setEating(true);
                dragon.method_5942().method_6340();
                dragon.method_18799(class_243.field_1353);
                this.eatingTicks = 1;
                BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Dragon started eating at distance: " + Math.sqrt(distanceToFood) + " from item at: " + String.valueOf(foodPos)));
            } else {
                double speed;
                double d = speed = dragon.isAbleToFly() && dragon.getAltitude() > 5.0 ? (double)dragon.method_49484() : (double)dragon.method_6029() * 8.0;
                if (dragon.isAbleToFly() && dragon.getAltitude() > 5.0) {
                    dragon.setFlying(true);
                    dragon.method_5942().method_6337(foodPos.field_1352, foodPos.field_1351, foodPos.field_1350, speed);
                } else {
                    dragon.setFlying(false);
                    dragon.method_5942().method_6337(foodPos.field_1352, foodPos.field_1351, foodPos.field_1350, speed);
                }
                BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Dragon moving to food item at: " + String.valueOf(foodPos) + ", distance: " + Math.sqrt(distanceToFood)));
            }
        } else {
            this.targetFood = null;
            this.eatingTicks = 0;
            dragon.setEating(false);
            dragon.method_5942().method_6340();
        }
    }

    @Override
    public void stop(BddDragon dragon, class_1937 level) {
        dragon.setEating(false);
        this.eatingTicks = 0;
        this.targetFood = null;
        dragon.method_5942().method_6340();
        dragon.method_18799(class_243.field_1353);
    }

    private class_1542 findClosestFood(BddDragon dragon, class_1937 level) {
        class_238 searchBox = dragon.method_5829().method_1014(16.0);
        List items = level.method_8390(class_1542.class, searchBox, item -> item.method_5805() && dragon.method_6481(item.method_6983()));
        return items.stream().min(Comparator.comparingDouble(arg_0 -> ((BddDragon)dragon).method_5858(arg_0))).orElse(null);
    }
}

