/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.ai.behaviors;

import com.bdc.bdd.api.ai_stuffs.DragonBehavior;
import com.bdc.bdd.api.entity.BddDragon;
import com.bdc.bdd.api.entity.core_classes.BddBaseDragon;
import com.bdc.bdd.registry.TagRegistry;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;

public class HuntingBehavior
implements DragonBehavior<BddDragon> {
    private static final double SEARCH_RADIUS = 16.0;
    private static final double ATTACK_DISTANCE = 2.2;
    private class_1309 targetPrey = null;

    @Override
    public boolean canStart(BddDragon dragon, class_1937 level) {
        boolean canMove = dragon.canMove();
        int currentHunger = dragon.getHunger();
        boolean isHungryEnoughToHunt = currentHunger <= BddBaseDragon.MIN_HUNGER;
        BaseLogger.log((Level)BaseLogLevel.INFO, (String)("HuntingBehavior: Dragon Hunger: " + currentHunger + ", MIN_HUNGER: " + BddBaseDragon.MIN_HUNGER + ", CanMove: " + canMove + ", IsHungryEnoughToHunt: " + isHungryEnoughToHunt));
        if (!isHungryEnoughToHunt || !canMove) {
            return false;
        }
        this.targetPrey = this.findClosestPrey(dragon, level);
        BaseLogger.log((Level)BaseLogLevel.INFO, (String)("HuntingBehavior: Target Prey found: " + (this.targetPrey != null ? this.targetPrey.method_5477().getString() : "None")));
        return this.targetPrey != null && this.targetPrey.method_5805();
    }

    @Override
    public void start(BddDragon dragon, class_1937 level) {
        if (this.targetPrey != null && this.targetPrey.method_5805()) {
            dragon.method_5980(this.targetPrey);
            double distanceToPrey = dragon.method_5858((class_1297)this.targetPrey);
            if (distanceToPrey <= 4.840000000000001) {
                float damage = dragon.getPower();
                this.targetPrey.method_5643(level.method_48963().method_48812((class_1309)dragon), damage);
                BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Dragon attacked prey: " + this.targetPrey.method_5477().getString() + " for " + damage + " damage at position: " + String.valueOf(this.targetPrey.method_19538())));
                if (!this.targetPrey.method_5805()) {
                    dragon.onFoodEaten();
                    this.targetPrey = null;
                    dragon.method_5980(null);
                    dragon.method_5942().method_6340();
                    dragon.method_5728(false);
                    BaseLogger.log((Level)BaseLogLevel.INFO, (String)"Prey killed, clearing target");
                } else {
                    dragon.method_5942().method_6340();
                    dragon.method_18799(class_243.field_1353);
                    dragon.method_5728(false);
                }
            } else {
                class_243 preyPos = this.targetPrey.method_19538().method_1031(0.0, 0.25, 0.0);
                double speed = dragon.isAbleToFly() && dragon.getAltitude() > 5.0 ? (double)dragon.method_49484() : (double)dragon.method_6029() * 8.0;
                dragon.method_5728(true);
                if (dragon.isAbleToFly() && dragon.getAltitude() > 5.0) {
                    dragon.setFlying(true);
                    dragon.method_5942().method_6337(preyPos.field_1352, preyPos.field_1351, preyPos.field_1350, speed);
                } else {
                    dragon.setFlying(false);
                    dragon.method_5942().method_6337(preyPos.field_1352, preyPos.field_1351, preyPos.field_1350, speed);
                }
                BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Dragon moving to prey: " + this.targetPrey.method_5477().getString() + " at position: " + String.valueOf(preyPos) + ", distance: " + Math.sqrt(distanceToPrey)));
            }
        } else {
            this.targetPrey = null;
            dragon.method_5980(null);
            dragon.method_5942().method_6340();
            dragon.method_5728(false);
            BaseLogger.log((Level)BaseLogLevel.INFO, (String)"No valid prey found, stopping hunting");
        }
    }

    @Override
    public void stop(BddDragon dragon, class_1937 level) {
        dragon.method_5980(null);
        this.targetPrey = null;
        dragon.method_5942().method_6340();
        dragon.method_18799(class_243.field_1353);
        dragon.setFlying(false);
        dragon.method_5728(false);
    }

    private class_1309 findClosestPrey(BddDragon dragon, class_1937 level) {
        class_238 searchBox = dragon.method_5829().method_1014(16.0);
        List preyEntities = level.method_8390(class_1309.class, searchBox, entity -> entity.method_5805() && entity.method_5864().method_20210(TagRegistry.PREY) && entity != dragon);
        return preyEntities.stream().min(Comparator.comparingDouble(arg_0 -> ((BddDragon)dragon).method_5858(arg_0))).orElse(null);
    }
}

