/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.ai.behaviors;

import com.bdc.bdd.api.ai_stuffs.DragonBehavior;
import com.bdc.bdd.api.entity.BddDragon;
import com.bdc.bdd.dragons.SpeedStinger;
import java.util.logging.Level;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;

public class SpeedstingerAttackBehavior
implements DragonBehavior<BddDragon> {
    private static final double AGGRESSION_RADIUS = 5.0;
    private static final double ATTACK_DISTANCE = 2.5;
    private static final double JUMP_ATTACK_CHANCE = 0.3;
    private static final double POISON_CHANCE = 0.5;
    private static final int POISON_DURATION = 100;
    private static final int POISON_AMPLIFIER = 1;
    private class_1657 targetPlayer = null;

    @Override
    public boolean canStart(BddDragon dragon, class_1937 level) {
        if (dragon instanceof SpeedStinger) {
            BaseLogger.log((Level)BaseLogLevel.INFO, (String)"SpeedstingerAttackBehavior: Dragon is not wild or cautious, cannot execute");
            return false;
        }
        class_238 searchBox = dragon.method_5829().method_1014(5.0);
        this.targetPlayer = level.method_8390(class_1657.class, searchBox, player -> player.method_5805() && !player.method_7337() && !player.method_7325() && dragon.isArmedWithinRange(5.0)).stream().findFirst().orElse(null);
        boolean canStart = this.targetPlayer != null && dragon.canMove();
        BaseLogger.log((Level)BaseLogLevel.INFO, (String)("SpeedstingerAttackBehavior: canStart: " + canStart + ", Target Player: " + (this.targetPlayer != null ? this.targetPlayer.method_5477().getString() : "None")));
        return canStart;
    }

    @Override
    public void start(BddDragon dragon, class_1937 level) {
        if (this.targetPlayer != null && this.targetPlayer.method_5805()) {
            dragon.method_5980((class_1309)this.targetPlayer);
            double distanceToPlayer = dragon.method_5858((class_1297)this.targetPlayer);
            dragon.method_5728(true);
            if (distanceToPlayer <= 6.25) {
                class_1657 class_16572;
                boolean isJumpAttack;
                boolean bl = isJumpAttack = dragon.random.nextDouble() < 0.3;
                if (isJumpAttack) {
                    dragon.method_18799(dragon.method_18798().method_1031(0.0, 0.6, 0.0));
                    BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Speedstinger performing jump attack on player: " + this.targetPlayer.method_5477().getString()));
                } else {
                    BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Speedstinger performing run attack on player: " + this.targetPlayer.method_5477().getString()));
                }
                this.targetPlayer.method_5643(level.method_48963().method_48812((class_1309)dragon), dragon.getPower());
                if (dragon.random.nextDouble() < 0.5 && (class_16572 = this.targetPlayer) instanceof class_1309) {
                    class_1657 livingTarget = class_16572;
                    livingTarget.method_6092(new class_1293(class_1294.field_5899, 100, 1));
                    BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Applied poison to player: " + this.targetPlayer.method_5477().getString()));
                }
                dragon.method_5942().method_6340();
                dragon.method_18799(class_243.field_1353);
                dragon.method_5728(false);
            } else {
                double speed;
                class_243 playerPos = this.targetPlayer.method_19538().method_1031(0.0, 0.25, 0.0);
                double d = speed = dragon.isAbleToFly() && dragon.getAltitude() > 5.0 ? (double)dragon.method_49484() : (double)dragon.method_6029() * 10.0;
                if (dragon.isAbleToFly() && dragon.getAltitude() > 5.0) {
                    dragon.setFlying(true);
                    dragon.method_5942().method_6337(playerPos.field_1352, playerPos.field_1351, playerPos.field_1350, speed);
                } else {
                    dragon.setFlying(false);
                    dragon.method_5942().method_6337(playerPos.field_1352, playerPos.field_1351, playerPos.field_1350, speed);
                }
                BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Speedstinger moving to player: " + this.targetPlayer.method_5477().getString() + " at position: " + String.valueOf(playerPos) + ", distance: " + Math.sqrt(distanceToPlayer)));
            }
        } else {
            this.targetPlayer = null;
            dragon.method_5980(null);
            dragon.method_5942().method_6340();
            dragon.method_5728(false);
            BaseLogger.log((Level)BaseLogLevel.INFO, (String)"No valid player target found, stopping Speedstinger attack");
        }
    }

    @Override
    public void stop(BddDragon dragon, class_1937 level) {
        dragon.method_5980(null);
        this.targetPlayer = null;
        dragon.method_5942().method_6340();
        dragon.method_18799(class_243.field_1353);
        dragon.setFlying(false);
        dragon.method_5728(false);
        BaseLogger.log((Level)BaseLogLevel.INFO, (String)"SpeedstingerAttackBehavior stopped");
    }
}

