/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.ai.behaviors;

import com.bdc.bdd.api.ai_stuffs.DragonBehavior;
import com.bdc.bdd.api.entity.BddDragon;
import com.bdc.bdd.util.BddUtil;
import java.util.Random;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3486;
import net.minecraft.class_3532;

public class WanderingBehavior
implements DragonBehavior<BddDragon> {
    public static Random random = new Random();
    private static final double FOOD_SEARCH_RADIUS = 16.0;
    private static final int WATER_AVOID_RADIUS = 2;
    private static final int MAX_TARGET_TRIES = 20;
    private static final double ROTATION_SMOOTHNESS = 0.15;
    private static final float MAX_YAW_CHANGE = 7.5f;
    private static final int TAKEOFF_CHECK_INTERVAL = BddUtil.secondsToTicks(3);
    private static final int MIN_GROUND_TIME = BddUtil.secondsToTicks(5);
    private static final float TAKEOFF_CHANCE = 0.01f;
    private static final double TAKEOFF_JUMP_HEIGHT = 5.0;
    private static final double TAKEOFF_VEL_FUDGE = 1.18;
    private static final double TAKEOFF_XZ_DAMP = 0.35;
    private static final int TAKEOFF_TIMEOUT_TICKS = 40;
    private int ticksUntilNewTarget = 0;
    private final int TARGET_REFRESH_TICKS = random.nextInt(BddUtil.secondsToTicks(7), BddUtil.secondsToTicks(14));
    private int takeoffCooldown = 0;
    private int groundTime = 0;
    private boolean launchingTakeoff = false;
    private double launchStartY = 0.0;
    private double launchTargetY = 0.0;
    private int launchTimeout = 0;

    @Override
    public boolean canStart(BddDragon dragon, class_1937 level) {
        class_238 searchBox = dragon.method_5829().method_1014(16.0);
        boolean foodNearby = level.method_8390(class_1542.class, searchBox, item -> item.method_5805() && dragon.method_6481(item.method_6983())).stream().anyMatch(item -> dragon.method_5858((class_1297)item) <= 256.0);
        return !foodNearby && dragon.isDragonWandering() && !dragon.isFlying() && !dragon.isArmed() && dragon.method_5968() == null && dragon.canMove() && !dragon.isTamingProcessStarted();
    }

    @Override
    public void start(BddDragon dragon, class_1937 level) {
        if (dragon.isFlying()) {
            this.groundTime = 0;
        } else {
            int n = this.groundTime = dragon.method_24828() ? this.groundTime + 1 : 0;
        }
        if (this.takeoffCooldown > 0) {
            --this.takeoffCooldown;
        }
        if (this.launchingTakeoff) {
            this.handleJumpTakeoff(dragon, level);
            return;
        }
        if (!dragon.isFlying() && dragon.canFly() && dragon.method_24828() && this.groundTime >= MIN_GROUND_TIME && this.takeoffCooldown == 0 && dragon.random.nextFloat() < 0.01f && !this.isOnHazardousEdge(dragon, level) && dragon.hasHeadroom(level, dragon.method_24515(), 6) && !dragon.isPostDismountCooldownActive()) {
            this.beginJumpTakeoff(dragon, level);
            this.takeoffCooldown = TAKEOFF_CHECK_INTERVAL + dragon.random.nextInt(BddUtil.secondsToTicks(2));
            return;
        }
        if (this.ticksUntilNewTarget > 0) {
            --this.ticksUntilNewTarget;
        }
        if (dragon.targetPosition == null || this.ticksUntilNewTarget <= 0 || dragon.method_5942().method_6357()) {
            this.selectRandomTarget(dragon, level);
            this.ticksUntilNewTarget = this.TARGET_REFRESH_TICKS;
        }
        if (dragon.targetPosition != null) {
            this.moveToTarget(dragon, level);
        }
    }

    @Override
    public void stop(BddDragon dragon, class_1937 level) {
        dragon.method_5942().method_6340();
        dragon.method_18800(dragon.method_18798().field_1352, 0.0, dragon.method_18798().field_1350);
        this.ticksUntilNewTarget = 0;
        dragon.targetPosition = null;
        this.launchingTakeoff = false;
        this.launchStartY = 0.0;
        this.launchTargetY = 0.0;
        this.launchTimeout = 0;
    }

    private void beginJumpTakeoff(BddDragon dragon, class_1937 level) {
        this.launchingTakeoff = true;
        this.launchStartY = dragon.method_23318();
        this.launchTargetY = Math.min(this.launchStartY + 5.0, (double)(level.method_31600() - 2));
        this.launchTimeout = 40;
        dragon.method_5942().method_6340();
        dragon.targetPosition = null;
        dragon.method_6043();
        double g = 0.08;
        double desiredVy = Math.sqrt(2.0 * g * 5.0) * 1.18;
        class_243 v = dragon.method_18798();
        dragon.method_18800(v.field_1352 * 0.35, Math.max(v.field_1351, desiredVy), v.field_1350 * 0.35);
    }

    private void handleJumpTakeoff(BddDragon dragon, class_1937 level) {
        if (!dragon.canFly()) {
            this.launchingTakeoff = false;
            return;
        }
        if (dragon.method_23318() >= this.launchTargetY - 0.1) {
            if (!dragon.method_24828()) {
                dragon.setFlying(true);
            }
            this.launchingTakeoff = false;
            return;
        }
        if (!dragon.method_24828() && dragon.method_18798().field_1351 <= 0.0 && dragon.method_23318() > this.launchStartY + 0.5) {
            dragon.setFlying(true);
            this.launchingTakeoff = false;
            return;
        }
        if (this.launchTimeout-- <= 0) {
            if (!dragon.method_24828()) {
                dragon.setFlying(true);
            }
            this.launchingTakeoff = false;
        }
    }

    private void selectRandomTarget(BddDragon dragon, class_1937 level) {
        if (!dragon.method_18410()) {
            dragon.targetPosition = null;
            return;
        }
        class_2338 restrictCenter = dragon.method_18412();
        float restrictRadius = dragon.method_18413();
        class_2338 targetPos = null;
        for (int tryCount = 0; tryCount < 20; ++tryCount) {
            class_11 path;
            double angle = dragon.random.nextDouble() * 2.0 * Math.PI;
            double radius = Math.sqrt(dragon.random.nextDouble()) * (double)restrictRadius;
            double offsetX = radius * Math.cos(angle);
            double offsetZ = radius * Math.sin(angle);
            double offsetY = 0.0;
            double targetX = (double)restrictCenter.method_10263() + offsetX;
            double targetY = (double)restrictCenter.method_10264() + offsetY;
            double targetZ = (double)restrictCenter.method_10260() + offsetZ;
            targetY = class_3532.method_15350((double)targetY, (double)(level.method_31607() + 1), (double)(level.method_31600() - 1));
            class_2338 groundPos = new class_2338((int)targetX, (int)targetY, (int)targetZ);
            while (groundPos.method_10264() > level.method_31607() && level.method_8320(groundPos.method_10074()).method_26215()) {
                groundPos = groundPos.method_10074();
            }
            if (!this.isValidTarget(level, groundPos, dragon) || (path = dragon.method_5942().method_6348(groundPos, 1)) == null || !path.method_21655()) continue;
            targetPos = groundPos;
            break;
        }
        dragon.targetPosition = targetPos;
    }

    private void moveToTarget(BddDragon dragon, class_1937 level) {
        if (dragon.targetPosition == null) {
            return;
        }
        class_11 path = dragon.method_5942().method_6348(dragon.targetPosition, 1);
        if (path == null || !path.method_21655()) {
            dragon.targetPosition = null;
            return;
        }
        dragon.method_5942().method_6334(path, (double)(dragon.method_6029() * 7.0f));
        class_243 targetVec = new class_243((double)dragon.targetPosition.method_10263() + 0.5 - dragon.method_23317(), 0.0, (double)dragon.targetPosition.method_10260() + 0.5 - dragon.method_23321());
        if (targetVec.method_1027() > 0.01) {
            float targetYaw = (float)(class_3532.method_15349((double)targetVec.field_1350, (double)targetVec.field_1352) * 57.29577951308232 - 90.0);
            float currentYaw = dragon.method_36454();
            float deltaYaw = class_3532.method_15393((float)(targetYaw - currentYaw));
            float smoothedYaw = currentYaw + class_3532.method_15363((float)deltaYaw, (float)-7.5f, (float)7.5f) * 0.15f;
            dragon.method_36456(smoothedYaw);
        }
        if (this.isOnHazardousEdge(dragon, level)) {
            dragon.method_5942().method_6340();
            dragon.method_18800(dragon.method_18798().field_1352 * 0.5, 0.0, dragon.method_18798().field_1350 * 0.5);
            dragon.targetPosition = null;
        }
    }

    private boolean isValidTarget(class_1937 level, class_2338 pos, BddDragon dragon) {
        if (!dragon.method_5942().method_6333(pos)) {
            return false;
        }
        class_2338 below = pos.method_10074();
        if (!level.method_8316(below).method_15769()) {
            return false;
        }
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                class_2338 checkPos = below.method_10069(dx, 0, dz);
                if (!level.method_8316(checkPos).method_15767(class_3486.field_15517)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isOnHazardousEdge(BddDragon dragon, class_1937 level) {
        class_243 movement = dragon.method_18798();
        if (movement.method_1027() < 0.01) {
            return false;
        }
        class_243 pos = dragon.method_19538().method_1019(movement.method_1029().method_1021(1.0));
        class_2338 aheadPos = new class_2338((int)pos.field_1352, (int)dragon.method_23318(), (int)pos.field_1350);
        class_2338 belowAhead = aheadPos.method_10074();
        return level.method_8320(belowAhead).method_26215() || level.method_8316(belowAhead).method_15767(class_3486.field_15517);
    }
}

