/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.core_classes;

import com.bdc.bdd.BddConstants;
import com.bdc.bdd.api.entity.core_classes.BddBaseDragon;
import com.bdc.bdd.api.util.DragonAbilities;
import com.bdc.bdd.projectile.BaseLinearBoltProjectile;
import com.bdc.bdd.projectile.BaseLinearFlightProjectile;
import com.bdc.bdd.projectile.fire_ball.FireBolt;
import com.bdc.bdd.projectile.plasma_blast.PlasmaBlast;
import com.bdc.bdd.projectile.zipple_gas.ZipplebackGas;
import com.bdc.bdd.util.BDDKeyMappings;
import com.bdc.bdd.util.BddUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BddAbilityDragon
extends BddBaseDragon {
    private static final class_2940<Boolean> IS_BITING = class_2945.method_12791(BddAbilityDragon.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> IS_ROARING = class_2945.method_12791(BddAbilityDragon.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> TAIL_WHIPPING = class_2945.method_12791(BddAbilityDragon.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> GAS_SPARK = class_2945.method_12791(BddAbilityDragon.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> FIRE_BREATH_FUEL = class_2945.method_12791(BddAbilityDragon.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> BREATHING_FIRE = class_2945.method_12791(BddAbilityDragon.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> F_BREATHING_TICKS = class_2945.method_12791(BddAbilityDragon.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> TICK_SINCE_LAST_FIRE = class_2945.method_12791(BddAbilityDragon.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> MARK_FIRED = class_2945.method_12791(BddAbilityDragon.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> DRAGON_PROJ_SHOTS = class_2945.method_12791(BddAbilityDragon.class, (class_2941)class_2943.field_13327);
    private static final int BITE_COOLDOWN_TICKS = BddUtil.secondsToTicks(1);
    private static final int ROAR_COOLDOWN_TICKS = 16;
    private static final int TAIL_WHIP_COOLDOWN_TICKS = BddUtil.secondsToTicks(1);
    private static final int SHOT_REGEN_COOLDOWN_TICKS = BddUtil.minutesToSeconds(2);
    private static final int FUEL_REGEN_COOLDOWN_TICKS = BddUtil.secondsToTicks(5);
    public static final int MAX_FUEL = 2800;
    private static final int MAX_SHOTS = 6;
    private static final int FUEL_CONSUMPTION = 10;
    private static final int FUEL_REGEN_AMOUNT = 2;
    private static final int TICKS_SINCE_LAST_PROJ_SHOOT_SET = 20;
    private int biteTicks = 0;
    private int roarTicks = 0;
    private static final int BITE_DURATION = BddUtil.secondsToTicks(1);
    private static final int ROAR_DURATION = BddUtil.secondsToTicks(2);
    private final List<DragonAbilities> abilities = new ArrayList<DragonAbilities>();
    private int playerBoltBlastPendingScale = 0;
    private int playerBoltBlastPendingStopThreshold = 0;
    public int biteCooldown = 0;
    private int roarCooldown = 0;
    private int tailWhipCooldown = 0;
    private int explosionStrength = 5;
    private int projSize = 0;
    private int shotRegenCooldown = 0;
    private int fuelRegenCooldown = 0;

    public BddAbilityDragon(class_1299<? extends class_1321> entityType, class_1937 level) {
        super(entityType, level);
        this.initializeAbilities();
    }

    public void initializeAbilities() {
        this.addAbility(DragonAbilities.ROAR);
        this.addAbility(DragonAbilities.BITE);
        this.addAbility(DragonAbilities.TAIL_WHIP);
        this.addAbility(DragonAbilities.FLIGHT_LOCK);
        this.addAbility(DragonAbilities.HOVER);
        this.addAbility(DragonAbilities.SPEED_UP);
        this.addAbility(DragonAbilities.SPEED_DOWN);
    }

    @Override
    protected void method_5693(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(IS_BITING, (Object)false);
        builder.method_56912(IS_ROARING, (Object)false);
        builder.method_56912(TAIL_WHIPPING, (Object)false);
        builder.method_56912(GAS_SPARK, (Object)false);
        builder.method_56912(BREATHING_FIRE, (Object)false);
        builder.method_56912(FIRE_BREATH_FUEL, (Object)2800);
        builder.method_56912(F_BREATHING_TICKS, (Object)0);
        builder.method_56912(MARK_FIRED, (Object)false);
        builder.method_56912(TICK_SINCE_LAST_FIRE, (Object)0);
        builder.method_56912(DRAGON_PROJ_SHOTS, (Object)6);
    }

    @Override
    public void method_5652(@NotNull class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("Biting", this.isBiting());
        compound.method_10556("Roaring", this.isRoaring());
        compound.method_10556("TailWhip", this.isTailWhipping());
        compound.method_10556("SecondAbility", this.isUsingSecondAbility());
        compound.method_10569("RemainingFuel", this.getRemainingFuel());
        compound.method_10569("BreathingTicks", this.getFRemainingTicks());
        compound.method_10556("FireBreathing", this.isBreathingFire());
        compound.method_10556("MarkFired", this.isMarkFired());
        compound.method_10569("TicksFire", this.getTicksSinceLastFire());
        compound.method_10569("FireBlastShots", this.getProjectileShots());
        class_2499 abilitiesTag = new class_2499();
        for (DragonAbilities ability : this.abilities) {
            abilitiesTag.add((Object)class_2519.method_23256((String)ability.name()));
        }
        compound.method_10566("Abilities", (class_2520)abilitiesTag);
    }

    @Override
    public void method_5749(@NotNull class_2487 compound) {
        super.method_5749(compound);
        this.setBiting(compound.method_10577("Biting"));
        this.setRoaring(compound.method_10577("Roaring"));
        this.setTailWhipping(compound.method_10577("TailWhip"));
        this.setUsingSecondAbility(compound.method_10577("SecondAbility"));
        this.setRemainingFuel(compound.method_10550("RemainingFuel"));
        this.setFRemainingTicks(compound.method_10550("BreathingTicks"));
        this.setBreathingFire(compound.method_10577("FireBreathing"));
        this.setTicksSinceLastFire(compound.method_10550("TicksFire"));
        this.setMarkFired(compound.method_10577("MarkFired"));
        this.setProjectileShots(compound.method_10550("FireBlastShots"));
        this.abilities.clear();
        class_2499 abilitiesTag = compound.method_10554("Abilities", 8);
        for (int i = 0; i < abilitiesTag.size(); ++i) {
            String abilityName = abilitiesTag.method_10608(i);
            try {
                DragonAbilities ability = DragonAbilities.valueOf(abilityName);
                this.abilities.add(ability);
                continue;
            }
            catch (IllegalArgumentException e) {
                System.err.println("Invalid ability name in NBT: " + abilityName);
            }
        }
    }

    @Override
    public void addAbility(DragonAbilities ability) {
        if (ability != null && !this.abilities.contains((Object)ability)) {
            this.abilities.add(ability);
        }
    }

    @Override
    public boolean hasAbility(DragonAbilities ability) {
        return ability != null && this.abilities.contains((Object)ability);
    }

    @Override
    public List<DragonAbilities> getAbilities() {
        return new ArrayList<DragonAbilities>(this.abilities);
    }

    public boolean isBiting() {
        return this.hasAbility(DragonAbilities.BITE) && (Boolean)this.field_6011.method_12789(IS_BITING) != false;
    }

    public void setBiting(boolean biting) {
        if (this.hasAbility(DragonAbilities.BITE)) {
            this.field_6011.method_12778(IS_BITING, (Object)biting);
        }
        if (biting) {
            this.biteTicks = 0;
        }
        this.attackEntityInFront(this.getThroatPos1(this));
    }

    public boolean isRoaring() {
        return this.hasAbility(DragonAbilities.ROAR) && (Boolean)this.field_6011.method_12789(IS_ROARING) != false;
    }

    public void setRoaring(boolean roaring) {
        if (this.hasAbility(DragonAbilities.ROAR)) {
            this.field_6011.method_12778(IS_ROARING, (Object)roaring);
        }
        if (roaring) {
            this.roarTicks = 0;
        }
    }

    public boolean isTailWhipping() {
        return this.hasAbility(DragonAbilities.TAIL_WHIP) && (Boolean)this.field_6011.method_12789(TAIL_WHIPPING) != false;
    }

    public void setTailWhipping(boolean value) {
        if (this.hasAbility(DragonAbilities.TAIL_WHIP)) {
            this.field_6011.method_12778(TAIL_WHIPPING, (Object)value);
        }
    }

    public boolean isUsingSecondAbility() {
        return this.hasAbility(DragonAbilities.GAS_SPARK) && (Boolean)this.field_6011.method_12789(GAS_SPARK) != false;
    }

    public void setUsingSecondAbility(boolean value) {
        if (this.hasAbility(DragonAbilities.GAS_SPARK)) {
            this.field_6011.method_12778(GAS_SPARK, (Object)value);
        }
    }

    public boolean isBreathingFire() {
        return (Boolean)this.field_6011.method_12789(BREATHING_FIRE);
    }

    public void setBreathingFire(boolean breathing) {
        this.field_6011.method_12778(BREATHING_FIRE, (Object)breathing);
    }

    public int getRemainingFuel() {
        return (Integer)this.field_6011.method_12789(FIRE_BREATH_FUEL);
    }

    public void setRemainingFuel(int fuel) {
        this.field_6011.method_12778(FIRE_BREATH_FUEL, (Object)class_3532.method_15340((int)fuel, (int)0, (int)2800));
    }

    public int getFRemainingTicks() {
        return (Integer)this.field_6011.method_12789(F_BREATHING_TICKS);
    }

    public void setFRemainingTicks(int ticks) {
        this.field_6011.method_12778(F_BREATHING_TICKS, (Object)Math.max(ticks, 0));
    }

    public int getProjectileShots() {
        return (Integer)this.field_6011.method_12789(DRAGON_PROJ_SHOTS);
    }

    public void setProjectileShots(int shots) {
        this.field_6011.method_12778(DRAGON_PROJ_SHOTS, (Object)class_3532.method_15340((int)shots, (int)0, (int)6));
    }

    public boolean isMarkFired() {
        return (Boolean)this.field_6011.method_12789(MARK_FIRED);
    }

    public void setMarkFired(boolean fired) {
        this.field_6011.method_12778(MARK_FIRED, (Object)fired);
    }

    public int getTicksSinceLastFire() {
        return (Integer)this.field_6011.method_12789(TICK_SINCE_LAST_FIRE);
    }

    public void setTicksSinceLastFire(int ticks) {
        this.field_6011.method_12778(TICK_SINCE_LAST_FIRE, (Object)Math.max(ticks, 0));
    }

    public boolean hasTwoHeads() {
        return false;
    }

    @Override
    public void method_5773() {
        class_1309 class_13092;
        super.method_5773();
        class_243 throatPos1 = this.getThroatPos1(this);
        class_243 throatPos2 = this.getThroatPos2(this);
        class_243 tailPos = this.getTailPos(this);
        if (this.biteCooldown > 0 && --this.biteCooldown == 0) {
            this.setBiting(false);
        }
        if (this.roarCooldown > 0 && --this.roarCooldown == 0) {
            this.setRoaring(false);
        }
        if (this.tailWhipCooldown > 0 && --this.tailWhipCooldown == 0) {
            this.setTailWhipping(false);
        }
        if (this.shotRegenCooldown > 0) {
            --this.shotRegenCooldown;
        }
        if (this.fuelRegenCooldown > 0) {
            --this.fuelRegenCooldown;
        }
        if ((class_13092 = this.method_5642()) instanceof class_1657) {
            boolean hasProjectileAbility;
            class_1657 rider = (class_1657)class_13092;
            class_243 riderLook = rider.method_5828(1.0f);
            int ticksLimit = this.getMaxPlayerBoltBlast();
            if (this.isBiting() && this.biteCooldown == 0) {
                this.setBiting(true);
                this.biteCooldown = BITE_COOLDOWN_TICKS;
            }
            if (this.isRoaring() && this.roarCooldown == 0) {
                this.setRoaring(true);
                this.roarCooldown = 16;
                this.method_5783(class_3417.field_14733, this.method_6107(), this.method_6017());
            }
            if (this.isBiting()) {
                ++this.biteTicks;
                if (this.biteTicks >= BITE_DURATION) {
                    this.setBiting(false);
                    this.biteTicks = 0;
                }
            }
            if (this.isRoaring()) {
                ++this.roarTicks;
                if (this.roarTicks >= ROAR_DURATION) {
                    this.setRoaring(false);
                    this.roarTicks = 0;
                }
            }
            if (this.isTailWhipping() && this.tailWhipCooldown == 0) {
                this.setTailWhipping(true);
                this.tailWhipCooldown = TAIL_WHIP_COOLDOWN_TICKS;
                this.attackEntityWithTail(tailPos);
            }
            if (this.isBreathingFire() && this.getRemainingFuel() >= 10) {
                if (this.hasAbility(DragonAbilities.FIRE_BREATH)) {
                    this.setBreathingFire(true);
                    this.modifyFuel(-10);
                    this.setFRemainingTicks(20);
                    class_243 lookVec = this.method_5720();
                    this.doFireBreathStream(throatPos1, lookVec);
                } else if (this.hasAbility(DragonAbilities.GAS_BOMB)) {
                    this.setBreathingFire(true);
                    this.modifyFuel(-10);
                    this.setFRemainingTicks(20);
                    this.fireGas(riderLook, throatPos1);
                }
            } else {
                this.setBreathingFire(false);
            }
            Object zipCloud = this.getNearestGasCloud(this.field_6002.method_18467(ZipplebackGas.ZippleBackAOECloud.class, this.getTargetSearchArea(this.getFollowDistance())), (class_1309)this, this.method_23317(), this.method_23320(), this.method_23321());
            if (this.isUsingSecondAbility() && this.hasAbility(DragonAbilities.GAS_SPARK)) {
                this.setUsingSecondAbility(true);
                this.field_6002.method_8406((class_2394)class_2398.field_11239, throatPos2.field_1352, throatPos2.field_1351 - 0.3, throatPos2.field_1350, 1.0, 1.0, 1.0);
                this.method_5783(class_3417.field_15145, 15.0f, 1.0f);
                if (zipCloud != null) {
                    ((ZipplebackGas.ZippleBackAOECloud)((Object)zipCloud)).method_5643(this.method_48923().method_48794(), 1.0f);
                }
            }
            boolean bl = hasProjectileAbility = this.hasAbility(DragonAbilities.FIRE_BLAST) || this.hasAbility(DragonAbilities.PLASMA_BLAST);
            if (this.isMarkFired() && hasProjectileAbility && this.getProjectileShots() > 0) {
                this.setMarkFired(true);
                ++this.playerBoltBlastPendingStopThreshold;
                if (this.playerBoltBlastPendingScale <= ticksLimit + 1 && (double)this.playerBoltBlastPendingStopThreshold < (double)ticksLimit * 1.1) {
                    ++this.playerBoltBlastPendingScale;
                }
            } else if (this.playerBoltBlastPendingScale > 0) {
                --this.playerBoltBlastPendingScale;
                --this.playerBoltBlastPendingStopThreshold;
            }
            if (this.canFireProj()) {
                this.fireProjectile(riderLook, throatPos1);
            }
        }
        if (this.shotRegenCooldown == 0 && this.getProjectileShots() < 6) {
            this.setProjectileShots(this.getProjectileShots() + 1);
            this.shotRegenCooldown = SHOT_REGEN_COOLDOWN_TICKS;
        }
        if (this.fuelRegenCooldown == 0 && this.getRemainingFuel() < 2800 && !this.isBreathingFire()) {
            this.modifyFuel(2);
            this.fuelRegenCooldown = FUEL_REGEN_COOLDOWN_TICKS;
        }
        if (this.getFRemainingTicks() > 0) {
            this.setFRemainingTicks(this.getFRemainingTicks() - 1);
        }
        if (this.getFRemainingTicks() <= 0 && this.method_5642() == null) {
            this.setBreathingFire(false);
        }
        if (this.getTicksSinceLastFire() > 0) {
            this.setTicksSinceLastFire(this.getTicksSinceLastFire() - 1);
        }
        this.setMarkFired(this.getTicksSinceLastFire() >= 2);
        if (this.tier1()) {
            this.setProjsSize(0);
        } else if (this.tier2()) {
            this.setProjsSize(1);
        } else if (this.tier3()) {
            this.setProjsSize(2);
        } else if (this.tier4()) {
            this.setProjsSize(3);
        }
        this.setExplosionStrength();
    }

    public void doFireBreathStream(class_243 mouthPos, class_243 lookVec) {
        class_1937 level = this.method_37908();
        double step = 0.2;
        double maxDistance = 20.0;
        double spreadAngle = 0.3;
        for (double d = 0.0; d < maxDistance; d += step) {
            double spreadRadius = d * Math.tan(spreadAngle);
            for (int i = 0; i < 5; ++i) {
                class_2338 blockPos;
                double offsetX = (this.random.nextDouble() - 0.5) * spreadRadius;
                double offsetY = (this.random.nextDouble() - 0.5) * spreadRadius;
                double offsetZ = (this.random.nextDouble() - 0.5) * spreadRadius;
                class_243 pos = mouthPos.method_1019(lookVec.method_1021(d)).method_1031(offsetX, offsetY, offsetZ);
                level.method_8406((class_2394)class_2398.field_11240, pos.field_1352, pos.field_1351, pos.field_1350, 0.0, 0.0, 0.0);
                if (this.random.nextFloat() < 0.3f) {
                    level.method_8406((class_2394)class_2398.field_11251, pos.field_1352, pos.field_1351, pos.field_1350, 0.0, 0.0, 0.0);
                }
                if (this.random.nextFloat() < 0.1f) {
                    level.method_8406((class_2394)class_2398.field_11237, pos.field_1352, pos.field_1351, pos.field_1350, 0.0, 0.0, 0.0);
                }
                if (!level.method_8320(blockPos = new class_2338((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350)).method_26215() || !level.method_8320(blockPos.method_10074()).method_26216((class_1922)level, blockPos.method_10074()) || !(this.random.nextFloat() < 0.08f)) continue;
                level.method_8501(blockPos, class_2246.field_10036.method_9564());
            }
            class_238 hitbox = new class_238(mouthPos.field_1352 - spreadRadius, mouthPos.field_1351 - spreadRadius, mouthPos.field_1350 - spreadRadius, mouthPos.field_1352 + spreadRadius, mouthPos.field_1351 + spreadRadius, mouthPos.field_1350 + spreadRadius).method_997(lookVec.method_1021(d));
            for (class_1297 entity : level.method_8335((class_1297)this, hitbox)) {
                if (entity == this || !entity.method_5805()) continue;
                entity.method_20803(2);
                entity.method_5643(this.method_48923().method_48794(), 2.0f);
            }
        }
    }

    public class_238 getTargetSearchArea(double distance) {
        return this.method_5829().method_1009(distance, distance, distance);
    }

    public double getFollowDistance() {
        return this.method_45325(class_5134.field_23717);
    }

    @Nullable
    public <T extends ZipplebackGas.ZippleBackAOECloud> T getNearestGasCloud(List<? extends T> entities, @Nullable class_1309 attacker, double x, double y, double z) {
        double minDistance = -1.0;
        ZipplebackGas.ZippleBackAOECloud nearest = null;
        for (ZipplebackGas.ZippleBackAOECloud entity : entities) {
            if (!this.test(attacker, entity, 17.0, 3.0, 3.0)) continue;
            double distance = entity.method_5649(x, y, z);
            if (minDistance != -1.0 && !(distance < minDistance)) continue;
            minDistance = distance;
            nearest = entity;
        }
        return (T)((Object)nearest);
    }

    public boolean test(@Nullable class_1309 attacker, ZipplebackGas.ZippleBackAOECloud target, double yRange, double xRange, double zRange) {
        if (attacker == null) {
            return true;
        }
        double xDiff = this.method_23317() - target.method_23317();
        double yDiff = this.method_23318() - target.method_23318();
        double zDiff = this.method_23321() - target.method_23321();
        if (yDiff > yRange || yDiff < -2.0 || xDiff > xRange || zDiff > zRange) {
            return false;
        }
        return this.method_5985().method_6369((class_1297)target);
    }

    public int getProjsSize() {
        return this.projSize;
    }

    public void setProjsSize(int size) {
        this.projSize = size;
    }

    public boolean canFireProj() {
        return !this.method_6109();
    }

    public void modifyFuel(int amount) {
        this.setRemainingFuel(class_3532.method_15340((int)(this.getRemainingFuel() + amount), (int)0, (int)2800));
    }

    public void fireGas(class_243 riderLook, class_243 throat) {
        if (this.random.nextInt(10) == 1) {
            class_243 lookVector = riderLook.method_1029();
            ZipplebackGas gasProj = new ZipplebackGas(this, throat, lookVector, this.method_37908());
            gasProj.setProjectileSize(5);
            gasProj.shoot(lookVector, 3.0f, 4.0);
            this.field_6002.method_8649((class_1297)gasProj);
        }
    }

    public void fireProjectile(class_243 riderLook, class_243 throat) {
        if (!(this.tier1() || this.tier2() || this.tier3() || this.tier4())) {
            return;
        }
        boolean isFireBlast = this.hasAbility(DragonAbilities.FIRE_BLAST);
        boolean isPlasmaBlast = this.hasAbility(DragonAbilities.PLASMA_BLAST);
        boolean isBlastKeyDown = BddConstants.PlatformHelper.MISC.getKey(BDDKeyMappings.BLAST).method_1434();
        if ((isFireBlast || isPlasmaBlast) && !isBlastKeyDown && this.getProjectileShots() > 0 && !this.isMarkFired()) {
            BaseLinearBoltProjectile bolt = isFireBlast ? new FireBolt(this, throat, riderLook, this.field_6002, 8) : new PlasmaBlast(this, throat, riderLook, this.field_6002, 8);
            this.setTicksSinceLastFire(20);
            bolt.shoot(riderLook, 1.0f, this.getBoltProjectileSpeed());
            bolt.setProjectileSize(this.getProjsSize());
            this.method_5783(class_3417.field_14576, 18.0f, 0.05f);
            this.field_6002.method_8649((class_1297)bolt);
            this.setPlayerBoltBlastPendingStopThreshold(0);
            this.setPlayerBoltBlastPendingScale(0);
            this.setProjectileShots(this.getProjectileShots() - 1);
        }
    }

    protected float getBoltProjectileSpeed() {
        return 12.0f;
    }

    public void attackEntityInFront(class_243 throatPos) {
        class_238 area = new class_238(throatPos.field_1352 - 0.5, throatPos.field_1351 - 0.5, throatPos.field_1350 - 0.5, throatPos.field_1352 + 0.5, throatPos.field_1351 + 0.5, throatPos.field_1350 + 0.5);
        for (class_1297 entity : this.field_6002.method_8335((class_1297)this, area)) {
            if (entity == this) continue;
            double damage = this.getPower();
            entity.method_5643(this.method_48923().method_48812((class_1309)this), (float)damage);
            break;
        }
    }

    private void attackEntityWithTail(class_243 tailPos) {
        class_238 area = new class_238(tailPos.field_1352 - 0.5, tailPos.field_1351 - -0.5, tailPos.field_1350 - 0.5, tailPos.field_1352 + 0.5, tailPos.field_1351 + 0.5, tailPos.field_1350 + 0.5);
        for (class_1297 entity : this.field_6002.method_8335((class_1297)this, area)) {
            if (entity == this || !entity.method_5805()) continue;
            double damage = this.getPower();
            entity.method_5643(this.method_48923().method_48812((class_1309)this), (float)damage);
            class_243 knockback = entity.method_19538().method_1020(this.method_19538()).method_1029().method_1021(1.5);
            entity.method_18799(entity.method_18798().method_1031(knockback.field_1352, 0.4, knockback.field_1350));
            entity.field_6037 = true;
            this.method_5783(class_3417.field_14706, this.method_6107(), this.method_6017());
            break;
        }
    }

    public class_243 getThroatPos1(BddAbilityDragon entity) {
        return this.getMatrixPos(entity, this.headMatrix);
    }

    public class_243 getThroatPos2(BddAbilityDragon entity) {
        if (!this.hasTwoHeads()) {
            return this.getThroatPos1(entity);
        }
        return this.getMatrixPos(entity, this.headMatrix2);
    }

    public class_243 getTailPos(BddAbilityDragon entity) {
        return this.getMatrixPos(entity, this.tailMatrix);
    }

    public int getExplosionStrength() {
        return this.explosionStrength;
    }

    public void setExplosionStrength() {
        this.explosionStrength = 5;
    }

    public float getProjectileDamage(BddAbilityDragon dragon, class_1297 entity, BaseLinearFlightProjectile projectile) {
        float f;
        int tier = projectile.getDamageTier();
        float baseDamage = 22.0f;
        if (tier == 1) {
            baseDamage = 20.0f;
        } else if (tier == 2) {
            baseDamage = 21.0f;
        }
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            f = (float)Math.floor(livingEntity.method_6063() * this.getDamageMultiplierForTier(tier));
        } else {
            f = 0.0f;
        }
        float additionalDamage = f;
        return baseDamage + additionalDamage;
    }

    private float getDamageMultiplierForTier(int tier) {
        return switch (tier) {
            case 1 -> 0.05f;
            case 2 -> 0.08f;
            case 3 -> 0.1f;
            case 4 -> 0.11f;
            default -> 0.0f;
        };
    }

    public int getPlayerBoltBlastPendingScale() {
        return this.playerBoltBlastPendingScale;
    }

    public void setPlayerBoltBlastPendingScale(int scale) {
        this.playerBoltBlastPendingScale = scale;
    }

    public void setPlayerBoltBlastPendingStopThreshold(int threshold) {
        this.playerBoltBlastPendingStopThreshold = threshold;
    }

    public int getMaxPlayerBoltBlast() {
        return 40;
    }

    public boolean tier1() {
        return (double)this.getPlayerBoltBlastPendingScale() >= (double)this.getMaxPlayerBoltBlast() * 0.2 && (double)this.getPlayerBoltBlastPendingScale() < (double)this.getMaxPlayerBoltBlast() * 0.5;
    }

    public boolean tier2() {
        return (double)this.getPlayerBoltBlastPendingScale() >= (double)this.getMaxPlayerBoltBlast() * 0.5 && (double)this.getPlayerBoltBlastPendingScale() < (double)this.getMaxPlayerBoltBlast() * 0.75;
    }

    public boolean tier3() {
        return (double)this.getPlayerBoltBlastPendingScale() >= (double)this.getMaxPlayerBoltBlast() * 0.75 && (double)this.getPlayerBoltBlastPendingScale() < (double)this.getMaxPlayerBoltBlast() * 0.92;
    }

    public boolean tier4() {
        return (double)this.getPlayerBoltBlastPendingScale() >= (double)this.getMaxPlayerBoltBlast() * 0.92;
    }
}

