/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.core_classes;

import com.bdc.bdd.BddCommon;
import com.bdc.bdd.BddConstants;
import com.bdc.bdd.api.entity.util.BddLogic;
import com.bdc.bdd.api.entity.util.HomePosition;
import com.bdc.bdd.api.util.DragonAbilities;
import com.bdc.bdd.api.util.DragonAggressionTypes;
import com.bdc.bdd.api.util.DragonCommands;
import com.bdc.bdd.api.util.interfaces.IDragonAbilty;
import com.bdc.bdd.api.util.interfaces.IFlyingDragon;
import com.bdc.bdd.api.util.interfaces.ISaddleableDragon;
import com.bdc.bdd.net.messages.server.DragonHoverPacket;
import com.bdc.bdd.net.messages.server.abilities.DragonAbilityPacket;
import com.bdc.bdd.net.messages.server.abilities.DragonBitePacket;
import com.bdc.bdd.net.messages.server.abilities.DragonRoarPacket;
import com.bdc.bdd.registry.ItemRegistry;
import com.bdc.bdd.registry.builders.entity.BddEntityBuilder;
import com.bdc.bdd.util.BDDKeyMappings;
import com.bdc.bdd.util.BddUtil;
import com.google.gson.JsonElement;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.logging.Level;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1743;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1819;
import net.minecraft.class_1829;
import net.minecraft.class_1835;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_6025;
import net.minecraft.class_6026;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8111;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import software.bluelib.api.entity.variant.IVariantEntity;
import software.bluelib.api.net.NetworkPacket;
import software.bluelib.api.net.NetworkRegistry;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.api.utils.variant.ParameterUtils;
import software.bluelib.loader.animatable.entity.BlueEntity;

public abstract class BddBaseDragon
extends class_1321
implements IVariantEntity<BddBaseDragon>,
IFlyingDragon,
class_6025,
IDragonAbilty,
ISaddleableDragon,
class_6026,
BlueEntity {
    private static final class_2940<Integer> HUNGER = class_2945.method_12791(BddBaseDragon.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> AGE_TICKS = class_2945.method_12791(BddBaseDragon.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> GENDER = class_2945.method_12791(BddBaseDragon.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SLEEPING = class_2945.method_12791(BddBaseDragon.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Float> DRAGON_BOND = class_2945.method_12791(BddBaseDragon.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Integer> COMMANDS = class_2945.method_12791(BddBaseDragon.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> TITAN_WING = class_2945.method_12791(BddBaseDragon.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> EATING = class_2945.method_12791(BddBaseDragon.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> DISTURB_TICKS = class_2945.method_12791(BddBaseDragon.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> DATA_IS_SPRINTING = class_2945.method_12791(BddBaseDragon.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> DRAGON_STAMINA = class_2945.method_12791(BddBaseDragon.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> DRAGON_SPEED = class_2945.method_12791(BddBaseDragon.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Boolean> IS_ROPED = class_2945.method_12791(BddBaseDragon.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> CAN_FLY = class_2945.method_12791(BddBaseDragon.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> DISABLE_AI = class_2945.method_12791(BddBaseDragon.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> TAILFIN = class_2945.method_12791(BddBaseDragon.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> FAKE_TAILFIN = class_2945.method_12791(BddBaseDragon.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> LOCKED = class_2945.method_12791(BddBaseDragon.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> TAME_PROGRESS = class_2945.method_12791(BddBaseDragon.class, (class_2941)class_2943.field_13327);
    public static int MAX_HUNGER = 200;
    public static int MIN_HUNGER = 30;
    public static float DEFAULT_FLYING_SPEED = 0.1f;
    public static float MAX_FLYING_SPEED = 0.3f;
    public static float DEFAULT_ATTACK_DAMAGE = 5.0f;
    public static final int MAX_TAME_PROGRESS = 100;
    public final Random random = new Random();
    public BddLogic logic;
    public long eatingStartTime = 0L;
    @Nullable
    public Matrix4f riderMatrix = null;
    @Nullable
    public Matrix4f headMatrix = null;
    @Nullable
    public Matrix4f headMatrix2 = null;
    @Nullable
    public Matrix4f tailMatrix = null;
    public class_1799 lastFedItem = class_1799.field_8037;
    public class_1657 lastFeederPlayer = null;
    public HomePosition homePosition;
    public boolean hasHomePosition = false;
    public boolean isAggro = false;
    private boolean initialDimensionsRefreshed = false;
    private float bodyRoll = 0.0f;
    public class_2338 targetPosition = null;
    private DragonAggressionTypes aggressionType = DragonAggressionTypes.NEUTRAL;
    public int ticksSinceLanding = 0;
    public int ticksSinceFlying = 0;
    private boolean awaitingAcceptance = false;
    @Nullable
    private UUID candidateOwner = null;
    private boolean tamingProcessStarted = false;
    private int awaitingTicks = 0;
    @Nullable
    private UUID tamingInitiator = null;
    private static final Map<String, Integer> RARITY_WEIGHTS = new HashMap<String, Integer>();

    public BddBaseDragon(class_1299<? extends class_1321> entityType, class_1937 level) {
        super(entityType, level);
        this.field_5985 = true;
        this.method_49476();
        this.logic = this.createDragonLogic();
        this.method_18382();
    }

    public DragonAggressionTypes getAggressionType() {
        return this.aggressionType;
    }

    public void setAggressionType(DragonAggressionTypes aggressionType) {
        this.aggressionType = aggressionType;
    }

    public float getBodyRoll() {
        return this.bodyRoll;
    }

    public void setBodyRoll(float roll) {
        this.bodyRoll = roll;
    }

    protected BddLogic createDragonLogic() {
        return new BddLogic(this);
    }

    public class_2960 returnDragonType() {
        String typeName = class_7923.field_41177.method_10221((Object)this.method_5864()).method_12832();
        List<String> dragonNames = BddEntityBuilder.getDragonNames();
        if (dragonNames.contains(typeName)) {
            return BddCommon.Resource.resource(typeName);
        }
        throw new IllegalStateException("Entity type " + typeName + " is not a registered dragon. Registered dragons: " + String.valueOf(dragonNames));
    }

    protected void method_5693(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(HUNGER, (Object)MAX_HUNGER);
        builder.method_56912(AGE_TICKS, (Object)0);
        builder.method_56912(GENDER, (Object)false);
        builder.method_56912(SLEEPING, (Object)false);
        builder.method_56912(COMMANDS, (Object)DragonCommands.WANDERING.ordinal());
        builder.method_56912(DRAGON_BOND, (Object)Float.valueOf(0.0f));
        builder.method_56912(TITAN_WING, (Object)false);
        builder.method_56912(EATING, (Object)false);
        builder.method_56912(DISTURB_TICKS, (Object)0);
        builder.method_56912(DATA_IS_SPRINTING, (Object)false);
        builder.method_56912(DRAGON_STAMINA, (Object)100);
        builder.method_56912(DRAGON_SPEED, (Object)Float.valueOf(DEFAULT_FLYING_SPEED));
        builder.method_56912(IS_ROPED, (Object)false);
        builder.method_56912(CAN_FLY, (Object)true);
        builder.method_56912(DISABLE_AI, (Object)false);
        builder.method_56912(TAILFIN, (Object)true);
        builder.method_56912(FAKE_TAILFIN, (Object)false);
        builder.method_56912(LOCKED, (Object)false);
        builder.method_56912(TAME_PROGRESS, (Object)0);
    }

    public void method_5652(@NotNull class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("Hunger", this.getHunger());
        compound.method_10569("AgeTicks", this.getAgeInTicks());
        compound.method_10556("Gender", this.isMale());
        compound.method_10556("Sleeping", this.isDragonSleeping());
        compound.method_10569("DisturbTicks", this.getSleepDisturbTicks());
        compound.method_10582("DragonCommand", this.getCommand().name());
        compound.method_10556("TitanWing", this.isTitanWing());
        compound.method_10548("DragonBond", this.getDragonBond());
        compound.method_10569("DragonStamina", this.getDragonStamina());
        compound.method_10548("DragonSpeed", this.method_49484());
        compound.method_10556("Roped", this.isRoped());
        compound.method_10556("CanFly", this.canFly());
        compound.method_10556("DisableAI", this.isAIDisabled());
        compound.method_10556("Tailfin", this.hasTailFin());
        compound.method_10556("FakeTailfin", this.hasFakeTailFin());
        compound.method_10556("HasHomePosition", this.hasHomePosition);
        compound.method_10556("Locked", this.isLocked());
        compound.method_10569("TameProgress", this.getTameProgress());
        compound.method_10556("TamingStarted", this.tamingProcessStarted);
        if (this.tamingInitiator != null) {
            compound.method_25927("TamingInitiator", this.tamingInitiator);
        }
        if (this.homePosition != null && this.hasHomePosition) {
            this.homePosition.write(compound);
        }
    }

    public void method_5749(@NotNull class_2487 compound) {
        super.method_5749(compound);
        this.setHunger(compound.method_10550("Hunger"));
        this.setAgeInTicks(compound.method_10550("AgeTicks"));
        this.setGender(compound.method_10577("Gender"));
        this.setIsDragonSleeping(compound.method_10577("Sleeping"));
        this.setTitanWing(compound.method_10577("TitanWing"));
        this.setDragonBond(compound.method_10583("DragonBond"));
        this.setSleepDisturbTicks(compound.method_10550("DisturbTicks"));
        this.setDragonStamina(compound.method_10550("DragonStamina"));
        this.setRoped(compound.method_10577("Roped"));
        this.setCanFly(compound.method_10577("CanFly"));
        this.setAIDisabled(compound.method_10577("DisableAI"));
        this.setTailFin(compound.method_10577("Tailfin"));
        this.setFakeTailFin(compound.method_10577("FakeTailfin"));
        this.setLocked(compound.method_10577("Locked"));
        this.tamingProcessStarted = compound.method_10577("TamingStarted");
        this.setTameProgress(compound.method_10550("TameProgress"));
        this.setFlyingSpeed(compound.method_10583("DragonSpeed"));
        this.tamingInitiator = compound.method_25928("TamingInitiator") ? compound.method_25926("TamingInitiator") : null;
        if (compound.method_10545("DragonCommand")) {
            try {
                this.setCommand(DragonCommands.valueOf(compound.method_10558("DragonCommand")));
            }
            catch (IllegalArgumentException e) {
                this.setCommand(DragonCommands.WANDERING);
                BaseLogger.log((Level)BaseLogLevel.WARNING, (String)("Invalid command in NBT: " + compound.method_10558("DragonCommand") + ", defaulting to WANDERING"));
            }
        }
        this.hasHomePosition = compound.method_10577("HasHomePosition");
        if (this.hasHomePosition && compound.method_10550("HomeAreaX") != 0 && compound.method_10550("HomeAreaY") != 0 && compound.method_10550("HomeAreaZ") != 0) {
            this.homePosition = new HomePosition(compound, this.method_37908());
        }
        this.method_18382();
    }

    @NotNull
    public class_2338 method_18412() {
        return this.homePosition == null ? super.method_18412() : this.homePosition.getPosition();
    }

    public float method_18413() {
        return this.method_6181() ? 50.0f : 100.0f;
    }

    public String getHomeDimensionName() {
        return this.homePosition == null ? "" : this.homePosition.getDimension();
    }

    public boolean method_18410() {
        return this.hasHomePosition && this.getHomeDimensionName().equals(HomePosition.getDimensionName(this.method_37908())) || super.method_18410();
    }

    public DragonCommands getCommand() {
        return DragonCommands.values()[(Integer)this.field_6011.method_12789(COMMANDS)];
    }

    public void setCommand(DragonCommands command) {
        this.field_6011.method_12778(COMMANDS, (Object)command.ordinal());
    }

    public void method_6170(class_1657 player) {
        super.method_6170(player);
    }

    public boolean isDragonWandering() {
        return this.getCommand() == DragonCommands.WANDERING;
    }

    public boolean isDragonSitting() {
        return this.getCommand() == DragonCommands.SITTING;
    }

    public boolean isDragonFollowing() {
        return this.getCommand() == DragonCommands.FOLLOWING;
    }

    public void setIsDragonWandering(boolean wandering) {
        if (wandering) {
            this.setCommand(DragonCommands.WANDERING);
        }
    }

    public void setIsDragonSitting(boolean sitting) {
        if (sitting) {
            this.setCommand(DragonCommands.SITTING);
        }
    }

    public void setIsDragonFollowing(boolean following) {
        if (following) {
            this.setCommand(DragonCommands.FOLLOWING);
        }
    }

    public boolean isDragonSleeping() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    public void setIsDragonSleeping(boolean sleeping) {
        this.field_6011.method_12778(SLEEPING, (Object)sleeping);
    }

    public void method_5728(boolean sprinting) {
        this.field_6011.method_12778(DATA_IS_SPRINTING, (Object)sprinting);
    }

    public boolean method_5624() {
        return (Boolean)this.field_6011.method_12789(DATA_IS_SPRINTING);
    }

    public boolean isAggro() {
        return this.isAggro;
    }

    public void setAggro(boolean sleeping) {
        this.isAggro = sleeping;
    }

    public float getDragonBond() {
        return ((Float)this.field_6011.method_12789(DRAGON_BOND)).floatValue();
    }

    public void setDragonBond(float bond) {
        this.field_6011.method_12778(DRAGON_BOND, (Object)Float.valueOf(class_3532.method_15363((float)bond, (float)0.0f, (float)1.0f)));
    }

    public int getAgeInDays() {
        return (Integer)this.field_6011.method_12789(AGE_TICKS) / 24000;
    }

    public void setAgeInDays(int age) {
        this.field_6011.method_12778(AGE_TICKS, (Object)(age * 24000));
        this.method_18382();
    }

    @NotNull
    protected class_4048 method_55694(@NotNull class_4050 pose) {
        int stage = this.getDragonStage();
        float[] dimensions = this.getBoundingBoxDimensions(stage);
        float width = dimensions[0];
        float height = dimensions[1];
        return class_4048.method_18384((float)width, (float)height);
    }

    protected float[] getBoundingBoxDimensions(int stage) {
        float[] fArray;
        switch (stage) {
            case 1: {
                float[] fArray2 = new float[2];
                fArray2[0] = 0.5f;
                fArray = fArray2;
                fArray2[1] = 0.7f;
                break;
            }
            case 2: {
                float[] fArray3 = new float[2];
                fArray3[0] = 0.9f;
                fArray = fArray3;
                fArray3[1] = 1.1f;
                break;
            }
            case 3: {
                float[] fArray4 = new float[2];
                fArray4[0] = 1.3f;
                fArray = fArray4;
                fArray4[1] = 1.7f;
                break;
            }
            case 4: {
                float[] fArray5 = new float[2];
                fArray5[0] = 1.7f;
                fArray = fArray5;
                fArray5[1] = 2.2f;
                break;
            }
            default: {
                float[] fArray6 = new float[2];
                fArray6[0] = 1.7f;
                fArray = fArray6;
                fArray6[1] = 2.2f;
            }
        }
        return fArray;
    }

    public void method_18382() {
        double oldX = this.method_23317();
        double oldY = this.method_23318();
        double oldZ = this.method_23321();
        super.method_18382();
        this.method_5814(oldX, oldY, oldZ);
        float[] dimensions = this.getBoundingBoxDimensions(this.getDragonStage());
        this.method_5996(class_5134.field_23717).method_6192((double)(dimensions[0] * 8.0f));
    }

    public int getAgeInTicks() {
        return (Integer)this.field_6011.method_12789(AGE_TICKS);
    }

    public void setAgeInTicks(int age) {
        this.field_6011.method_12778(AGE_TICKS, (Object)Math.max(age, 0));
    }

    public boolean isMale() {
        return (Boolean)this.field_6011.method_12789(GENDER);
    }

    public void setGender(boolean male) {
        this.field_6011.method_12778(GENDER, (Object)male);
    }

    public boolean isTitanWing() {
        return (Boolean)this.field_6011.method_12789(TITAN_WING);
    }

    public void setTitanWing(boolean titanWing) {
        this.field_6011.method_12778(TITAN_WING, (Object)titanWing);
    }

    public int getHunger() {
        return (Integer)this.field_6011.method_12789(HUNGER);
    }

    public void setHunger(int hunger) {
        this.field_6011.method_12778(HUNGER, (Object)class_3532.method_15340((int)hunger, (int)0, (int)MAX_HUNGER));
    }

    public boolean isEating() {
        return (Boolean)this.field_6011.method_12789(EATING);
    }

    public void setEating(boolean eating) {
        this.field_6011.method_12778(EATING, (Object)eating);
    }

    public int getSleepDisturbTicks() {
        return (Integer)this.field_6011.method_12789(DISTURB_TICKS);
    }

    public void setSleepDisturbTicks(int disturbTicks) {
        this.field_6011.method_12778(DISTURB_TICKS, (Object)Math.max(disturbTicks, 0));
    }

    public int getDragonStamina() {
        return (Integer)this.field_6011.method_12789(DRAGON_STAMINA);
    }

    public void setDragonStamina(int stamina) {
        this.field_6011.method_12778(DRAGON_STAMINA, (Object)class_3532.method_15340((int)stamina, (int)0, (int)100));
    }

    public boolean isRoped() {
        return (Boolean)this.field_6011.method_12789(IS_ROPED);
    }

    public void setRoped(boolean roped) {
        this.field_6011.method_12778(IS_ROPED, (Object)roped);
    }

    public boolean hasTailFin() {
        return (Boolean)this.field_6011.method_12789(TAILFIN);
    }

    public void setTailFin(boolean tailFin) {
        this.field_6011.method_12778(TAILFIN, (Object)tailFin);
    }

    public boolean hasFakeTailFin() {
        return (Boolean)this.field_6011.method_12789(FAKE_TAILFIN);
    }

    public void setFakeTailFin(boolean fakeTailFin) {
        this.field_6011.method_12778(FAKE_TAILFIN, (Object)fakeTailFin);
    }

    public boolean isLocked() {
        return (Boolean)this.field_6011.method_12789(LOCKED);
    }

    public void setLocked(boolean locked) {
        this.field_6011.method_12778(LOCKED, (Object)locked);
    }

    public void modifyCommand(class_1657 player) {
        DragonCommands currentCommand = this.getCommand();
        DragonCommands[] commands = DragonCommands.values();
        int nextIndex = (currentCommand.ordinal() + 1) % commands.length;
        this.setCommand(commands[nextIndex]);
        String[] commandMessages = new String[]{"follow", "sit", "wander"};
        player.method_7353(BddCommon.Translation.command(commandMessages[nextIndex], commands[nextIndex].name()), true);
    }

    public void growDragon(int ageInDays) {
        this.setAgeInDays(this.getAgeInDays() + ageInDays);
        this.method_18382();
    }

    public int getDragonStage() {
        int age = this.getAgeInDays();
        if (age >= 100) {
            return 5;
        }
        if (age >= 75) {
            return 4;
        }
        if (age >= 50) {
            return 3;
        }
        if (age >= 25) {
            return 2;
        }
        return 1;
    }

    public boolean isAdult() {
        return this.getDragonStage() == 4;
    }

    public boolean isTeen() {
        return this.getDragonStage() == 3;
    }

    public boolean isJuvenile() {
        return this.getDragonStage() == 2;
    }

    public boolean method_6109() {
        return this.getDragonStage() == 1;
    }

    public int method_5986() {
        return 90;
    }

    public int method_5978() {
        return 75;
    }

    public void method_5773() {
        super.method_5773();
        this.logic.manageDragonBehavior();
        this.logic.updateDragonServer();
        this.logic.handleDragonStamina();
        if (this.isAwaitingAcceptance()) {
            ++this.awaitingTicks;
            if (this.awaitingTicks > BddUtil.secondsToTicks(5)) {
                this.resetTamingProgress();
            }
        } else {
            this.awaitingTicks = 0;
        }
        if (this.field_6002.method_8608()) {
            if (!this.initialDimensionsRefreshed && this.getAgeInDays() >= 100) {
                BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Client: Performing initial dimension refresh in tick for " + this.method_5476().getString() + " (ID: " + this.method_5628() + ")"));
                this.method_18382();
                this.initialDimensionsRefreshed = true;
            }
            this.updateClientControls();
        }
        if (!this.field_6002.method_8608() && this.isTamingProcessStarted()) {
            class_1657 toCheck = null;
            if (this.isAwaitingAcceptance() && this.candidateOwner != null) {
                toCheck = this.field_6002.method_18470(this.candidateOwner);
            } else if (this.tamingInitiator != null) {
                toCheck = this.field_6002.method_18470(this.tamingInitiator);
            }
            if (toCheck != null) {
                double maxDistSqr = 144.0;
                if (toCheck.method_5858((class_1297)this) <= maxDistSqr && (this.isPlayerArmed(toCheck) || this.isPlayerWearingArmor(toCheck))) {
                    toCheck.method_7353((class_2561)class_2561.method_43470((String)"The dragon senses your aggression and backs away. Taming failed."), true);
                    this.resetTamingProgress();
                }
            }
        }
        if (!this.canMove()) {
            this.field_6189.method_6340();
        }
        if (this.isEating() && (long)this.field_6012 - this.eatingStartTime >= (long)BddUtil.secondsToTicks(2)) {
            this.setEating(false);
        }
    }

    public void updateClientControls() {
        NetworkRegistry.sendToServer((NetworkPacket)new DragonAbilityPacket(BddConstants.PlatformHelper.MISC.getKey(BDDKeyMappings.SPEED_UP).method_1434(), DragonAbilities.SPEED_UP, this.method_5628()));
        NetworkRegistry.sendToServer((NetworkPacket)new DragonAbilityPacket(BddConstants.PlatformHelper.MISC.getKey(BDDKeyMappings.SPEED_DOWN).method_1434(), DragonAbilities.SPEED_DOWN, this.method_5628()));
        if (BddConstants.PlatformHelper.MISC.getKey(BDDKeyMappings.HOVER).method_1436()) {
            NetworkRegistry.sendToServer((NetworkPacket)new DragonHoverPacket(this.method_5628()));
        }
        NetworkRegistry.sendToServer((NetworkPacket)new DragonAbilityPacket(BddConstants.PlatformHelper.MISC.getKey(BDDKeyMappings.BLAST).method_1434(), DragonAbilities.FIRE_BREATH, this.method_5628()));
        NetworkRegistry.sendToServer((NetworkPacket)new DragonAbilityPacket(BddConstants.PlatformHelper.MISC.getKey(BDDKeyMappings.BLAST).method_1434(), DragonAbilities.FIRE_BLAST, this.method_5628()));
        NetworkRegistry.sendToServer((NetworkPacket)new DragonAbilityPacket(BddConstants.PlatformHelper.MISC.getKey(BDDKeyMappings.BLAST).method_1434(), DragonAbilities.PLASMA_BLAST, this.method_5628()));
        NetworkRegistry.sendToServer((NetworkPacket)new DragonAbilityPacket(BddConstants.PlatformHelper.MISC.getKey(BDDKeyMappings.BLAST).method_1434(), DragonAbilities.GAS_BOMB, this.method_5628()));
        NetworkRegistry.sendToServer((NetworkPacket)new DragonAbilityPacket(BddConstants.PlatformHelper.MISC.getKey(BDDKeyMappings.SECONDARY_ABILITY).method_1434(), DragonAbilities.GAS_SPARK, this.method_5628()));
        NetworkRegistry.sendToServer((NetworkPacket)new DragonAbilityPacket(BddConstants.PlatformHelper.MISC.getKey(BDDKeyMappings.TAIL_WHIP).method_1434(), DragonAbilities.TAIL_WHIP, this.method_5628()));
        if (BddConstants.PlatformHelper.MISC.getKey(BDDKeyMappings.ROAR).method_1436()) {
            NetworkRegistry.sendToServer((NetworkPacket)new DragonRoarPacket(this.method_5628()));
        }
        if (BddConstants.PlatformHelper.MISC.getKey(BDDKeyMappings.BITE).method_1436()) {
            NetworkRegistry.sendToServer((NetworkPacket)new DragonBitePacket(this.method_5628()));
        }
    }

    public boolean method_5643(@NotNull class_1282 damage, float amount) {
        class_1297 class_12972;
        if (!this.method_5805() && damage != this.field_6002.method_48963().method_48829()) {
            return false;
        }
        if (this.method_5782() && damage.method_5529() != null && this.method_5642() == damage.method_5529()) {
            return false;
        }
        if ((damage.method_49708(class_8111.field_42321) || this.method_5854() != null && damage.method_5529() != null && damage.method_5529().method_5779(this.method_5854())) && this.method_5765()) {
            return false;
        }
        if (damage == this.field_6002.method_48963().method_48822() || damage == this.field_6002.method_48963().method_48798((class_1297)this) || damage == this.field_6002.method_48963().method_48823()) {
            return false;
        }
        if (damage == this.field_6002.method_48963().method_48794() || damage == this.field_6002.method_48963().method_48813() || damage == this.field_6002.method_48963().method_48833()) {
            return false;
        }
        if (amount > 0.0f && !this.method_6181() && (class_12972 = damage.method_5529()) instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            this.method_5980((class_1309)player);
        }
        if (damage.method_5529() != null && damage.method_5529().method_5854() == this) {
            return false;
        }
        this.setSleepDisturbTicks(500);
        return super.method_5643(damage, amount);
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(class_3489.field_15527) || stack.method_31573(class_3489.field_49932) || this.isFavoriteFood(stack);
    }

    public boolean isFavoriteFood(class_1799 stack) {
        return this.getFavoriteFoods().contains(stack.method_7909());
    }

    public boolean isBreedingFood(class_1799 stack) {
        return stack.method_31574(class_1802.field_8766);
    }

    public List<class_1792> getFavoriteFoods() {
        return List.of(class_1802.field_8209);
    }

    public boolean needsFood() {
        return (double)this.getHunger() < (double)MAX_HUNGER / 1.5;
    }

    public boolean canMove() {
        return !this.isDragonSitting() && !this.isDragonSleeping() && !this.isEating() && !this.method_5782() && !this.isAIDisabled();
    }

    public boolean canFly() {
        return (Boolean)this.field_6011.method_12789(CAN_FLY);
    }

    public void setCanFly(boolean canFly) {
        this.field_6011.method_12778(CAN_FLY, (Object)canFly);
    }

    public boolean isAIDisabled() {
        return (Boolean)this.field_6011.method_12789(DISABLE_AI);
    }

    public void setAIDisabled(boolean disableAI) {
        this.field_6011.method_12778(DISABLE_AI, (Object)disableAI);
    }

    public boolean isAwaitingAcceptance() {
        return this.awaitingAcceptance;
    }

    public void setAwaitingAcceptance(boolean awaiting) {
        this.awaitingAcceptance = awaiting;
    }

    public void setCandidateOwner(@Nullable class_1657 player) {
        this.candidateOwner = player != null ? player.method_5667() : null;
    }

    public boolean isCandidateOwner(class_1657 player) {
        return this.candidateOwner != null && this.candidateOwner.equals(player.method_5667());
    }

    public int getTameProgress() {
        return (Integer)this.field_6011.method_12789(TAME_PROGRESS);
    }

    public void setTameProgress(int value) {
        this.field_6011.method_12778(TAME_PROGRESS, (Object)class_3532.method_15340((int)value, (int)0, (int)100));
    }

    public boolean isTamingProcessStarted() {
        return this.tamingProcessStarted;
    }

    public void setTamingProcessStarted(boolean started) {
        this.tamingProcessStarted = started;
    }

    public void resetTamingProgress() {
        class_1937 class_19372;
        this.setTameProgress(0);
        this.setAwaitingAcceptance(false);
        this.setCandidateOwner(null);
        this.awaitingTicks = 0;
        this.setTamingProcessStarted(false);
        this.standUp();
        if (!this.field_6002.field_9236 && (class_19372 = this.field_6002) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_14199((class_2394)class_2398.field_11251, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), 10, 0.5, 0.5, 0.5, 0.1);
        }
        this.method_5783(class_3417.field_14671, 1.0f, 0.8f);
    }

    public void standUp() {
        if (this.isDragonSitting()) {
            this.setCommand(DragonCommands.WANDERING);
        }
        this.method_6179(false);
    }

    public boolean isDragonMoving() {
        return this.method_23317() != this.field_6038 || this.method_23321() != this.field_5989;
    }

    public boolean isMovingOnGround() {
        return this.isBlockBelowSolid() && this.method_18798().method_37268() > 0.001;
    }

    public boolean isBlockBelowSolid() {
        class_2338 entityPos = this.method_24515();
        class_2338 blockBelowPos = entityPos.method_10074();
        return !this.field_6002.method_8320(blockBelowPos).method_26215();
    }

    public float getPower() {
        return (float)this.method_45325(class_5134.field_23721);
    }

    public float method_6029() {
        return (this.method_5624() ? 1.25f : 1.0f) * (float)this.method_45325(class_5134.field_23719);
    }

    public float method_49484() {
        return ((Float)this.field_6011.method_12789(DRAGON_SPEED)).floatValue();
    }

    public void setFlyingSpeed(float speed) {
        this.field_6011.method_12778(DRAGON_SPEED, (Object)Float.valueOf(class_3532.method_15363((float)speed, (float)0.02f, (float)MAX_FLYING_SPEED)));
    }

    protected void method_5623(double y, boolean onGround, @NotNull class_2680 state, @NotNull class_2338 pos) {
    }

    @NotNull
    public class_1269 method_5992(class_1657 player, @NotNull class_1268 hand) {
        this.lastFeederPlayer = player;
        this.lastFedItem = player.method_5998(hand);
        class_1799 stack = player.method_5998(hand);
        if (!this.method_5805()) {
            this.setSleepDisturbTicks(BddUtil.minutesToSeconds(4));
            return super.method_5992(player, hand);
        }
        if (this.isBreedingFood(stack)) {
            return this.handleBreeding(player, hand, stack);
        }
        if (stack.method_7960()) {
            if (player.method_5715() && this.method_6171((class_1309)player)) {
                this.setLocked(!this.isLocked());
                player.method_7353((class_2561)class_2561.method_43470((String)("Dragon is now " + (this.isLocked() ? "Locked" : "Unlocked"))), true);
                return class_1269.field_5812;
            }
            return this.handleEmptyStack(player);
        }
        if (player.method_7337()) {
            if (stack.method_7909() == ItemRegistry.SLEEP_STICK.get()) {
                this.setIsDragonSleeping(!this.isDragonSleeping());
                player.method_7353((class_2561)class_2561.method_43470((String)("Dragon Is Now " + (this.isDragonSleeping() ? "Sleeping" : "Awake"))), true);
            }
            if (stack.method_7909() == ItemRegistry.GROW_STICK.get()) {
                this.growDragon(1);
                player.method_7353((class_2561)class_2561.method_43470((String)("Dragon aged up one day and is now " + this.getAgeInDays() + " old")), true);
            }
            if (stack.method_7909() == ItemRegistry.TAME_STICK.get()) {
                this.method_6170(player);
                if (this.method_35057() != null) {
                    player.method_7353((class_2561)class_2561.method_43470((String)("You now own this dragon: " + this.method_35057().method_5477().getString())), true);
                }
                return class_1269.field_5812;
            }
            if (stack.method_7909() == ItemRegistry.DISABLE_AI_STICK.get()) {
                this.setAIDisabled(!this.isAIDisabled());
                player.method_7353((class_2561)class_2561.method_43470((String)("Dragon AI " + (this.isAIDisabled() ? "Disabled" : "Enabled"))), true);
            }
            if (stack.method_7909() == ItemRegistry.DERPY_STICK.get()) {
                this.setTailFin(!this.hasTailFin());
                player.method_7353((class_2561)class_2561.method_43470((String)"Derpy Stick Used"), true);
            }
        }
        if (stack.method_7909() == class_1802.field_8600 && this.method_6181() && player.method_5715()) {
            if (this.hasHomePosition) {
                this.hasHomePosition = false;
                player.method_7353((class_2561)class_2561.method_43470((String)"Removed Dragon Home Position"), true);
                return class_1269.field_5812;
            }
            class_2338 pos = this.method_24515();
            this.homePosition = new HomePosition(pos, this.method_37908());
            this.hasHomePosition = true;
            player.method_7353((class_2561)class_2561.method_43470((String)("Added Dragon New Dragon Home Position To: " + pos.method_10263() + pos.method_10264() + pos.method_10260() + this.homePosition.getDimension())), true);
            return class_1269.field_5812;
        }
        if (stack.method_7909() == class_1802.field_8600 && this.method_6181()) {
            return this.handleCommands(player);
        }
        if (stack.method_7909() == class_1802.field_8175 && !this.method_6725() && this.method_6181() && this.method_6765()) {
            this.method_6576(stack, this.method_5634());
            stack.method_7934(1);
            player.method_7353((class_2561)class_2561.method_43470((String)"Your Dragon is now saddled"), true);
            return class_1269.field_5812;
        }
        if (stack.method_7909() == ItemRegistry.PROSTHETIC_TAILFIN.get() && !this.hasTailFin() && !this.hasFakeTailFin() && this.method_6725()) {
            this.equipTail(stack, this.method_5634());
            stack.method_7934(1);
            player.method_7353((class_2561)class_2561.method_43470((String)"Prosthetic Tail Equipped"), true);
            return class_1269.field_5812;
        }
        if (this.method_6481(stack)) {
            return this.handleFeedOrTame(player, stack);
        }
        return class_1269.field_5812;
    }

    @NotNull
    public class_1269 handleBreeding(class_1657 player, class_1268 hand, class_1799 stack) {
        if (this.method_6171((class_1309)player) && this.getDragonBond() >= 69.0f) {
            if (!this.field_6002.field_9236 && this.method_5618() == 0 && this.method_6482()) {
                this.method_6475(player, hand, stack);
                this.method_6480(player);
                this.method_32875((class_6880)class_5712.field_28725, (class_1297)this);
                return class_1269.field_5812;
            }
        } else {
            player.method_7353((class_2561)class_2561.method_43470((String)(this.getDragonBond() <= 68.0f ? "bdd.dragonbond.low" : "bdd.only.owner.breed")), false);
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    @NotNull
    public abstract class_1269 handleSpecialInteractions(class_1657 var1, @NotNull class_1268 var2, class_1799 var3);

    public abstract void handleRiding(class_1657 var1);

    @NotNull
    public abstract class_1269 handleEmptyStack(class_1657 var1);

    @NotNull
    public class_1269 handleCommands(class_1657 player) {
        this.modifyCommand(player);
        return class_1269.field_5812;
    }

    @NotNull
    public class_1269 handleFeedOrTame(class_1657 player, class_1799 stack) {
        if (!this.method_6181()) {
            class_3218 serverLevel;
            class_1937 class_19372;
            if (!this.method_6481(stack)) {
                class_1937 class_19373;
                player.method_7353((class_2561)class_2561.method_43470((String)"The dragon refuses to eat that!"), true);
                this.method_5783(class_3417.field_15008, 1.0f, 1.0f);
                if (!this.field_6002.field_9236 && (class_19373 = this.field_6002) instanceof class_3218) {
                    class_3218 serverLevel2 = (class_3218)class_19373;
                    serverLevel2.method_14199((class_2394)class_2398.field_11231, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), 6, 0.5, 0.5, 0.5, 0.1);
                }
                return class_1269.field_5814;
            }
            if (!this.isTamingProcessStarted() && (this.isPlayerArmed(player) || this.isPlayerWearingArmor(player))) {
                class_1937 class_19374;
                player.method_7353((class_2561)class_2561.method_43470((String)"The dragon refuses while you are armed or armored."), true);
                this.method_5783(class_3417.field_15008, 1.0f, 1.0f);
                if (!this.field_6002.field_9236 && (class_19374 = this.field_6002) instanceof class_3218) {
                    class_3218 serverLevel3 = (class_3218)class_19374;
                    serverLevel3.method_14199((class_2394)class_2398.field_11231, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), 6, 0.5, 0.5, 0.5, 0.1);
                }
                return class_1269.field_5814;
            }
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            this.method_5783(class_3417.field_20614, this.method_6107(), this.method_6017());
            if (!this.isTamingProcessStarted()) {
                this.setTamingProcessStarted(true);
                this.tamingInitiator = player.method_5667();
            }
            this.setTamingProcessStarted(true);
            int bondGain = this.isFavoriteFood(stack) ? 10 : this.random.nextInt(1, 5);
            this.setTameProgress(this.getTameProgress() + bondGain);
            player.method_7353((class_2561)class_2561.method_43470((String)("Tame Progress: " + this.getTameProgress() + "/100")), true);
            if (!this.field_6002.field_9236 && (class_19372 = this.field_6002) instanceof class_3218) {
                serverLevel = (class_3218)class_19372;
                serverLevel.method_14199((class_2394)class_2398.field_11201, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), this.isFavoriteFood(stack) ? 6 : 3, 0.5, 0.5, 0.5, 0.1);
            }
            if (this.getTameProgress() >= 100 && !this.isAwaitingAcceptance()) {
                this.field_6189.method_6340();
                this.method_5980(null);
                this.setIsDragonSitting(true);
                this.setAwaitingAcceptance(true);
                this.setCandidateOwner(player);
                this.awaitingTicks = 0;
                player.method_7353((class_2561)class_2561.method_43470((String)"The dragon seems calm... crouch and bond with it."), true);
                if (!this.field_6002.field_9236 && (class_19372 = this.field_6002) instanceof class_3218) {
                    serverLevel = (class_3218)class_19372;
                    for (int i = 0; i < 12; ++i) {
                        double dx = (this.random.nextDouble() - 0.5) * (double)this.method_17681();
                        double dy = this.random.nextDouble() * (double)this.method_17682();
                        double dz = (this.random.nextDouble() - 0.5) * (double)this.method_17681();
                        serverLevel.method_14199((class_2394)class_2398.field_11201, this.method_23317() + dx, this.method_23318() + dy, this.method_23321() + dz, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
            return class_1269.field_5812;
        }
        if (this.isEating()) {
            player.method_7353((class_2561)class_2561.method_43470((String)"This dragon is still chewing."), true);
            return class_1269.field_5811;
        }
        if (this.getHunger() == MAX_HUNGER) {
            player.method_7353((class_2561)class_2561.method_43470((String)"This dragon is already full."), true);
            return class_1269.field_5811;
        }
        int hungerGain = this.isFavoriteFood(stack) ? 8 : 3;
        this.setHunger(this.getHunger() + hungerGain);
        if (this.isFavoriteFood(stack)) {
            this.setDragonBond(this.getDragonBond() + 0.01f);
        }
        this.method_5783(class_3417.field_20614, this.method_6107(), this.method_6017());
        this.setEating(true);
        this.eatingStartTime = this.field_6012;
        if (!player.method_31549().field_7477) {
            stack.method_7934(1);
        }
        return class_1269.field_5812;
    }

    public void onFoodEaten() {
        this.setHunger(this.getHunger() + 1);
        this.field_6002.method_8421((class_1297)this, (byte)-67);
    }

    @NotNull
    public class_1315 method_5943(@NotNull class_5425 level, @NotNull class_1266 difficulty, @NotNull class_3730 type, @Nullable class_1315 spawnDataIn) {
        this.setGender(this.random.nextBoolean());
        this.setAgeInDays(100);
        this.method_6179(false);
        this.setFlyingSpeed(DEFAULT_FLYING_SPEED);
        this.setDragonStamina(100);
        this.setTailFin(true);
        this.setFakeTailFin(false);
        this.setLocked(false);
        if (this.getVariantName().isEmpty() || BddBaseDragon.handleSpawnTypes(type)) {
            this.setVariantName(Objects.requireNonNull(this.getRandomVariant(this.getEntityVariants(this.returnDragonType()), this.returnDragonType().method_12832())));
        }
        BaseLogger.log((Level)BaseLogLevel.SUCCESS, (String)("Dragon Spawned with Variant: " + this.getVariantName()));
        this.setHunger(MAX_HUNGER);
        class_2338 pos = this.method_24515();
        this.homePosition = new HomePosition(pos, this.method_37908());
        this.hasHomePosition = true;
        this.method_18382();
        return super.method_5943(level, difficulty, type, spawnDataIn);
    }

    public static boolean handleSpawnTypes(@NotNull class_3730 type) {
        return type.equals((Object)class_3730.field_16465) || type.equals((Object)class_3730.field_16471) || type.equals((Object)class_3730.field_16469) || type.equals((Object)class_3730.field_16472) || type.equals((Object)class_3730.field_16466);
    }

    public String getRandomVariant(List<String> variantNamesList, String defaultVariant) {
        if (variantNamesList == null || variantNamesList.isEmpty()) {
            BaseLogger.log((Level)BaseLogLevel.WARNING, (String)("No variants found for dragon type: " + String.valueOf(this.returnDragonType()) + ". Returning default variant: " + defaultVariant));
            return defaultVariant;
        }
        String currentBiome = this.field_6002.method_23753(this.method_24515()).method_40230().map(key -> key.method_29177().toString()).orElse("");
        boolean isOverworld = this.field_6002.method_27983() == class_1937.field_25179;
        ArrayList<String> filteredVariants = new ArrayList<String>();
        for (String variant : variantNamesList) {
            boolean biomeAllowed;
            JsonElement biomesElement = BddBaseDragon.getParameterDataForVariant(this.returnDragonType(), variant, "biomes");
            if (biomesElement == null || biomesElement.isJsonArray() && biomesElement.getAsJsonArray().isEmpty()) {
                biomeAllowed = isOverworld;
            } else if (biomesElement.isJsonArray()) {
                ArrayList allowedBiomes = new ArrayList();
                biomesElement.getAsJsonArray().forEach(biomeJson -> allowedBiomes.add(biomeJson.getAsString()));
                biomeAllowed = allowedBiomes.contains(currentBiome);
            } else {
                biomeAllowed = false;
            }
            if (!biomeAllowed) continue;
            filteredVariants.add(variant);
        }
        if (filteredVariants.isEmpty()) {
            BaseLogger.log((Level)BaseLogLevel.WARNING, (String)("No valid variants for this biome. Returning default variant: " + defaultVariant));
            return defaultVariant;
        }
        ArrayList<AbstractMap.SimpleEntry<String, Integer>> weightedVariants = new ArrayList<AbstractMap.SimpleEntry<String, Integer>>();
        HashMap<String, String> variantRarities = new HashMap<String, String>();
        int totalWeight = 0;
        for (String variant : filteredVariants) {
            String string = Objects.requireNonNullElse(BddBaseDragon.getParameterDataForVariant(this.returnDragonType(), variant, "enabled"), "true").toString().trim();
            String rarityParam = Objects.requireNonNullElse(BddBaseDragon.getParameterDataForVariant(this.returnDragonType(), variant, "rarity"), "common").toString().trim();
            if (rarityParam.startsWith("\"") && rarityParam.endsWith("\"") && rarityParam.length() > 1) {
                rarityParam = rarityParam.substring(1, rarityParam.length() - 1).trim();
            }
            boolean isEnabled = Boolean.parseBoolean(string);
            String rarityKey = rarityParam.toLowerCase();
            Integer rarityWeight = RARITY_WEIGHTS.get(rarityKey);
            if (rarityWeight == null) {
                BaseLogger.log((Level)BaseLogLevel.WARNING, (String)("Invalid rarity value '" + rarityParam + "' for variant: " + variant + ". Using default rarity 'common'."));
                rarityKey = "common";
                rarityWeight = RARITY_WEIGHTS.get("common");
            }
            if (!isEnabled || rarityWeight <= 0) continue;
            totalWeight += rarityWeight.intValue();
            weightedVariants.add(new AbstractMap.SimpleEntry<String, Integer>(variant, rarityWeight));
            variantRarities.put(variant, rarityKey);
        }
        if (totalWeight > 0) {
            int randomWeight = this.random.nextInt(totalWeight);
            for (AbstractMap.SimpleEntry simpleEntry : weightedVariants) {
                if ((randomWeight -= ((Integer)simpleEntry.getValue()).intValue()) >= 0) continue;
                String selectedVariant = (String)simpleEntry.getKey();
                String selectedRarity = variantRarities.getOrDefault(selectedVariant, "common");
                BaseLogger.log((Level)BaseLogLevel.SUCCESS, (String)("Successfully spawned variant: " + selectedVariant + " with rarity: " + selectedRarity));
                return selectedVariant;
            }
        }
        BaseLogger.log((Level)BaseLogLevel.WARNING, (String)("No valid variants found. Returning default variant: " + defaultVariant));
        return defaultVariant;
    }

    @NotNull
    public class_2960 getDragonLocation() {
        String adultPath = String.valueOf(BddBaseDragon.getParameterDataForVariant(this.returnDragonType(), this.getVariantName(), "adult")).trim();
        String childPath = String.valueOf(BddBaseDragon.getParameterDataForVariant(this.returnDragonType(), this.getVariantName(), "child")).trim();
        adultPath = this.sanitizePath(adultPath);
        childPath = this.sanitizePath(childPath);
        String texturePath = this.method_6109() ? "dragons/" + childPath + ".png" : "dragons/" + adultPath + ".png";
        return class_2960.method_60655((String)"bdd", (String)texturePath);
    }

    private String sanitizePath(String path) {
        return path.replace("\\", "/").replace("\"", "").trim();
    }

    @Nullable
    public class_1296 method_5613(@NotNull class_3218 serverLevel, @NotNull class_1296 ageableMob) {
        String babyVariant;
        if (!(ageableMob instanceof BddBaseDragon)) {
            return null;
        }
        BddBaseDragon otherParent = (BddBaseDragon)ageableMob;
        if (!this.returnDragonType().equals((Object)otherParent.returnDragonType())) {
            BaseLogger.log((Level)BaseLogLevel.ERROR, (String)("Breeding failed: Parents are of different species (" + String.valueOf(this.returnDragonType()) + " and " + String.valueOf(otherParent.returnDragonType()) + ")"));
            return null;
        }
        if (!this.isAdult() || !otherParent.isAdult()) {
            BaseLogger.log((Level)BaseLogLevel.ERROR, (String)"Breeding failed: Both parents must be adults");
            return null;
        }
        if (this.isMale() == otherParent.isMale()) {
            BaseLogger.log((Level)BaseLogLevel.ERROR, (String)"Breeding failed: One parent must be male and the other female");
            return null;
        }
        BddBaseDragon baby = (BddBaseDragon)this.method_5864().method_5883((class_1937)serverLevel);
        if (baby == null) {
            return null;
        }
        baby.setGender(baby.random.nextBoolean());
        baby.growDragon(100);
        baby.method_6179(false);
        int randomHunger = MIN_HUNGER + baby.random.nextInt(MAX_HUNGER - MIN_HUNGER + 1);
        baby.setHunger(randomHunger);
        String parent1Variant = this.getVariantName();
        String parent2Variant = otherParent.getVariantName();
        int parent1Rarity = this.getVariantRarity(this.returnDragonType(), parent1Variant);
        int parent2Rarity = this.getVariantRarity(otherParent.returnDragonType(), parent2Variant);
        if (parent1Variant != null && parent1Variant.equals(parent2Variant)) {
            babyVariant = parent1Variant;
        } else if (parent1Rarity == 100 && parent2Rarity != 100) {
            boolean useParent2 = baby.random.nextInt(100) < parent2Rarity;
            babyVariant = useParent2 ? parent2Variant : parent1Variant;
        } else if (parent2Rarity == 100 && parent1Rarity != 100) {
            boolean useParent1 = baby.random.nextInt(100) < parent1Rarity;
            babyVariant = useParent1 ? parent1Variant : parent2Variant;
        } else {
            int randomPoint;
            int totalRarity;
            babyVariant = parent1Rarity == 100 ? (baby.random.nextBoolean() ? parent1Variant : parent2Variant) : ((totalRarity = parent1Rarity + parent2Rarity) > 0 ? ((randomPoint = baby.random.nextInt(totalRarity)) < parent1Rarity ? parent1Variant : parent2Variant) : this.getRandomVariant(this.getEntityVariants(baby.returnDragonType()), baby.returnDragonType().method_12832()));
        }
        baby.setVariantName(babyVariant);
        BaseLogger.log((Level)BaseLogLevel.SUCCESS, (String)("Baby Dragon Spawned with Variant: " + babyVariant));
        return baby;
    }

    private int getVariantRarity(class_2960 dragonType, String variantName) {
        JsonElement rarityObj = ParameterUtils.getParameterDataForVariant((class_2960)dragonType, (String)variantName, (String)"rarity");
        String rarityParam = rarityObj != null ? rarityObj.toString().trim() : "common";
        Integer rarityWeight = RARITY_WEIGHTS.get(rarityParam.toLowerCase());
        if (rarityWeight == null) {
            BaseLogger.log((Level)BaseLogLevel.WARNING, (String)("Invalid rarity value '" + rarityParam + "' for variant: " + variantName + ". Using default rarity 'common'."));
            return RARITY_WEIGHTS.get("common");
        }
        return rarityWeight;
    }

    public boolean method_5753() {
        return true;
    }

    @Nullable
    public static JsonElement getParameterDataForVariant(class_2960 entityName, String variantName, String parameter) {
        return ParameterUtils.getParameterDataForVariant((class_2960)entityName, (String)variantName, (String)parameter, (String)entityName.method_12832());
    }

    public abstract float backCameraIncrease();

    @NotNull
    public BddBaseDragon getEntity() {
        return this;
    }

    public boolean method_5675() {
        return true;
    }

    public boolean method_5931() {
        return true;
    }

    @NotNull
    public class_2960 getControllerResource() {
        return BddCommon.Resource.resource("controller/" + this.returnDragonType().method_12832() + ".controller.json");
    }

    public boolean isArmedWithinRange(double range) {
        List nearbyPlayers = this.field_6002.method_8390(class_1657.class, this.method_5829().method_1014(range), player -> player.method_5805() && !player.method_7325());
        for (class_1657 player2 : nearbyPlayers) {
            if (!this.isPlayerArmed(player2)) continue;
            return true;
        }
        return false;
    }

    public boolean isArmed() {
        return this.isArmedWithinRange(10.0) && !this.isArmedWithinRange(3.0);
    }

    protected boolean isPlayerArmed(class_1657 player) {
        if (this.isWeaponOrShield(player.method_6079())) {
            return true;
        }
        class_1661 inv = player.method_31548();
        for (int i = 0; i < 9; ++i) {
            if (!this.isWeaponOrShield(inv.method_5438(i))) continue;
            return true;
        }
        return false;
    }

    protected boolean isWeaponOrShield(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        class_1792 item = stack.method_7909();
        return item instanceof class_1829 || item instanceof class_1743 || item instanceof class_1753 || item instanceof class_1764 || item instanceof class_1835 || item instanceof class_1819;
    }

    protected boolean isPlayerWearingArmor(class_1657 player) {
        for (class_1799 armor : player.method_5661()) {
            if (armor.method_7960()) continue;
            return true;
        }
        return false;
    }

    public class_243 getMatrixPos(BddBaseDragon entity, Matrix4f matrix) {
        if (this.field_6002.field_9236 && matrix != null) {
            Vector3f bonePos = new Vector3f(0.0f, 0.0f, 0.0f);
            matrix.transformPosition(bonePos);
            class_243 entityPos = entity.method_19538();
            return new class_243(entityPos.field_1352 + (double)bonePos.x(), entityPos.field_1351 + (double)bonePos.y(), entityPos.field_1350 + (double)bonePos.z());
        }
        class_243 rotVector = class_243.method_1030((float)(this.method_36455() * 0.2f), (float)this.method_36454());
        class_243 position = this.method_33571().method_1031(0.0, 0.0, 0.0);
        return position.method_1019(rotVector.method_1021((double)this.method_17681()));
    }

    public class_243 adjustFirstPersonCamera(class_243 rideOffset, Matrix4f boneMatrix) {
        if (boneMatrix != null) {
            Vector3f offset = new Vector3f((float)rideOffset.method_10216(), (float)rideOffset.method_10214(), (float)rideOffset.method_10215());
            boneMatrix.transformPosition(offset);
            return new class_243((double)offset.x(), (double)offset.y(), (double)offset.z());
        }
        return rideOffset;
    }

    static {
        RARITY_WEIGHTS.put("common", 100);
        RARITY_WEIGHTS.put("uncommon", 50);
        RARITY_WEIGHTS.put("rare", 15);
        RARITY_WEIGHTS.put("epic", 5);
        RARITY_WEIGHTS.put("legendary", 1);
    }
}

