/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.core_classes;

import com.bdc.bdd.api.entity.core_classes.BddSaddleDragon;
import com.bdc.bdd.api.entity.util.DragonMoveControl;
import com.bdc.bdd.api.entity.util.DragonPathNavigation;
import com.bdc.bdd.util.BddUtil;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1321;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_9;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BddFlyingDragon
extends BddSaddleDragon {
    public static final float MIN_FLYING_SPEED = 0.02f;
    private static final float GLIDE_SPEED_BOOST_MULTIPLIER = 2.7f;
    private static final float PITCH_THRESHOLD = 10.0f;
    private static final float DIVE_SPEED_INCREMENT = 0.002f;
    private static final class_2940<Boolean> FLYING = class_2945.method_12791(BddFlyingDragon.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> HOVERING = class_2945.method_12791(BddFlyingDragon.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> GOING_UP = class_2945.method_12791(BddFlyingDragon.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> GOING_DOWN = class_2945.method_12791(BddFlyingDragon.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> FLIGHT_ANIMATION_TIMER = class_2945.method_12791(BddFlyingDragon.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> DIVE_TIMER = class_2945.method_12791(BddFlyingDragon.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> FORCE_GLIDE = class_2945.method_12791(BddFlyingDragon.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> TURN_ANIMATION_TIMER = class_2945.method_12791(BddFlyingDragon.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> SPEEDING_UP = class_2945.method_12791(BddFlyingDragon.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SPEEDING_DOWN = class_2945.method_12791(BddFlyingDragon.class, (class_2941)class_2943.field_13323);
    private final class_1409 groundNavigation;
    private final class_1407 flyingNavigation;
    public float lastYaw;
    private float bodyPitch = 0.0f;
    private int postDismountNoTakeoffTicks = 0;
    private int takeoffLatchTicks = 0;
    private int takeoffBoostTicks = 0;
    private int groundContactTicks = 0;
    private static final double AI_ASCEND_Y_PER_TICK = 0.28;
    private static final double AI_DIVE_Y_PER_TICK = 0.36;

    public BddFlyingDragon(class_1299<? extends class_1321> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6207 = new DragonMoveControl(this);
        this.flyingNavigation = new class_1407((class_1308)this, level);
        this.groundNavigation = new class_1409((class_1308)this, level);
        this.flyingNavigation.method_6354(true);
        this.groundNavigation.method_6354(true);
        this.field_6189 = this.groundNavigation;
        this.lastYaw = this.method_36454();
    }

    @NotNull
    protected class_1408 method_5965(@NotNull class_1937 level) {
        DragonPathNavigation dragonNavigation = new DragonPathNavigation((class_1308)this, level);
        dragonNavigation.method_6354(true);
        return dragonNavigation;
    }

    @Override
    protected void method_5693(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(FLYING, (Object)false);
        builder.method_56912(HOVERING, (Object)false);
        builder.method_56912(GOING_UP, (Object)false);
        builder.method_56912(GOING_DOWN, (Object)false);
        builder.method_56912(FLIGHT_ANIMATION_TIMER, (Object)0);
        builder.method_56912(DIVE_TIMER, (Object)0);
        builder.method_56912(FORCE_GLIDE, (Object)false);
        builder.method_56912(TURN_ANIMATION_TIMER, (Object)0);
        builder.method_56912(SPEEDING_UP, (Object)false);
        builder.method_56912(SPEEDING_DOWN, (Object)false);
    }

    @Override
    public void method_5652(@NotNull class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("Flying", this.isFlying());
        compound.method_10556("Hovering", this.isHovering());
        compound.method_10556("GoingUp", this.isGoingUp());
        compound.method_10556("Diving", this.isDiving());
        compound.method_10569("FlightAnimationTimer", this.getFlightAnimationTimer());
        compound.method_10569("DiveTimer", this.getDiveTimer());
        compound.method_10556("ForceGlide", this.isForceGlide());
        compound.method_10569("TurnAnimationTimer", this.getTurnAnimationTimer());
        compound.method_10556("SpeedUp", this.isSpeedingUp());
        compound.method_10556("SpeedDown", this.isSpeedingDown());
    }

    @Override
    public void method_5749(@NotNull class_2487 compound) {
        super.method_5749(compound);
        this.setFlying(compound.method_10577("Flying"));
        this.setHovering(compound.method_10577("Hovering"));
        this.setGoingUp(compound.method_10577("GoingUp"));
        this.setDiving(compound.method_10577("Diving"));
        this.setFlightAnimationTimer(compound.method_10550("FlightAnimationTimer"));
        this.setDiveTimer(compound.method_10550("DiveTimer"));
        this.setForceGlide(compound.method_10577("ForceGlide"));
        this.setTurnAnimationTimer(compound.method_10550("TurnAnimationTimer"));
        this.setSpeedingUp(compound.method_10577("SpeedUp"));
        this.setSpeedingDown(compound.method_10577("SpeedDown"));
    }

    @Override
    public boolean isFlying() {
        return (Boolean)this.field_6011.method_12789(FLYING);
    }

    @Override
    public void setFlying(boolean flying) {
        this.field_6011.method_12778(FLYING, (Object)flying);
        this.method_5875(flying);
        if (flying) {
            if (!this.field_6002.method_8608()) {
                this.setNavigation(true);
            }
        } else if (!this.field_6002.method_8608()) {
            this.setNavigation(false);
        }
    }

    public void method_6043() {
        super.method_6043();
        this.method_18799(this.method_18798().method_1031(0.0, 1.5, 0.0));
        this.takeoffLatchTicks = 14;
        this.takeoffBoostTicks = 12;
    }

    @Override
    public void method_5793(class_1297 passenger) {
        super.method_5793(passenger);
        if (passenger instanceof class_1657) {
            this.postDismountNoTakeoffTicks = BddUtil.secondsToTicks(4);
            this.takeoffLatchTicks = 0;
            this.takeoffBoostTicks = 0;
            this.setGoingUp(false);
            this.setDiving(false);
            if (this.method_24828()) {
                this.setFlying(false);
                this.setHovering(false);
                this.method_5875(false);
                if (!this.field_6002.method_8608()) {
                    this.setNavigation(false);
                }
            }
        }
    }

    public boolean isAbleToFly() {
        return this.canFly() && !this.method_6109() && (this.hasTailFin() || this.hasFakeTailFin());
    }

    @Override
    public boolean isHovering() {
        return (Boolean)this.field_6011.method_12789(HOVERING);
    }

    @Override
    public void setHovering(boolean hovering) {
        this.field_6011.method_12778(HOVERING, (Object)hovering);
        this.method_5875(hovering || this.isFlying());
    }

    @Override
    public boolean isGoingUp() {
        return (Boolean)this.field_6011.method_12789(GOING_UP);
    }

    @Override
    public void setGoingUp(boolean goingUp) {
        this.field_6011.method_12778(GOING_UP, (Object)goingUp);
    }

    @Override
    public boolean isDiving() {
        return (Boolean)this.field_6011.method_12789(GOING_DOWN);
    }

    @Override
    public void setDiving(boolean diving) {
        this.field_6011.method_12778(GOING_DOWN, (Object)diving);
        if (!diving) {
            this.setDiveTimer(0);
        }
    }

    public float getBodyPitch() {
        return this.bodyPitch;
    }

    public void setBodyPitch(float pitch) {
        this.bodyPitch = pitch;
    }

    public boolean isSpeedingUp() {
        return (Boolean)this.field_6011.method_12789(SPEEDING_UP);
    }

    public void setSpeedingUp(boolean speedingUp) {
        this.field_6011.method_12778(SPEEDING_UP, (Object)speedingUp);
    }

    public boolean isSpeedingDown() {
        return (Boolean)this.field_6011.method_12789(SPEEDING_DOWN);
    }

    public void setSpeedingDown(boolean speedingDown) {
        this.field_6011.method_12778(SPEEDING_DOWN, (Object)speedingDown);
    }

    public int getFlightAnimationTimer() {
        return (Integer)this.field_6011.method_12789(FLIGHT_ANIMATION_TIMER);
    }

    public void setFlightAnimationTimer(int timer) {
        this.field_6011.method_12778(FLIGHT_ANIMATION_TIMER, (Object)timer);
    }

    public int getDiveTimer() {
        return (Integer)this.field_6011.method_12789(DIVE_TIMER);
    }

    public void setDiveTimer(int timer) {
        this.field_6011.method_12778(DIVE_TIMER, (Object)timer);
    }

    public boolean isForceGlide() {
        return (Boolean)this.field_6011.method_12789(FORCE_GLIDE);
    }

    public void setForceGlide(boolean forceGlide) {
        this.field_6011.method_12778(FORCE_GLIDE, (Object)forceGlide);
    }

    public int getTurnAnimationTimer() {
        return (Integer)this.field_6011.method_12789(TURN_ANIMATION_TIMER);
    }

    public void setTurnAnimationTimer(int timer) {
        this.field_6011.method_12778(TURN_ANIMATION_TIMER, (Object)timer);
    }

    protected float method_6106() {
        return super.method_6106() / 7.0f;
    }

    public boolean shouldFly() {
        return this.isFlying() ? !this.method_24828() : this.isAbleToFly() && !this.method_5799();
    }

    public void setNavigation(boolean flying) {
        this.field_6189 = flying ? this.flyingNavigation : this.groundNavigation;
    }

    @Override
    public void method_5773() {
        boolean shouldKeepFlying;
        boolean airborne;
        super.method_5773();
        this.groundContactTicks = this.method_24828() ? ++this.groundContactTicks : 0;
        boolean bl = airborne = !this.method_24828();
        if (airborne) {
            if (this.takeoffLatchTicks > 0) {
                --this.takeoffLatchTicks;
            }
            if (this.takeoffBoostTicks > 0) {
                --this.takeoffBoostTicks;
            }
        }
        boolean bl2 = shouldKeepFlying = this.isAbleToFly() && airborne && (this.takeoffLatchTicks > 0 || this.isHighEnough(2) || this.method_18798().field_1351 > 0.08);
        if (shouldKeepFlying) {
            if (!this.isFlying()) {
                this.setFlying(true);
            }
            this.method_5875(true);
            if (!this.field_6002.method_8608()) {
                this.setNavigation(true);
            }
            if (this.takeoffBoostTicks > 0) {
                class_243 dm = this.method_18798();
                double minUp = 0.34;
                if (dm.field_1351 < minUp) {
                    this.method_18800(dm.field_1352, minUp, dm.field_1350);
                }
            }
        } else {
            boolean LAND_GROUND_TICKS = true;
            if ((this.groundContactTicks >= 1 || !this.isAbleToFly()) && this.isFlying()) {
                this.setFlying(false);
                this.setHovering(false);
                this.method_5875(false);
                this.setGoingUp(false);
                this.setDiving(false);
                this.setDiveTimer(0);
                class_243 dm = this.method_18798();
                this.method_18800(dm.field_1352 * 0.6, 0.0, dm.field_1350 * 0.6);
                if (!this.field_6002.method_8608()) {
                    this.setNavigation(false);
                }
            }
        }
        if (this.isDiving() && this.isFlying()) {
            this.setDiveTimer(this.getDiveTimer() + 1);
        }
    }

    public boolean isPostDismountCooldownActive() {
        return this.postDismountNoTakeoffTicks > 0;
    }

    public boolean hasHeadroom(class_1937 level, class_2338 pos, int height) {
        class_2338.class_2339 m = new class_2338.class_2339();
        for (int dy = 1; dy <= height; ++dy) {
            m.method_10103(pos.method_10263(), pos.method_10264() + dy, pos.method_10260());
            if (level.method_8320((class_2338)m).method_26215()) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private class_243 getAutopilotTargetVec() {
        class_11 path;
        if (this.method_5942().method_23966() && (path = this.method_5942().method_6345()) != null) {
            try {
                class_2338 nodePos = path.method_31032();
                if (nodePos != null) {
                    return new class_243((double)nodePos.method_10263() + 0.5, (double)nodePos.method_10264(), (double)nodePos.method_10260() + 0.5);
                }
            }
            catch (Throwable nodePos) {
                // empty catch block
            }
            try {
                class_9 node = path.method_29301();
                if (node != null) {
                    return new class_243((double)node.field_40 + 0.5, (double)node.field_39, (double)node.field_38 + 0.5);
                }
            }
            catch (Throwable node) {
                // empty catch block
            }
            try {
                class_2338 target = path.method_48();
                if (target != null) {
                    return new class_243((double)target.method_10263() + 0.5, (double)target.method_10264(), (double)target.method_10260() + 0.5);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.targetPosition != null) {
            return new class_243((double)this.targetPosition.method_10263() + 0.5, (double)this.targetPosition.method_10264() + 0.5, (double)this.targetPosition.method_10260() + 0.5);
        }
        return null;
    }

    public void method_6091(@NotNull class_243 travelVector) {
        class_243 movement;
        class_1309 driver = this.method_5642();
        boolean flown = this.isFlying();
        class_243 class_2432 = movement = driver != null ? this.handleRiddenMovement(driver, travelVector) : this.handleUnriddenMovement(travelVector);
        if (driver != null && flown && this.method_5787()) {
            this.handleFlightMovement(driver, movement);
            if (this.method_18798().field_1351 < 0.1 && !this.isGoingUp()) {
                class_243 dm = this.method_18798();
                this.method_18800(dm.field_1352 * 0.9, dm.field_1351, dm.field_1350 * 0.9);
            }
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_29242(true);
        } else {
            double yBefore = this.method_23318();
            super.method_6091(movement);
            if (flown && driver == null) {
                this.applyUnriddenVerticalOverride(this.method_49484(), yBefore);
            }
        }
        this.adjustFlyingSpeed(driver);
    }

    private void applyUnriddenVerticalOverride(double flightSpeed, double yBefore) {
        if (!this.isFlying()) {
            return;
        }
        double navVyApplied = this.method_23318() - yBefore;
        if (this.isHovering()) {
            if (Math.abs(navVyApplied) > 1.0E-4) {
                this.method_5784(class_1313.field_6308, new class_243(0.0, -navVyApplied, 0.0));
            }
            class_243 dm = this.method_18798();
            this.method_18800(dm.field_1352, 0.0, dm.field_1350);
            return;
        }
        double desiredVy = this.isGoingUp() ? Math.max(0.28, flightSpeed * 0.85) : (this.isDiving() ? -Math.max(0.36, flightSpeed * 1.25) : 0.0);
        double correction = desiredVy - navVyApplied;
        if (Math.abs(correction) > 1.0E-4) {
            this.method_5784(class_1313.field_6308, new class_243(0.0, correction, 0.0));
        }
        class_243 dm = this.method_18798();
        this.method_18800(dm.field_1352, desiredVy, dm.field_1350);
    }

    private class_243 handleRiddenMovement(class_1309 driver, class_243 travelVector) {
        double moveSideways = travelVector.field_1352;
        double moveY = travelVector.field_1351;
        double moveForward = Math.min(Math.abs(driver.field_6250) + Math.abs(driver.field_6212), 1.0f);
        float yaw = driver.field_6241;
        if (moveForward > 0.0) {
            yaw += (float)class_3532.method_15349((double)driver.field_6250, (double)driver.field_6212) * 57.295776f - 90.0f;
        }
        this.field_6241 = yaw;
        this.method_36457(driver.method_36455() * 0.68f);
        this.method_36456(class_3532.method_20306((float)this.field_6241, (float)this.method_36454(), (float)4.0f));
        if (!this.method_5787()) {
            this.method_18799(class_243.field_1353);
            this.method_29242(true);
            return class_243.field_1353;
        }
        if (this.isFlying()) {
            if (moveForward > 0.0 && driver instanceof class_1657) {
                class_1657 player = (class_1657)driver;
                float pitch = player.method_36455();
                this.setGoingUp(pitch < -10.0f);
                this.setDiving(pitch > 10.0f);
            } else {
                this.setGoingUp(false);
                this.setDiving(false);
            }
            moveForward = this.isHovering() ? 0.0 : 1.0;
            moveSideways = 0.0;
            moveY = 0.0;
        }
        this.handleRiddenStateTransitions(driver);
        return new class_243(moveSideways, moveY, moveForward);
    }

    private void handleRiddenStateTransitions(class_1309 driver) {
        if (this.method_24828()) {
            if (this.isFlying()) {
                this.setFlying(false);
            }
            if (driver instanceof class_1657) {
                class_1657 player = (class_1657)driver;
                if (player.field_6282) {
                    this.method_6043();
                }
            }
        }
    }

    private class_243 handleUnriddenMovement(class_243 travelVector) {
        return travelVector;
    }

    private void handleFlightMovement(@Nullable class_1309 driver, class_243 movement) {
        class_243 forwardDir;
        if (this.isHovering()) {
            this.method_18799(class_243.field_1353);
            return;
        }
        double flightSpeed = this.method_49484();
        if (this.isForceGlide()) {
            flightSpeed *= (double)2.7f;
        }
        if (this.isDiving()) {
            flightSpeed += (double)((float)this.getDiveTimer() * 0.002f);
        }
        double verticalSpeed = this.getVerticalSpeed(driver, flightSpeed);
        if (driver == null) {
            class_243 target = this.getAutopilotTargetVec();
            if (target != null) {
                class_243 to = target.method_1020(this.method_19538());
                double dx = to.field_1352;
                double dz = to.field_1350;
                double horizDist = Math.sqrt(dx * dx + dz * dz);
                float desiredYaw = (float)(class_3532.method_15349((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                this.method_36456(class_3532.method_20306((float)desiredYaw, (float)this.method_36454(), (float)6.0f));
                this.field_6241 = this.method_36454();
                forwardDir = class_243.method_1030((float)0.0f, (float)this.method_36454()).method_1029();
                double slowFactor = horizDist < 4.0 ? horizDist / 4.0 : 1.0;
                flightSpeed *= class_3532.method_15350((double)slowFactor, (double)0.25, (double)1.0);
            } else {
                forwardDir = class_243.method_1030((float)0.0f, (float)this.method_36454()).method_1029();
            }
        } else {
            forwardDir = class_243.method_1030((float)0.0f, (float)this.method_36454()).method_1029();
        }
        class_243 forwardMovement = forwardDir.method_1021(flightSpeed);
        class_243 totalMovement = new class_243(forwardMovement.field_1352, verticalSpeed, forwardMovement.field_1350);
        this.method_18799(this.method_18798().method_1021((double)0.9f).method_1019(totalMovement));
    }

    private double getVerticalSpeed(@Nullable class_1309 driver, double flightSpeed) {
        if (this.isHovering()) {
            return 0.0;
        }
        if (driver == null) {
            return 0.0;
        }
        if (this.isGoingUp()) {
            return flightSpeed * 0.4;
        }
        if (this.isDiving()) {
            return -flightSpeed * 0.6;
        }
        return 0.0;
    }

    private void handleGroundMovement(class_1309 driver, class_243 travelVector) {
        class_243 riddenInput = driver != null ? this.method_49482((class_1657)driver, travelVector) : travelVector;
        class_243 adjustedMovement = this.rotateMovementToEntity(riddenInput, this.method_36454());
        double baseSpeedMultiplier = this.method_45325(class_5134.field_23719) * 4.0;
        double sprintSpeedMultiplier = this.method_45325(class_5134.field_23719) * 5.0;
        double effectiveSpeedMultiplier = this.method_5624() ? sprintSpeedMultiplier : baseSpeedMultiplier;
        double currentY = this.method_18798().field_1351;
        class_243 newMovement = new class_243(adjustedMovement.field_1352 * effectiveSpeedMultiplier, currentY, adjustedMovement.field_1350 * effectiveSpeedMultiplier).method_1021(0.9);
        this.method_18799(newMovement);
    }

    public void adjustFlyingSpeed(class_1309 driver) {
        block9: {
            block8: {
                if (!(driver instanceof class_1657)) break block8;
                class_1657 player = (class_1657)driver;
                if (this.isFlying()) break block9;
            }
            return;
        }
        float currentFlyingSpeed = this.method_49484();
        float speedIncrement = 0.001f;
        if (this.isSpeedingUp()) {
            if (currentFlyingSpeed < MAX_FLYING_SPEED) {
                this.setFlyingSpeed(currentFlyingSpeed + speedIncrement);
            }
        } else if (this.isSpeedingDown() && currentFlyingSpeed > 0.02f) {
            this.setFlyingSpeed(currentFlyingSpeed - speedIncrement);
        }
    }

    public double getAltitude(int limit) {
        class_2338.class_2339 pointer = this.method_24515().method_25503().method_10100(0, -1, 0);
        int min = this.field_6002.method_8597().comp_651();
        int i = 0;
        while (i <= limit && pointer.method_10264() > min && !this.field_6002.method_8320((class_2338)pointer).method_51367()) {
            pointer.method_33098(this.method_31478() - ++i);
        }
        return i;
    }

    public double getAltitude() {
        return this.getAltitude(this.field_6002.method_31600());
    }

    public boolean isHighEnough(int height) {
        return this.getAltitude(height) >= (double)height;
    }
}

