/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.api.entity.core_classes;

import com.bdc.bdd.api.entity.core_classes.BddAbilityDragon;
import com.bdc.bdd.registry.ItemRegistry;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_7225;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BddSaddleDragon
extends BddAbilityDragon {
    public static final int SADDLE_SLOT = 0;
    public static final int ARMOR_SLOT = 1;
    public static final int CHEST_SLOT = 2;
    public static final int TAIL_SLOT = 3;
    public static final int ROPE_SLOT = 4;
    private static final int INVENTORY_SIZE = 16;
    private static final class_2940<Boolean> SADDLE = class_2945.method_12791(BddSaddleDragon.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> CHESTED = class_2945.method_12791(BddSaddleDragon.class, (class_2941)class_2943.field_13323);
    public class_1277 dragonContainer;
    public boolean hasChestVarChanged = false;

    public BddSaddleDragon(class_1299<? extends class_1321> entityType, class_1937 level) {
        super(entityType, level);
        this.initDragonInv();
    }

    @Override
    protected void method_5693(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(SADDLE, (Object)false);
        builder.method_56912(CHESTED, (Object)false);
    }

    @Override
    public void method_5652(@NotNull class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("Chested", this.isChested());
        compound.method_10556("Saddled", this.method_6725());
        if (this.method_6181() && this.dragonContainer != null) {
            class_2499 listTag = new class_2499();
            for (int i = 0; i < this.dragonContainer.method_5439(); ++i) {
                class_1799 itemStack = this.dragonContainer.method_5438(i);
                if (itemStack.method_7960()) continue;
                class_2487 itemTag = new class_2487();
                itemTag.method_10567("Slot", (byte)i);
                class_2487 itemData = (class_2487)itemStack.method_57358((class_7225.class_7874)this.method_56673());
                itemTag.method_10543(itemData);
                listTag.add((Object)itemTag);
            }
            compound.method_10566("Items", (class_2520)listTag);
        }
    }

    @Override
    public void method_5749(@NotNull class_2487 compound) {
        super.method_5749(compound);
        this.setChested(compound.method_10577("Chested"));
        this.setSaddled(compound.method_10577("Saddled"));
        if (this.method_6181() && this.dragonContainer != null) {
            class_2499 listTag = compound.method_10554("Items", 10);
            for (int i = 0; i < listTag.size(); ++i) {
                class_2487 itemTag = listTag.method_10602(i);
                int slot = itemTag.method_10571("Slot") & 0xFF;
                if (slot >= this.dragonContainer.method_5439()) continue;
                this.dragonContainer.method_5447(slot, class_1799.method_57359((class_7225.class_7874)this.method_56673(), (class_2487)itemTag));
            }
        }
        this.updateContainerEquipment();
    }

    @Override
    public boolean method_6725() {
        return (Boolean)this.field_6011.method_12789(SADDLE);
    }

    public void setSaddled(boolean saddled) {
        this.field_6011.method_12778(SADDLE, (Object)saddled);
    }

    @Override
    public boolean method_6765() {
        return this.isAbleToBeRidden() && this.method_6181();
    }

    @Override
    public boolean canBeRoped() {
        return this.isAbleToBeRidden() && this.method_6181();
    }

    @Override
    public void method_6576(@NotNull class_1799 itemStack, @Nullable class_3419 soundSource) {
        class_1799 ropeItem;
        if (this.isRoped() && !(ropeItem = this.dragonContainer.method_5441(4)).method_7960()) {
            this.method_5775(ropeItem);
            this.setRoped(false);
            this.field_6002.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14770, this.method_5634(), 1.0f, 1.0f);
        }
        this.dragonContainer.method_5447(0, new class_1799((class_1935)class_1802.field_8175));
        this.setSaddled(true);
        this.field_6002.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14704, this.method_5634(), 1.0f, 1.0f);
    }

    @Override
    public void equipTail(@NotNull class_1799 itemStack, @Nullable class_3419 soundSource) {
        if (!this.method_6725()) {
            return;
        }
        this.dragonContainer.method_5447(3, new class_1799((class_1935)ItemRegistry.PROSTHETIC_TAILFIN.get()));
        this.setFakeTailFin(true);
        this.field_6002.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14704, this.method_5634(), 1.0f, 1.0f);
    }

    @Override
    public void equipRope(@NotNull class_1799 itemStack, @Nullable class_3419 soundSource) {
        this.dragonContainer.method_5447(4, new class_1799((class_1935)ItemRegistry.ROPE.get()));
        this.setRoped(true);
        this.field_6002.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14704, this.method_5634(), 1.0f, 1.0f);
    }

    public boolean isChested() {
        return (Boolean)this.field_6011.method_12789(CHESTED);
    }

    public void setChested(boolean chested) {
        this.field_6011.method_12778(CHESTED, (Object)chested);
        this.hasChestVarChanged = true;
    }

    protected void initDragonInv() {
        class_1277 previousContainer = this.dragonContainer;
        this.dragonContainer = new class_1277(this.getInventorySize());
        if (previousContainer != null) {
            int minSize = Math.min(previousContainer.method_5439(), this.dragonContainer.method_5439());
            for (int i = 0; i < minSize; ++i) {
                class_1799 itemStack = previousContainer.method_5438(i);
                if (itemStack.method_7960()) continue;
                this.dragonContainer.method_5447(i, itemStack.method_7972());
            }
        }
        this.updateContainerEquipment();
    }

    public void updateContainerEquipment() {
        if (!this.field_6002.method_8608() && this.dragonContainer != null) {
            this.setSaddled(!this.dragonContainer.method_5438(0).method_7960() && this.dragonContainer.method_5438(0).method_31574(class_1802.field_8175));
            this.setRoped(!this.dragonContainer.method_5438(4).method_7960() && this.dragonContainer.method_5438(4).method_31574(ItemRegistry.ROPE.get()));
            this.setChested(!this.dragonContainer.method_5438(2).method_7960() && (this.dragonContainer.method_5438(2).method_31574(class_1802.field_8106) || this.dragonContainer.method_5438(2).method_31574(class_1802.field_8466)));
        }
    }

    @Override
    @NotNull
    public class_1269 handleEmptyStack(class_1657 player) {
        if (player.method_5715() && this.isAwaitingAcceptance()) {
            if (this.isPlayerArmed(player) || this.isPlayerWearingArmor(player)) {
                class_1937 class_19372;
                player.method_7353((class_2561)class_2561.method_43470((String)"The dragon refuses to bond while you're armed or armored."), true);
                if (!this.field_6002.field_9236 && (class_19372 = this.field_6002) instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)class_19372;
                    serverLevel.method_14199((class_2394)class_2398.field_11231, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), 8, 0.5, 0.5, 0.5, 0.1);
                }
                this.resetTamingProgress();
                return class_1269.field_5814;
            }
            if (this.isCandidateOwner(player)) {
                class_1937 class_19373;
                this.method_6170(player);
                this.setAwaitingAcceptance(false);
                this.setCandidateOwner(null);
                this.setTamingProcessStarted(false);
                this.field_6002.method_8421((class_1297)this, (byte)7);
                player.method_7353((class_2561)class_2561.method_43470((String)"This dragon accepts you as its rider!"), true);
                if (!this.field_6002.field_9236 && (class_19373 = this.field_6002) instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)class_19373;
                    for (int i = 0; i < 25; ++i) {
                        double offsetX = (this.random.nextDouble() - 0.5) * (double)this.method_17681() * 1.5;
                        double offsetY = this.random.nextDouble() * (double)this.method_17682() + 0.5;
                        double offsetZ = (this.random.nextDouble() - 0.5) * (double)this.method_17681() * 1.5;
                        serverLevel.method_14199((class_2394)class_2398.field_11248, this.method_23317() + offsetX, this.method_23318() + offsetY, this.method_23321() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
                return class_1269.field_5812;
            }
            player.method_7353((class_2561)class_2561.method_43470((String)"The dragon ignores you. It is waiting for someone else."), true);
            return class_1269.field_5814;
        }
        if (!player.method_5715()) {
            if (this.isAbleToBeRidden() && this.getHunger() > 10) {
                if (this.method_6181()) {
                    boolean owner = this.method_6171((class_1309)player);
                    if (owner) {
                        this.doPlayerRide(player);
                        return class_1269.field_5812;
                    }
                    if (this.isLocked()) {
                        player.method_7353((class_2561)class_2561.method_43470((String)"This dragon is locked by its owner."), true);
                        return class_1269.field_5814;
                    }
                    this.doPlayerRide(player);
                    if (!this.method_6725()) {
                        player.method_7353((class_2561)class_2561.method_43470((String)"You can ride, but need a saddle to control."), true);
                    }
                    return class_1269.field_5812;
                }
                player.method_7353((class_2561)class_2561.method_43470((String)"This dragon cannot be ridden at this moment."), true);
            } else {
                player.method_7353((class_2561)class_2561.method_43470((String)"This dragon cannot be ridden at this moment."), true);
            }
        }
        return class_1269.field_5811;
    }

    @Override
    @NotNull
    public class_1269 handleSpecialInteractions(class_1657 player, @NotNull class_1268 hand, class_1799 stack) {
        if (!(this.method_6171((class_1309)player) || stack.method_7909() != class_1802.field_8175 && stack.method_7909() != ItemRegistry.PROSTHETIC_TAILFIN.get())) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Only the owner can equip this."), true);
            return class_1269.field_5814;
        }
        if (stack.method_7909() == ItemRegistry.ROPE.get() && !this.isRoped() && !this.method_6181()) {
            this.setRoped(true);
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            player.method_7353((class_2561)class_2561.method_43470((String)"Your Dragon is now roped"), false);
            return class_1269.field_5812;
        }
        if (stack.method_7909() == class_1802.field_8175 && !this.method_6725() && this.method_6181()) {
            this.method_6576(stack, this.method_5634());
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            player.method_7353((class_2561)class_2561.method_43470((String)"Your Dragon is now saddled"), false);
            return class_1269.field_5812;
        }
        if (stack.method_7909() == ItemRegistry.PROSTHETIC_TAILFIN.get() && !this.hasTailFin() && !this.hasFakeTailFin() && this.method_6181()) {
            if (!this.method_6725()) {
                player.method_7353((class_2561)class_2561.method_43470((String)"You must equip a saddle first to attach a prosthetic tailfin."), true);
                return class_1269.field_5814;
            }
            this.equipTail(stack, this.method_5634());
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            player.method_7353((class_2561)class_2561.method_43470((String)"Prosthetic Tail Equipped"), true);
            return class_1269.field_5812;
        }
        return class_1269.field_5812;
    }

    @Override
    public void handleRiding(class_1657 player) {
        if (!this.method_6181()) {
            if (this.method_35057() != null) {
                player.method_7353((class_2561)class_2561.method_43470((String)("This dragon belongs to: " + this.method_35057().method_5477().getString())), true);
            }
            return;
        }
        boolean owner = this.method_6171((class_1309)player);
        if (owner) {
            this.doPlayerRide(player);
            return;
        }
        if (this.isLocked()) {
            player.method_7353((class_2561)class_2561.method_43470((String)"This dragon is locked by its owner."), true);
            return;
        }
        this.doPlayerRide(player);
        if (!this.method_6725()) {
            player.method_7353((class_2561)class_2561.method_43470((String)"You can ride, but need a saddle to control."), true);
        }
    }

    protected void doPlayerRide(class_1657 player) {
        if (!this.field_6002.method_8608()) {
            player.method_36456(this.method_36454());
            player.method_36457(this.method_36455());
            player.method_5804((class_1297)this);
        }
        if (this.isDragonSitting()) {
            this.setIsDragonWandering(true);
        }
        if (this.isDragonSleeping()) {
            this.setIsDragonSleeping(false);
        }
        if (this.isEating()) {
            this.setIsDragonWandering(true);
        }
        if (this.method_5968() != null) {
            this.method_5980(null);
        }
    }

    public boolean isAbleToBeRidden() {
        return this.canBeRidden() && !this.method_6109() && !this.isJuvenile();
    }

    public abstract boolean canBeRidden();

    public class_1309 method_5642() {
        for (class_1297 passenger : this.method_5685()) {
            if (!(passenger instanceof class_1657)) continue;
            class_1657 player = (class_1657)passenger;
            if (this.method_5968() == passenger) continue;
            if (!this.method_6181()) {
                return null;
            }
            boolean owner = this.method_6171((class_1309)player);
            if (owner) {
                return player;
            }
            if (this.isLocked()) {
                return null;
            }
            return this.method_6725() ? player : null;
        }
        return null;
    }

    public void method_5793(class_1297 passenger) {
        super.method_5793(passenger);
        if (passenger instanceof class_1657) {
            this.method_5942().method_6340();
        }
    }

    protected void method_49481(@NotNull class_1657 player, @NotNull class_243 travelVector) {
        super.method_49481(player, travelVector);
        float yaw = player.field_6241;
        if (travelVector.field_1350 > 0.0) {
            yaw += (float)class_3532.method_15349((double)player.field_6250, (double)player.field_6212) * 57.295776f - 90.0f;
        }
        this.field_6241 = yaw;
        this.method_36457(player.method_36455() * 0.68f);
        this.method_36456(class_3532.method_20306((float)yaw, (float)this.method_36454(), (float)8.0f));
        this.method_29242(true);
    }

    @NotNull
    protected class_243 method_49482(class_1657 driver, class_243 move) {
        double moveSideways = move.field_1352;
        double moveY = 0.0;
        double moveForward = Math.min((double)(Math.abs(driver.field_6250) + Math.abs(driver.field_6212)), 1.5);
        float f = this.method_5715() ? 0.3f : 1.0f;
        return new class_243(moveSideways * (double)f, moveY, moveForward * (double)f);
    }

    public void method_5670() {
        super.method_5670();
        if (this.method_5787() && this.method_5642() != null) {
            this.method_5728(this.method_5642().method_5624());
        }
    }

    public class_243 rotateMovementToEntity(class_243 inputMovement, float yaw) {
        double radians = Math.toRadians(yaw);
        double x = inputMovement.field_1352 * Math.cos(radians) - inputMovement.field_1350 * Math.sin(radians);
        double z = inputMovement.field_1352 * Math.sin(radians) + inputMovement.field_1350 * Math.cos(radians);
        return new class_243(x, inputMovement.field_1351, z);
    }

    protected void method_5865(@NotNull class_1297 entity, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_1297.class_4738 moveFunction) {
        if (this.method_5626(entity)) {
            class_243 vec3 = this.getRiderOffset(entity, 1.0f);
            moveFunction.accept(entity, this.method_23317() + vec3.field_1352, this.method_23318() + vec3.field_1351, this.method_23321() + vec3.field_1350);
        }
    }

    public class_243 getRiderOffset(class_1297 entity, float partialTick) {
        float x = this.getPassengersRidingXOffset();
        float y = (float)((this.method_31481() ? (double)0.01f : this.getPassengersRidingOffset()) + entity.method_55668((class_1297)entity).field_1351);
        if (this.method_5685().size() > 1) {
            int i = this.method_5685().indexOf(entity);
            x = i == 0 ? 0.2f : -0.6f;
            if (entity instanceof class_1429) {
                x += 0.2f;
            }
        }
        class_243 vec3 = new class_243((double)x, (double)y, 0.0);
        vec3 = vec3.method_1024(-this.method_5705(partialTick) * ((float)Math.PI / 180) - 1.5707964f);
        return new class_243(vec3.field_1352, vec3.field_1351, vec3.field_1350);
    }

    public abstract float getPassengersRidingXOffset();

    public abstract float getYRideOffset();

    public abstract float getLayerYOffset();

    public double getPassengersRidingOffset() {
        return (double)this.field_18065.comp_2186() * (double)this.getYRideOffset();
    }

    public boolean inventoryEmpty() {
        if (this.dragonContainer == null) {
            return true;
        }
        for (int i = 3; i < this.dragonContainer.method_5439(); ++i) {
            if (this.dragonContainer.method_5438(i).method_7960()) continue;
            return false;
        }
        return true;
    }

    public int getInventorySize() {
        return 22;
    }

    public int getInventoryColumns() {
        return 4;
    }

    protected void method_16078() {
        class_1799 mainHandItem;
        if (this.dragonContainer != null) {
            for (int i = 0; i < this.dragonContainer.method_5439(); ++i) {
                class_1799 itemStack = this.dragonContainer.method_5438(i);
                if (itemStack.method_7960() || class_1890.method_60142((class_1799)itemStack, (class_9331)class_9334.field_49633)) continue;
                this.method_5775(itemStack);
            }
        }
        if (!(mainHandItem = this.method_6118(class_1304.field_6173)).method_7960()) {
            this.method_5775(mainHandItem);
        }
    }

    protected void method_5958() {
        if (this.hasChestVarChanged && this.dragonContainer != null && !this.isChested()) {
            this.processChestItems();
            this.hasChestVarChanged = false;
        }
    }

    private void processChestItems() {
        for (int i = 5; i < 17; ++i) {
            class_1799 item = this.dragonContainer.method_5438(i);
            if (item.method_7960()) continue;
            if (!this.field_6002.method_8608()) {
                this.method_5699(item, 1.0f);
            }
            this.dragonContainer.method_5441(i);
        }
    }
}

