/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.projectile;

import com.bdc.bdd.api.entity.core_classes.BddAbilityDragon;
import com.bdc.bdd.projectile.BaseLinearFlightProjectile;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5362;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public class BaseLinearBoltProjectile
extends BaseLinearFlightProjectile {
    public BddAbilityDragon dragon;

    public BaseLinearBoltProjectile(class_1299 type, class_1937 level) {
        super(type, level);
    }

    public BaseLinearBoltProjectile(class_1299 type, BddAbilityDragon owner, class_243 start, class_243 lookDirection, class_1937 level, int strengthRadius) {
        super(type, level);
        this.dragon = owner;
        this.strengthRadius = strengthRadius;
        this.method_7432((class_1297)owner);
        this.start = start;
        this.end = lookDirection;
        this.method_5808(this.start.method_10216(), this.start.method_10214(), this.start.method_10215(), this.method_36454(), this.method_36455());
        this.method_23311();
        this.method_5875(true);
    }

    @Override
    public void shoot(class_243 lookDirection, float partialTicks) {
        this.shoot(lookDirection, partialTicks, 5.0);
    }

    @Override
    public void shoot(class_243 lookDirection, float partialTicks, double velocity) {
        if (partialTicks == 1.0f) {
            if (this.dragon.tier1()) {
                this.setDamageTier(1);
            } else if (this.dragon.tier2()) {
                this.setDamageTier(2);
            } else if (this.dragon.tier3()) {
                this.setDamageTier(3);
            } else if (this.dragon.tier4()) {
                this.setDamageTier(4);
            }
            this.method_18800(lookDirection.field_1352 * velocity, lookDirection.field_1351 * velocity, lookDirection.field_1350 * velocity);
            double horizontalDistance = lookDirection.method_37267();
            this.method_36456((float)(class_3532.method_15349((double)lookDirection.field_1352, (double)lookDirection.field_1350) * 57.2957763671875));
            this.method_36457((float)(class_3532.method_15349((double)lookDirection.field_1351, (double)horizontalDistance) * 57.2957763671875));
            this.field_5982 = this.method_36454();
            this.field_6004 = this.method_36455();
        }
    }

    @Override
    public void shoot(class_243 lookDirection, float partialTicks, float pInaccuracy, double pVelocity) {
        if (partialTicks == 1.0f) {
            this.method_18800(lookDirection.field_1352 * pVelocity, lookDirection.field_1351 * pVelocity, lookDirection.field_1350 * pVelocity);
            double horizontalDistance = lookDirection.method_37267();
            this.method_36456((float)(class_3532.method_15349((double)lookDirection.field_1352, (double)lookDirection.field_1350) * 57.2957763671875));
            this.method_36457((float)(class_3532.method_15349((double)lookDirection.field_1351, (double)horizontalDistance) * 57.2957763671875));
            this.field_5982 = this.method_36454();
            this.field_6004 = this.method_36455();
        }
    }

    @Override
    public void method_5773() {
        this.method_5670();
        this.ticksExisted += 1.0;
        if (this.method_5740()) {
            this.method_5875(true);
        }
        class_243 currentPos = this.method_19538();
        class_243 deltaMovement = this.method_18798();
        class_243 nextPos = currentPos.method_1019(deltaMovement);
        class_3965 blockHitResult = this.field_6002.method_17742(new class_3959(currentPos, nextPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
        class_3966 entityHitResult = class_1675.method_18077((class_1937)this.field_6002, (class_1297)this, (class_243)currentPos, (class_243)nextPos, (class_238)this.method_5829().method_18804(deltaMovement).method_1014(6.0).method_1012(1.0, 3.0, 1.0), x$0 -> this.method_26958((class_1297)x$0));
        class_3965 finalHitResult = blockHitResult;
        if (entityHitResult != null) {
            double blockHitDistanceSqr;
            double entityHitDistanceSqr = entityHitResult.method_17784().method_1025(currentPos);
            double d = blockHitDistanceSqr = blockHitResult.method_17783() != class_239.class_240.field_1333 ? blockHitResult.method_17784().method_1025(currentPos) : Double.MAX_VALUE;
            if (entityHitDistanceSqr < blockHitDistanceSqr) {
                finalHitResult = entityHitResult;
            }
        }
        if (finalHitResult.method_17783() != class_239.class_240.field_1333) {
            nextPos = finalHitResult.method_17784();
            this.method_7488((class_239)finalHitResult);
        }
        this.method_5814(nextPos.field_1352, nextPos.field_1351, nextPos.field_1350);
        this.playParticles();
        if (this.ticksExisted > (double)this.threshHoldForDeletion()) {
            this.method_31472();
            this.ticksExisted = 0.0;
        }
    }

    protected void method_24920(class_3965 blockHitResult) {
        super.method_24920(blockHitResult);
        if (!this.field_6002.field_9236 && this.dragon != null) {
            boolean mobGriefing = this.field_6002.method_8450().method_8355(class_1928.field_19388);
            this.explode(this.dragon, this.method_23317(), this.method_23318(), this.method_23321(), this.dragon.getExplosionStrength(), mobGriefing, mobGriefing ? class_1927.class_4179.field_18687 : class_1927.class_4179.field_40878);
            this.callExplosionEffects(mobGriefing, this.dragon);
            this.method_31472();
            this.method_32875((class_6880)class_5712.field_28162, (class_1297)this.getOwner());
        }
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_1297 entity;
        super.method_7454(entityHitResult);
        if (!this.field_6002.field_9236 && this.dragon != null && (entity = entityHitResult.method_17782()) != this.dragon && entity != this.getOwner() && !(entity instanceof BaseLinearFlightProjectile)) {
            float damage = this.dragon.getProjectileDamage(this.dragon, entity, this);
            float finalDamage = !(entity instanceof class_1657) && !(entity instanceof BddAbilityDragon) ? damage : damage / 3.0f;
            boolean mobGriefing = this.field_6002.method_8450().method_8355(class_1928.field_19388);
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                if (livingEntity.method_6112(class_1294.field_5918) == null) {
                    entity.method_5643(this.method_48923().method_48812((class_1309)this.dragon), finalDamage);
                    entity.method_20803(7);
                }
            } else {
                entity.method_5643(this.method_48923().method_48812((class_1309)this.dragon), finalDamage);
                entity.method_20803(7);
            }
            this.explode(this.dragon, this.method_23317(), this.method_23318(), this.method_23321(), this.dragon.getExplosionStrength(), mobGriefing, mobGriefing ? class_1927.class_4179.field_18687 : class_1927.class_4179.field_40878);
            this.callExplosionEffects(mobGriefing, this.dragon);
            this.method_31472();
            this.method_32875((class_6880)class_5712.field_28162, (class_1297)this.getOwner());
        }
    }

    @Override
    public class_1927 explode(BddAbilityDragon pEntity, double pX, double pY, double pZ, float pExplosionRadius, boolean pCausesFire, class_1927.class_4179 pMode) {
        return this.explode((class_1297)pEntity, null, null, pX, pY, pZ, pExplosionRadius, pCausesFire, pMode);
    }

    private class_1927 explode(@Nullable class_1297 exploder, @Nullable class_1282 damageSource, @Nullable class_5362 context, double x, double y, double z, float size, boolean causesFire, class_1927.class_4179 mode) {
        FireBoltExplosion explosion = new FireBoltExplosion(this.field_6002, exploder, x, y, z, size, this.getAffectedBlocks(x, y, z, size), mode, (class_2394)class_2398.field_11236, (class_2394)class_2398.field_11221, (class_6880<class_3414>)class_3417.field_15152);
        explosion.method_8348();
        explosion.method_8350(true);
        return explosion;
    }

    private List<class_2338> getAffectedBlocks(double x, double y, double z, float size) {
        ArrayList<class_2338> affectedBlocks = new ArrayList<class_2338>();
        int ix = (int)Math.floor(x - (double)size);
        while ((double)ix <= Math.ceil(x + (double)size)) {
            int iy = (int)Math.floor(y - (double)size);
            while ((double)iy <= Math.ceil(y + (double)size)) {
                int iz = (int)Math.floor(z - (double)size);
                while ((double)iz <= Math.ceil(z + (double)size)) {
                    class_2338 pos = new class_2338(ix, iy, iz);
                    double distance = pos.method_10262((class_2382)new class_2338((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z)));
                    class_2680 blockState = this.field_6002.method_8320(pos);
                    class_2248 block = blockState.method_26204();
                    if (block != class_2246.field_10540 && block != class_2246.field_9987 && distance <= (double)(size * size)) {
                        affectedBlocks.add(pos);
                    }
                    ++iz;
                }
                ++iy;
            }
            ++ix;
        }
        return affectedBlocks;
    }

    public static class FireBoltExplosion
    extends class_1927 {
        public FireBoltExplosion(class_1937 level, class_1297 source, double x, double y, double z, float radius, List<class_2338> toBlow, class_1927.class_4179 blockInteraction, class_2394 smallExplosionParticles, class_2394 largeExplosionParticles, class_6880<class_3414> explosionSound) {
            super(level, source, x, y, z, radius, toBlow, blockInteraction, smallExplosionParticles, largeExplosionParticles, explosionSound);
        }

        public void method_8348() {
            int l;
            int k;
            this.field_9187.method_33596(this.field_9185, (class_6880)class_5712.field_28178, new class_2338((int)this.field_9195, (int)this.field_9192, (int)this.field_9189));
            HashSet set = Sets.newHashSet();
            for (int j = 0; j < 16; ++j) {
                for (k = 0; k < 16; ++k) {
                    block2: for (l = 0; l < 16; ++l) {
                        if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                        double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                        double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                        double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                        d0 /= d3;
                        d1 /= d3;
                        d2 /= d3;
                        double d4 = this.field_9195;
                        double d6 = this.field_9192;
                        double d8 = this.field_9189;
                        float f1 = 0.3f;
                        for (float f = this.field_9190 * (0.7f + this.field_9187.field_9229.method_43057() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                            class_2338 blockpos = new class_2338((int)d4, (int)d6, (int)d8);
                            class_2680 blockstate = this.field_9187.method_8320(blockpos);
                            class_3610 fluidstate = this.field_9187.method_8316(blockpos);
                            if (!this.field_9187.method_24794(blockpos)) continue block2;
                            if (blockstate.method_26204() == class_2246.field_10540 || blockstate.method_26204() == class_2246.field_9987) continue;
                            Optional optional = this.field_25400.method_29555((class_1927)this, (class_1922)this.field_9187, blockpos, blockstate, fluidstate);
                            if (optional.isPresent()) {
                                f -= (((Float)optional.get()).floatValue() + 0.3f) * 0.3f;
                            }
                            if (f > 0.0f && this.field_25400.method_29554((class_1927)this, (class_1922)this.field_9187, blockpos, blockstate, f)) {
                                set.add(blockpos);
                            }
                            d4 += d0 * 0.3;
                            d6 += d1 * 0.3;
                            d8 += d2 * 0.3;
                        }
                    }
                }
            }
            this.field_9188.addAll((Collection)set);
            float f2 = this.field_9190 * 2.0f;
            k = class_3532.method_15357((double)(this.field_9195 - (double)f2 - 1.0));
            l = class_3532.method_15357((double)(this.field_9195 + (double)f2 + 1.0));
            int i2 = class_3532.method_15357((double)(this.field_9192 - (double)f2 - 1.0));
            int i1 = class_3532.method_15357((double)(this.field_9192 + (double)f2 + 1.0));
            int j2 = class_3532.method_15357((double)(this.field_9189 - (double)f2 - 1.0));
            int j1 = class_3532.method_15357((double)(this.field_9189 + (double)f2 + 1.0));
            List list = this.field_9187.method_8335(this.field_9185, new class_238((double)k, (double)i2, (double)j2, (double)l, (double)i1, (double)j1));
            class_243 vec3 = new class_243(this.field_9195, this.field_9192, this.field_9189);
            for (class_1297 entity : list) {
                class_1657 player;
                double d9;
                double d7;
                double d5;
                double d13;
                double d12;
                if (entity.method_5659((class_1927)this) || entity == this.method_46406() || entity.method_5679(this.field_9187.method_48963().method_48794()) || entity.method_5679(this.field_9187.method_48963().method_48813()) || !((d12 = Math.sqrt(entity.method_5707(vec3)) / (double)f2) <= 1.0) || (d13 = Math.sqrt((d5 = entity.method_23317() - this.field_9195) * d5 + (d7 = (entity instanceof class_1541 ? entity.method_23318() : entity.method_23320()) - this.field_9192) * d7 + (d9 = entity.method_23321() - this.field_9189) * d9)) == 0.0) continue;
                d5 /= d13;
                d7 /= d13;
                d9 /= d13;
                double d14 = FireBoltExplosion.method_17752((class_243)vec3, (class_1297)entity);
                double d10 = (1.0 - d12) * d14;
                if (entity != this.field_9185) {
                    entity.method_5643(FireBoltExplosion.method_55108((class_1937)this.field_9187, (class_1297)entity), (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f2 + 1.0)));
                }
                double d11 = d10;
                if (entity instanceof class_1309) {
                    d11 = this.field_25400.method_57007(entity);
                }
                entity.method_18799(entity.method_18798().method_1031(d5 * d11, d7 * d11, d9 * d11));
                if (!(entity instanceof class_1657) || (player = (class_1657)entity).method_7325() || player.method_7337() && player.method_31549().field_7479) continue;
                this.method_8351().put(player, new class_243(d5 * d10, d7 * d10, d9 * d10));
            }
        }

        public void method_8350(boolean pSpawnParticles) {
            boolean flag;
            boolean bl = flag = this.field_9184 != class_1927.class_4179.field_40878;
            if (pSpawnParticles) {
                if (this.field_9190 >= 2.0f && flag) {
                    this.field_9187.method_8406((class_2394)class_2398.field_11221, this.field_9195, this.field_9192, this.field_9189, 1.0, 0.0, 0.0);
                } else {
                    this.field_9187.method_8406((class_2394)class_2398.field_11236, this.field_9195, this.field_9192, this.field_9189, 1.0, 0.0, 0.0);
                }
            }
            if (flag) {
                ArrayList objectarraylist = new ArrayList();
                Random random1 = new Random();
                Collections.shuffle(this.field_9188, random1);
                for (class_2338 blockpos : this.method_8346()) {
                    class_2680 blockstate = this.field_9187.method_8320(blockpos);
                    if (blockstate.method_26215()) continue;
                    class_2338 blockpos1 = blockpos.method_10062();
                    if (this.field_9187 instanceof class_3218) {
                        class_2586 blockentity = blockstate.method_31709() ? this.field_9187.method_8321(blockpos) : null;
                        class_8567.class_8568 lootcontext$builder = new class_8567.class_8568((class_3218)this.field_9187).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)blockpos)).method_51874(class_181.field_1229, (Object)class_1799.field_8037).method_51877(class_181.field_1228, (Object)blockentity).method_51877(class_181.field_1226, (Object)this.field_9185);
                        if (this.method_55111() == class_1927.class_4179.field_18687) {
                            lootcontext$builder.method_51874(class_181.field_1225, (Object)Float.valueOf(this.field_9190));
                        }
                        blockstate.method_26189(lootcontext$builder).forEach(itemStack -> FireBoltExplosion.method_24023((List)objectarraylist, (class_1799)itemStack, (class_2338)blockpos1));
                    }
                    this.field_9187.method_8652(blockpos, class_2246.field_10124.method_9564(), 3);
                }
                int fireRadius = 1;
                for (int dx = -fireRadius; dx <= fireRadius; ++dx) {
                    for (int dy = -fireRadius; dy <= fireRadius; ++dy) {
                        for (int dz = -fireRadius; dz <= fireRadius; ++dz) {
                            class_2338 firePos = new class_2338((int)(this.field_9195 + (double)dx), (int)(this.field_9192 + (double)dy), (int)(this.field_9189 + (double)dz));
                            class_2680 fireState = this.field_9187.method_8320(firePos);
                            if (!fireState.method_26215()) continue;
                            this.field_9187.method_8652(firePos, class_2246.field_10036.method_9564(), 3);
                        }
                    }
                }
                this.field_9187.method_8406((class_2394)class_2398.field_11240, this.field_9195, this.field_9192, this.field_9189, 0.0, 0.0, 0.0);
                this.field_9187.method_8406((class_2394)class_2398.field_11251, this.field_9195, this.field_9192, this.field_9189, 0.0, 0.0, 0.0);
                for (Pair pair : objectarraylist) {
                    class_1799 itemstack = (class_1799)pair.getFirst();
                    class_2338 blockpos2 = (class_2338)pair.getSecond();
                    if (itemstack.method_7960()) continue;
                    class_2248.method_9511((class_2680)this.field_9187.method_8320(blockpos2), (class_1937)this.field_9187, (class_2338)blockpos2, null, (class_1297)this.field_9185, (class_1799)itemstack);
                }
            }
        }
    }
}

