/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.projectile;

import com.bdc.bdd.api.entity.core_classes.BddAbilityDragon;
import java.util.function.Predicate;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1657;
import net.minecraft.class_1668;
import net.minecraft.class_1675;
import net.minecraft.class_1927;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseLinearFlightProjectile
extends class_1668 {
    protected static final class_2940<Integer> PROJECTILE_SIZE = class_2945.method_12791(BaseLinearFlightProjectile.class, (class_2941)class_2943.field_13327);
    public BddAbilityDragon dragon;
    public double ticksExisted;
    protected int strengthRadius;
    protected class_243 start;
    protected class_243 end;
    protected int damageTier;

    public BaseLinearFlightProjectile(class_1299 type, class_1937 level) {
        super(type, level);
    }

    protected BaseLinearFlightProjectile(class_1299 type, BddAbilityDragon owner, class_243 start, class_243 end, class_1937 level, int strengthRadius) {
        super(type, level);
        this.dragon = owner;
        this.strengthRadius = strengthRadius;
        this.method_7432((class_1297)owner);
        this.start = start;
        this.end = end;
        this.method_5808(this.start.method_10216(), this.start.method_10214(), this.start.method_10215(), this.method_36454(), this.method_36455());
        this.method_23311();
        double d0 = Math.sqrt(end.method_10216() * end.method_10216() + end.method_10214() * end.method_10214() + end.method_10215() * end.method_10215());
        if (d0 != 0.0) {
            this.field_51893 = end.method_10215() / d0 * 0.2;
        }
    }

    public BaseLinearFlightProjectile(class_1299 pEntityType, BddAbilityDragon owner, double pX, double pY, double pZ, double pOffsetX, double pOffsetY, double pOffsetZ, class_1937 pLevel, int strengthRadius) {
        this(pEntityType, pLevel);
        this.dragon = owner;
        this.strengthRadius = strengthRadius;
        this.method_7432((class_1297)owner);
        this.method_5808(pX, pY, pZ, this.method_36454(), this.method_36455());
        this.method_23311();
        double d0 = Math.sqrt(pOffsetX * pOffsetX + pOffsetY * pOffsetY + pOffsetZ * pOffsetZ);
        if (d0 != 0.0) {
            this.field_51893 = pOffsetZ / d0 * 0.1;
        }
    }

    public static class_239 getLargerHitResultForEntityCollisions(class_1297 pProjectile, Predicate pFilter) {
        class_3966 hitresult1;
        class_243 vec32;
        class_243 vec3 = pProjectile.method_18798();
        class_1937 level = pProjectile.field_6002;
        class_243 vec31 = pProjectile.method_19538();
        class_3965 hitresult = level.method_17742(new class_3959(vec31, vec32 = vec31.method_1019(vec3), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, pProjectile));
        if (hitresult.method_17783() != class_239.class_240.field_1333) {
            vec32 = hitresult.method_17784();
        }
        if ((hitresult1 = class_1675.method_18077((class_1937)level, (class_1297)pProjectile, (class_243)vec31, (class_243)vec32, (class_238)pProjectile.method_5829().method_18804(pProjectile.method_18798()).method_1014(6.0).method_1012(1.0, 3.0, 1.0), (Predicate)pFilter)) != null) {
            hitresult = hitresult1;
        }
        return hitresult;
    }

    public static void spawnParticles(BaseLinearFlightProjectile dragon) {
    }

    protected void method_5693(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_2945.class_9222 pBuilder) {
        pBuilder.method_56912(PROJECTILE_SIZE, (Object)1);
    }

    public void method_5749(class_2487 pCompound) {
        super.method_5749(pCompound);
        this.setProjectileSize(pCompound.method_10550("projectile_size"));
    }

    public void method_5652(class_2487 pCompound) {
        super.method_5652(pCompound);
        pCompound.method_10569("projectile_size", this.getProjectileSize());
    }

    public int getProjectileSize() {
        return (Integer)this.field_6011.method_12789(PROJECTILE_SIZE);
    }

    public void setProjectileSize(int sizeTier) {
        this.field_6011.method_12778(PROJECTILE_SIZE, (Object)sizeTier);
    }

    protected boolean needsTier2ToDamage() {
        return true;
    }

    @Nullable
    public BddAbilityDragon getOwner() {
        return this.dragon;
    }

    public void method_5773() {
        float damage;
        this.method_5670();
        this.ticksExisted += 1.0;
        if (this.field_6002.field_9236 || this.dragon == null || !this.dragon.method_31481()) {
            this.method_5852();
            class_243 vec3 = this.method_18798();
            double d0 = this.method_23317() + vec3.field_1352;
            double d1 = this.method_23318() + vec3.field_1351;
            double d2 = this.method_23321() + vec3.field_1350;
            damage = this.method_7466();
            if (this.method_5799()) {
                for (int i = 0; i < 4; ++i) {
                    this.field_6002.method_8406((class_2394)class_2398.field_11247, d0 - vec3.field_1352 * 0.25, d1 - vec3.field_1351 * 0.25, d2 - vec3.field_1350 * 0.25, vec3.field_1352, vec3.field_1351, vec3.field_1350);
                }
                damage = 0.8f;
            }
            this.method_18799(vec3.method_1031(this.field_51893, this.field_51893, this.field_51893).method_1021((double)damage));
            this.method_5814(d0, d1, d2);
        }
        BddAbilityDragon owner = this.getOwner();
        class_3959.class_3960 blockContext = class_3959.class_3960.field_17558;
        class_239 hitresult = class_1675.method_18074((class_243)this.method_30950(1.0f), (class_1297)this, x$0 -> this.method_26958((class_1297)x$0), (class_243)this.method_18798(), (class_1937)this.field_6002, (float)1.0f, (class_3959.class_3960)blockContext);
        class_239 largerEntityHitResult = BaseLinearFlightProjectile.getLargerHitResultForEntityCollisions((class_1297)this, x$0 -> this.method_26958((class_1297)x$0));
        if (!this.field_6002.field_9236 || owner == null || !owner.method_31481()) {
            class_239.class_240 type;
            if (hitresult.method_17783() != class_239.class_240.field_1333 && hitresult.method_17783() != class_239.class_240.field_1331) {
                this.end = hitresult.method_17784();
                if (this.dragon != null && (type = hitresult.method_17783()) == class_239.class_240.field_1332 && hitresult instanceof class_3965) {
                    boolean flag = this.field_6002.method_8450().method_8355(class_1928.field_19388);
                    if (flag) {
                        this.explode(this.dragon, this.method_23317(), this.method_23318(), this.method_23321(), this.dragon.getExplosionStrength(), flag, flag ? class_1927.class_4179.field_18687 : class_1927.class_4179.field_40878);
                        this.callExplosionEffects(flag, this.dragon);
                    }
                    this.method_31472();
                    this.method_32875((class_6880)class_5712.field_28162, (class_1297)this.getOwner());
                }
            }
            if ((type = largerEntityHitResult.method_17783()) == class_239.class_240.field_1331 && largerEntityHitResult instanceof class_3966) {
                class_3966 entityHitResult = (class_3966)largerEntityHitResult;
                if (largerEntityHitResult.method_17783() != class_239.class_240.field_1333 && largerEntityHitResult.method_17783() != class_239.class_240.field_1332) {
                    this.end = largerEntityHitResult.method_17784();
                    class_1297 entity = entityHitResult.method_17782();
                    if (this.dragon != null && entity != this.dragon && entity != owner && !(entity instanceof BaseLinearFlightProjectile)) {
                        float damage1;
                        class_1309 livingEntity;
                        if (entity instanceof class_1309 && (livingEntity = (class_1309)entity).method_6112(class_1294.field_5918) != null) {
                            return;
                        }
                        boolean mobGriefing = this.field_6002.method_8450().method_8355(class_1928.field_19388);
                        damage = this.dragon.getProjectileDamage(this.dragon, entity, this);
                        float f = damage1 = !(entity instanceof class_1657) && !(entity instanceof BddAbilityDragon) ? damage : damage / 3.0f;
                        if (mobGriefing) {
                            entity.method_5643(this.method_48923().method_48812((class_1309)this.dragon), damage1);
                            entity.method_20803(7);
                            this.method_31472();
                            this.method_32875((class_6880)class_5712.field_28162, (class_1297)this.getOwner());
                        } else if (!mobGriefing) {
                            class_1321 tamableAnimal;
                            class_1309 livingEntity2;
                            if (entity instanceof class_1309 && (livingEntity2 = (class_1309)entity).method_6063() < 20.0f && livingEntity2.method_16914()) {
                                return;
                            }
                            if (entity instanceof class_1321 && (tamableAnimal = (class_1321)entity).method_6181()) {
                                return;
                            }
                            entity.method_5643(this.method_48923().method_48812((class_1309)this.dragon), damage1);
                            entity.method_20803(7);
                            this.method_31472();
                            this.method_32875((class_6880)class_5712.field_28162, (class_1297)this.getOwner());
                        }
                        boolean flag = this.field_6002.method_8450().method_8355(class_1928.field_19388);
                        this.explode(this.dragon, this.method_23317(), this.method_23318(), this.method_23321(), this.dragon.getExplosionStrength(), flag, flag ? class_1927.class_4179.field_18687 : class_1927.class_4179.field_40878);
                        this.callExplosionEffects(flag, this.dragon);
                    }
                }
            }
        }
        this.playParticles();
        if (this.ticksExisted > (double)this.threshHoldForDeletion()) {
            this.method_31472();
            this.ticksExisted = 0.0;
        }
    }

    protected void callExplosionEffects(boolean flag, BddAbilityDragon dragon) {
        if (this instanceof BaseLinearFlightProjectile) {
            if (this.getProjectileSize() == 3 || this.getProjectileSize() == 2 || this.getProjectileSize() == 1) {
                class_1937.class_7867 explosionInteraction = class_1937.class_7867.field_40889;
                this.field_6002.method_8437((class_1297)dragon, this.method_23317(), this.method_23318(), this.method_23321(), (float)dragon.getExplosionStrength(), explosionInteraction);
            }
            if (this.getProjectileSize() == 0) {
                this.field_6002.method_8406((class_2394)class_2398.field_11236, this.method_23317(), this.method_23318(), this.method_23321(), 1.0, 0.0, 0.0);
                this.method_5783(class_3417.field_15090, 4.0f, 1.0f);
            }
        }
    }

    protected void addParticlesAroundSelf(class_2394 p_36209_) {
        for (int i = 0; i < 4; ++i) {
            double d0 = this.field_5974.method_43059() * 0.02;
            double d1 = this.field_5974.method_43059() * 0.02;
            double d = this.field_5974.method_43059() * 0.02;
        }
    }

    public void shoot(class_243 end, float partialTicks, float pInaccuracy, double pVelocity) {
        class_243 endVec = new class_243(end.method_10216() * pVelocity, end.method_10214() * pVelocity, end.method_10215() * pVelocity);
        class_243 vec3 = endVec.method_1029().method_1031(this.field_5974.method_43059() * (double)0.0075f * (double)pInaccuracy, this.field_5974.method_43059() * (double)0.0075f * (double)pInaccuracy, this.field_5974.method_43059() * (double)0.0075f * (double)pInaccuracy).method_1021(pVelocity);
        this.method_18799(vec3);
        double d0 = end.method_37267();
        this.method_36456((float)(class_3532.method_15349((double)end.field_1352, (double)end.field_1350) * 57.2957763671875));
        this.method_36457((float)(class_3532.method_15349((double)end.field_1351, (double)d0) * 57.2957763671875));
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36454();
    }

    public void shootNoScaling(class_243 end, float partialTicks, float pInaccuracy) {
        double pVelocity = 2.0;
        class_243 endVec = new class_243(end.method_10216() * pVelocity, end.method_10214() * pVelocity, end.method_10215() * pVelocity);
        class_243 vec3 = endVec.method_1029().method_1031(this.field_5974.method_43059() * (double)0.0075f * (double)pInaccuracy, this.field_5974.method_43059() * (double)0.0075f * (double)pInaccuracy, this.field_5974.method_43059() * (double)0.0075f * (double)pInaccuracy).method_1021(pVelocity);
        this.method_18799(vec3);
        double d0 = end.method_37267();
        this.method_36456((float)(class_3532.method_15349((double)end.field_1352, (double)end.field_1350) * 57.2957763671875));
        this.method_36457((float)(class_3532.method_15349((double)end.field_1351, (double)d0) * 57.2957763671875));
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36454();
    }

    public void shoot(class_243 end, float partialTicks) {
        this.shoot(end, partialTicks, 1.0f, 5.0);
    }

    public void shoot(class_243 end, float partialTicks, double velocity) {
        this.shoot(end, partialTicks, 1.0f, velocity);
    }

    protected int threshHoldForDeletion() {
        return 300;
    }

    protected abstract class_1927 explode(BddAbilityDragon var1, double var2, double var4, double var6, float var8, boolean var9, class_1927.class_4179 var10);

    public void playParticles() {
        block5: {
            block7: {
                block6: {
                    block4: {
                        if (this.getProjectileSize() != 0) break block4;
                        class_243 vec3 = this.method_18798();
                        double deltaX = vec3.field_1352;
                        double deltaY = vec3.field_1351;
                        double deltaZ = vec3.field_1350;
                        double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * (double)0.7f);
                        for (double j = 0.0; j < dist; j += 1.0) {
                            BaseLinearFlightProjectile.spawnParticles(this);
                        }
                        break block5;
                    }
                    if (this.getProjectileSize() != 1) break block6;
                    class_243 vec3 = this.method_18798();
                    double deltaX = vec3.field_1352;
                    double deltaY = vec3.field_1351;
                    double deltaZ = vec3.field_1350;
                    double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 4.0);
                    for (double j = 0.0; j < dist; j += 1.0) {
                        BaseLinearFlightProjectile.spawnParticles(this);
                    }
                    break block5;
                }
                if (this.getProjectileSize() != 2) break block7;
                class_243 vec3 = this.method_18798();
                double deltaX = vec3.field_1352;
                double deltaY = vec3.field_1351;
                double deltaZ = vec3.field_1350;
                double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 14.0);
                for (double j = 0.0; j < dist; j += 1.0) {
                    BaseLinearFlightProjectile.spawnParticles(this);
                }
                break block5;
            }
            if (this.getProjectileSize() != 3) break block5;
            class_243 vec3 = this.method_18798();
            double deltaX = vec3.field_1352;
            double deltaY = vec3.field_1351;
            double deltaZ = vec3.field_1350;
            double dist = Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) * 32.0);
            for (double j = 0.0; j < dist; j += 1.0) {
                BaseLinearFlightProjectile.spawnParticles(this);
            }
        }
    }

    public boolean method_5809() {
        return false;
    }

    public int getDamageTier() {
        return this.damageTier;
    }

    public void setDamageTier(int damageTier) {
        this.damageTier = damageTier;
    }
}

