/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.registry.builders.blocks;

import com.bdc.bdd.BddConstants;
import com.bdc.bdd.client.BddClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2248;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_5614;

public class BddBlockEntityBuilder<T extends class_2586> {
    public static final List<BddBlockEntityBuilder<?>> REGISTERED_BUILDERS = new ArrayList();
    private final String name;
    private final class_2591.class_5559<T> blockEntityFactory;
    private Supplier<class_5614<T>> rendererProvider;
    private Supplier<class_2591<T>> blockEntityType;
    private List<Supplier<class_2248>> validBlockSuppliers;

    public BddBlockEntityBuilder(String name, class_2591.class_5559<T> blockEntityFactory) {
        this.name = name;
        this.blockEntityFactory = blockEntityFactory;
        this.validBlockSuppliers = new ArrayList<Supplier<class_2248>>();
    }

    public static <T extends class_2586> BddBlockEntityBuilder<T> blockEntity(String name, class_2591.class_5559<T> factory) {
        return new BddBlockEntityBuilder<T>(name, factory);
    }

    public BddBlockEntityBuilder<T> validBlocks(Supplier<class_2248> ... blockSuppliers) {
        this.validBlockSuppliers = Arrays.asList(blockSuppliers);
        return this;
    }

    public BddBlockEntityBuilder<T> renderer(class_5614<T> renderer) {
        this.rendererProvider = () -> renderer;
        return this;
    }

    public Supplier<class_2591<T>> register() {
        Supplier blockEntityTypeSupplier = BddConstants.PlatformHelper.REGISTRY.registerBlockEntity(this.name, () -> {
            class_2248[] blocks = (class_2248[])this.validBlockSuppliers.stream().map(Supplier::get).toArray(class_2248[]::new);
            class_2591 type = class_2591.class_2592.method_20528(this.blockEntityFactory, (class_2248[])blocks).method_11034(null);
            this.blockEntityType = () -> type;
            return type;
        });
        if (this.rendererProvider != null) {
            BddClient.queueRenderer((entityConsumer, blockConsumer) -> blockConsumer.accept(this.blockEntityType.get(), this.rendererProvider.get()));
        }
        REGISTERED_BUILDERS.add(this);
        return blockEntityTypeSupplier;
    }

    public String getName() {
        return this.name;
    }

    public Supplier<class_2591<T>> getBlockEntityType() {
        return this.blockEntityType;
    }
}

