/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.registry.builders.entity;

import com.bdc.bdd.BddConstants;
import com.bdc.bdd.client.BddClient;
import com.bdc.bdd.registry.helpers.EntityAttributeRegistry;
import com.bdc.bdd.registry.helpers.items.BddItemModelGenerator;
import com.bdc.bdd.registry.helpers.items.BddItemModelTemplates;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1826;
import net.minecraft.class_5132;
import net.minecraft.class_5617;

public class BddEntityBuilder<T extends class_1308> {
    public static String name;
    public final class_1299.class_4049<T> factory;
    public final class_1311 category;
    public float width = 0.6f;
    public float height = 1.8f;
    public static boolean hasSpawnEgg;
    public int primaryEggColor;
    public int secondaryEggColor;
    public Supplier<class_5132.class_5133> attributeBuilder = null;
    public class_5617<T> rendererProvider = null;
    public boolean hasVariants = false;
    public static final List<String> DRAGON_NAMES;
    public Supplier<class_1761> tabSupplier = null;
    public static final Map<Supplier<class_1761>, List<Supplier<class_1792>>> SPAWN_EGGS_BY_TAB;

    public BddEntityBuilder(String name, class_1299.class_4049<T> factory, class_1311 category) {
        BddEntityBuilder.name = name;
        this.factory = factory;
        this.category = category;
    }

    public BddEntityBuilder<T> sized(float width, float height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public BddEntityBuilder<T> spawnEgg(int primaryColor, int secondaryColor) {
        hasSpawnEgg = true;
        this.primaryEggColor = primaryColor;
        this.secondaryEggColor = secondaryColor;
        return this;
    }

    public BddEntityBuilder<T> attributes(Supplier<class_5132.class_5133> attributes) {
        this.attributeBuilder = attributes;
        return this;
    }

    public BddEntityBuilder<T> renderer(class_5617<T> rendererProvider) {
        this.rendererProvider = rendererProvider;
        return this;
    }

    public BddEntityBuilder<T> loadVariants() {
        this.hasVariants = true;
        return this;
    }

    public BddEntityBuilder<T> tab(Supplier<class_1761> tabSupplier) {
        this.tabSupplier = tabSupplier;
        return this;
    }

    public static List<Supplier<class_1792>> getSpawnEggsForTab(class_1761 tab) {
        ArrayList<Supplier<class_1792>> spawnEggs = new ArrayList<Supplier<class_1792>>();
        for (Map.Entry<Supplier<class_1761>, List<Supplier<class_1792>>> entry : SPAWN_EGGS_BY_TAB.entrySet()) {
            if (entry.getKey().get() != tab) continue;
            spawnEggs.addAll((Collection<Supplier<class_1792>>)entry.getValue());
        }
        return spawnEggs;
    }

    public Supplier<class_1299<T>> register() {
        Supplier entityTypeSupplier = BddConstants.PlatformHelper.REGISTRY.registerEntity(name, () -> class_1299.class_1300.method_5903(this.factory, (class_1311)this.category).method_17687(this.width, this.height).method_5905(name));
        if (hasSpawnEgg) {
            this.registerSpawnEgg(name, entityTypeSupplier, this.primaryEggColor, this.secondaryEggColor, this.tabSupplier);
        }
        if (this.attributeBuilder != null) {
            EntityAttributeRegistry.queueAttributes(entityTypeSupplier, this.attributeBuilder);
        }
        if (this.rendererProvider != null) {
            BddClient.queueRenderer((entityConsumer, blockConsumer) -> entityConsumer.accept((class_1299)entityTypeSupplier.get(), this.rendererProvider));
        }
        if (this.hasVariants) {
            DRAGON_NAMES.add(name);
        }
        return entityTypeSupplier;
    }

    public static void doSpawnEggDatagen() {
        if (hasSpawnEgg) {
            String spawnEggName = name + "_spawn_egg";
            BddItemModelGenerator.generateItemModel("bdd", spawnEggName, BddItemModelTemplates.SPAWN_EGG);
        }
    }

    public static List<String> getDragonNames() {
        return List.copyOf(DRAGON_NAMES);
    }

    public Supplier<class_1792> registerSpawnEgg(String name, Supplier<class_1299<T>> entityType, int primaryColor, int secondaryColor, Supplier<class_1761> tabSupplier) {
        Supplier<class_1792> spawnEggSupplier = BddConstants.PlatformHelper.REGISTRY.registerItem(name + "_spawn_egg", () -> new class_1826((class_1299)entityType.get(), primaryColor, secondaryColor, new class_1792.class_1793()));
        if (tabSupplier != null) {
            SPAWN_EGGS_BY_TAB.computeIfAbsent(tabSupplier, k -> new ArrayList()).add(spawnEggSupplier);
        }
        return spawnEggSupplier;
    }

    static {
        hasSpawnEgg = false;
        DRAGON_NAMES = new ArrayList<String>();
        SPAWN_EGGS_BY_TAB = new HashMap<Supplier<class_1761>, List<Supplier<class_1792>>>();
    }
}

