/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.registry.builders.items;

import com.bdc.bdd.BddConstants;
import com.bdc.bdd.registry.helpers.items.ArmorSetConfig;
import com.bdc.bdd.registry.helpers.items.BddItemModelGenerator;
import com.bdc.bdd.registry.helpers.items.BddItemModelTemplates;
import com.bdc.bdd.registry.helpers.items.ToolsetConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1810;
import net.minecraft.class_1821;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class BddItemBuilder<T extends class_1792> {
    public static final List<String> generatedItems = new ArrayList<String>();
    public static final Map<String, BddItemModelTemplates> customModelMap = new HashMap<String, BddItemModelTemplates>();
    public static String itemName;
    public final Function<class_1792.class_1793, T> itemConstructor;
    public Consumer<class_1792.class_1793> propertiesConsumer = props -> {};
    public static final Map<String, List<Supplier<class_1792>>> TOOLSETS;
    public static final Map<String, List<Supplier<class_1792>>> ARMORSETS;
    private boolean isToolset = false;
    private boolean isArmorSet = false;

    public BddItemBuilder(String name, Function<class_1792.class_1793, T> itemConstructor) {
        itemName = name;
        this.itemConstructor = itemConstructor;
    }

    public static <T extends class_1792> BddItemBuilder<T> item(String name, Function<class_1792.class_1793, T> itemConstructor) {
        return new BddItemBuilder<T>(name, itemConstructor);
    }

    public static void doItemModelGen() {
        for (String itemName : generatedItems) {
            BddItemModelTemplates template = customModelMap.getOrDefault(itemName, BddItemModelTemplates.HANDHELD);
            if (itemName.endsWith("_sword") || itemName.endsWith("_pickaxe") || itemName.endsWith("_axe") || itemName.endsWith("_shovel") || itemName.endsWith("_hoe")) {
                template = BddItemModelTemplates.HANDHELD;
            } else if (itemName.endsWith("_helmet") || itemName.endsWith("_chestplate") || itemName.endsWith("_leggings") || itemName.endsWith("_boots")) {
                template = BddItemModelTemplates.GENERATED;
            }
            BddItemModelGenerator.generateItemModel("bdd", itemName, template);
        }
    }

    public BddItemBuilder<T> properties(Consumer<class_1792.class_1793> consumer) {
        this.propertiesConsumer = consumer;
        return this;
    }

    public BddItemBuilder<T> model(BddItemModelTemplates template) {
        customModelMap.put(itemName, template);
        return this;
    }

    private <U extends class_1792> Supplier<U> registerTool(String toolName, Function<class_1792.class_1793, U> toolConstructor, Consumer<class_1792.class_1793> toolProperties) {
        class_1792.class_1793 properties = new class_1792.class_1793();
        this.propertiesConsumer.accept(properties);
        if (toolProperties != null) {
            toolProperties.accept(properties);
        }
        Supplier<class_1792> itemSupplier = () -> (class_1792)toolConstructor.apply(properties);
        BddConstants.PlatformHelper.REGISTRY.registerItem(toolName, itemSupplier);
        generatedItems.add(toolName);
        return itemSupplier;
    }

    public BddItemBuilder<class_1829> sword(Consumer<class_1792.class_1793> swordProperties, class_1832 tier, int attackDamage, float attackSpeed) {
        String toolName = itemName + "_sword";
        this.registerTool(toolName, props -> new class_1829(tier, props.method_57348(class_1810.method_57346((class_1832)tier, (float)attackDamage, (float)attackSpeed))), swordProperties);
        return this;
    }

    public BddItemBuilder<class_1810> pickaxe(Consumer<class_1792.class_1793> pickaxeProperties, class_1832 tier, int attackDamage, float attackSpeed) {
        String toolName = itemName + "_pickaxe";
        this.registerTool(toolName, props -> new class_1810(tier, props.method_57348(class_1810.method_57346((class_1832)tier, (float)attackDamage, (float)attackSpeed))), pickaxeProperties);
        return this;
    }

    public BddItemBuilder<class_1743> axe(Consumer<class_1792.class_1793> axeProperties, class_1832 tier, int attackDamage, float attackSpeed) {
        String toolName = itemName + "_axe";
        this.registerTool(toolName, props -> new class_1743(tier, props.method_57348(class_1810.method_57346((class_1832)tier, (float)attackDamage, (float)attackSpeed))), axeProperties);
        return this;
    }

    public BddItemBuilder<class_1821> shovel(Consumer<class_1792.class_1793> shovelProperties, class_1832 tier, int attackDamage, float attackSpeed) {
        String toolName = itemName + "_shovel";
        this.registerTool(toolName, props -> new class_1821(tier, props.method_57348(class_1810.method_57346((class_1832)tier, (float)attackDamage, (float)attackSpeed))), shovelProperties);
        return this;
    }

    public BddItemBuilder<class_1794> hoe(Consumer<class_1792.class_1793> hoeProperties, class_1832 tier, int attackDamage, float attackSpeed) {
        String toolName = itemName + "_hoe";
        this.registerTool(toolName, props -> new class_1794(tier, props.method_57348(class_1810.method_57346((class_1832)tier, (float)attackDamage, (float)attackSpeed))), hoeProperties);
        return this;
    }

    public BddItemBuilder<T> toolset(class_1832 tier, ToolsetConfig config) {
        this.isToolset = true;
        if (config.swordProperties != null) {
            this.sword(config.swordProperties, tier, config.swordAttackDamage, config.swordAttackSpeed);
        }
        if (config.pickaxeProperties != null) {
            this.pickaxe(config.pickaxeProperties, tier, config.pickaxeAttackDamage, config.pickaxeAttackSpeed);
        }
        if (config.axeProperties != null) {
            this.axe(config.axeProperties, tier, config.axeAttackDamage, config.axeAttackSpeed);
        }
        if (config.shovelProperties != null) {
            this.shovel(config.shovelProperties, tier, config.shovelAttackDamage, config.shovelAttackSpeed);
        }
        if (config.hoeProperties != null) {
            this.hoe(config.hoeProperties, tier, config.hoeAttackDamage, config.hoeAttackSpeed);
        }
        TOOLSETS.put(BddItemBuilder.itemName, generatedItems.stream().map(itemName -> () -> (class_1792)class_7923.field_41178.method_10223(class_2960.method_60655((String)"bdd", (String)itemName))).collect(Collectors.toList()));
        return this;
    }

    public BddItemBuilder<class_1738> helmet(Consumer<class_1792.class_1793> properties, class_6880<class_1741> material) {
        String armorName = itemName + "_helmet";
        this.registerTool(armorName, props -> new class_1738(material, class_1738.class_8051.field_41934, props), properties);
        return this;
    }

    public BddItemBuilder<class_1738> chestplate(Consumer<class_1792.class_1793> properties, class_6880<class_1741> material) {
        String armorName = itemName + "_chestplate";
        this.registerTool(armorName, props -> new class_1738(material, class_1738.class_8051.field_41935, props), properties);
        return this;
    }

    public BddItemBuilder<class_1738> leggings(Consumer<class_1792.class_1793> properties, class_6880<class_1741> material) {
        String armorName = itemName + "_leggings";
        this.registerTool(armorName, props -> new class_1738(material, class_1738.class_8051.field_41936, props), properties);
        return this;
    }

    public BddItemBuilder<class_1738> boots(Consumer<class_1792.class_1793> properties, class_6880<class_1741> material) {
        String armorName = itemName + "_boots";
        this.registerTool(armorName, props -> new class_1738(material, class_1738.class_8051.field_41937, props), properties);
        return this;
    }

    public BddItemBuilder<T> armorSet(class_6880<class_1741> material, ArmorSetConfig config) {
        this.isArmorSet = true;
        if (config.helmetProperties != null) {
            this.helmet(config.helmetProperties, material);
        }
        if (config.chestplateProperties != null) {
            this.chestplate(config.chestplateProperties, material);
        }
        if (config.leggingsProperties != null) {
            this.leggings(config.leggingsProperties, material);
        }
        if (config.bootsProperties != null) {
            this.boots(config.bootsProperties, material);
        }
        ARMORSETS.put(itemName, generatedItems.stream().map(name -> () -> (class_1792)class_7923.field_41178.method_10223(class_2960.method_60655((String)"bdd", (String)name))).collect(Collectors.toList()));
        return this;
    }

    public Supplier<class_1792> register() {
        class_1792.class_1793 properties = new class_1792.class_1793();
        this.propertiesConsumer.accept(properties);
        generatedItems.add(itemName);
        Supplier<class_1792> itemSupplier = () -> (class_1792)this.itemConstructor.apply(properties);
        return BddConstants.PlatformHelper.REGISTRY.registerItem(itemName, itemSupplier);
    }

    static {
        TOOLSETS = new HashMap<String, List<Supplier<class_1792>>>();
        ARMORSETS = new HashMap<String, List<Supplier<class_1792>>>();
    }
}

