/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.registry.builders.tabs;

import com.bdc.bdd.BddConstants;
import com.bdc.bdd.registry.builders.entity.BddEntityBuilder;
import com.bdc.bdd.registry.builders.items.BddItemBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import net.minecraft.class_1299;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;

public class BddTabBuilder {
    private final String id;
    private static String modId;
    private Supplier<class_1792> iconSupplier;
    private class_1761.class_7914 displayItemsGenerator;
    private String backgroundSuffix = "item_search.png";
    private static final Map<Supplier<class_1761>, BddTabBuilder> TAB_BUILDERS;

    public BddTabBuilder(String id, String modId) {
        this.id = id;
        BddTabBuilder.modId = modId;
    }

    public BddTabBuilder icon(Supplier<class_1792> iconSupplier) {
        this.iconSupplier = iconSupplier;
        return this;
    }

    public BddTabBuilder icon(class_1792 iconItem) {
        this.iconSupplier = () -> iconItem;
        return this;
    }

    public static Supplier<class_1792> useSpawnEgg(Supplier<? extends class_1299<?>> entityTypeSupplier) {
        return () -> {
            class_1299 entityType = (class_1299)entityTypeSupplier.get();
            if (entityType != null) {
                String entityId = class_7923.field_41177.method_10221((Object)entityType).method_12832();
                String spawnEggId = entityId + "_spawn_egg";
                return (class_1792)class_7923.field_41178.method_10223(class_2960.method_60655((String)modId, (String)spawnEggId));
            }
            BaseLogger.log((Level)BaseLogLevel.ERROR, (String)("Spawn egg icon could not be found for entity: " + String.valueOf(entityType)));
            return class_1802.field_8162;
        };
    }

    public BddTabBuilder displayItems(class_1761.class_7914 displayItemsGenerator) {
        this.displayItemsGenerator = displayItemsGenerator;
        return this;
    }

    public BddTabBuilder background(String backgroundSuffix) {
        this.backgroundSuffix = backgroundSuffix;
        return this;
    }

    public BddTabBuilder background() {
        this.backgroundSuffix = "item_search.png";
        return this;
    }

    public Supplier<class_1761> register() {
        class_1761.class_7913 tabBuilder = class_1761.method_47307((class_1761.class_7915)class_1761.class_7915.field_41049, (int)0).method_47321((class_2561)class_2561.method_43471((String)this.id)).method_47320(() -> {
            class_1792 item = this.iconSupplier.get();
            return item != null ? new class_1799((class_1935)item) : class_1799.field_8037;
        }).method_47317((parameters, output) -> {
            class_1792 item;
            HashSet<class_1792> addedItems = new HashSet<class_1792>();
            if (this.displayItemsGenerator != null) {
                this.displayItemsGenerator.accept(parameters, (stack, tabVisibility) -> {
                    class_1792 item = stack.method_7909();
                    if (item != null && addedItems.add(item)) {
                        output.method_45417(stack, tabVisibility);
                        BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Adding item from displayItemsGenerator: " + String.valueOf(class_7923.field_41178.method_10221((Object)item))));
                    }
                });
            }
            if ((item = this.iconSupplier.get()) != null) {
                List<Supplier<class_1792>> toolsetItems = BddItemBuilder.TOOLSETS.get(item.method_7876());
                if (toolsetItems != null) {
                    for (Supplier<class_1792> tool : toolsetItems) {
                        class_1792 toolItem = tool.get();
                        if (toolItem == null || !addedItems.add(toolItem)) continue;
                        output.method_45417(new class_1799((class_1935)toolItem), class_1761.class_7705.field_40191);
                        BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Adding icon toolset item: " + String.valueOf(class_7923.field_41178.method_10221((Object)toolItem))));
                    }
                } else if (addedItems.add(item)) {
                    output.method_45417(new class_1799((class_1935)item), class_1761.class_7705.field_40191);
                    BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Adding icon item: " + String.valueOf(class_7923.field_41178.method_10221((Object)item))));
                }
            }
        });
        class_1761 tab = tabBuilder.method_47324();
        Supplier<class_1761> tabSupplier = () -> tab;
        TAB_BUILDERS.put(tabSupplier, this);
        BddConstants.PlatformHelper.REGISTRY.registerTab(this.id, tabSupplier);
        return tabSupplier;
    }

    public static void addToolset(class_1792 item, class_1761.class_7704 populator) {
        if (item != null) {
            List<Supplier<class_1792>> toolset;
            HashSet<class_1792> addedItems = new HashSet<class_1792>();
            String fullId = class_7923.field_41178.method_10221((Object)item).method_12832();
            String[] toolSuffixes = new String[]{"_sword", "_pickaxe", "_axe", "_shovel", "_hoe"};
            String baseId = fullId;
            for (String suffix : toolSuffixes) {
                if (!fullId.endsWith(suffix)) continue;
                baseId = fullId.substring(0, fullId.length() - suffix.length());
                break;
            }
            if ((toolset = BddItemBuilder.TOOLSETS.get(baseId)) != null) {
                for (Supplier<class_1792> tool : toolset) {
                    class_1792 toolItem = tool.get();
                    if (toolItem == null || !addedItems.add(toolItem)) continue;
                    populator.method_45417(new class_1799((class_1935)toolItem), class_1761.class_7705.field_40191);
                    BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Adding toolset item: " + String.valueOf(class_7923.field_41178.method_10221((Object)toolItem))));
                }
                return;
            }
            if (addedItems.add(item)) {
                populator.method_45417(new class_1799((class_1935)item), class_1761.class_7705.field_40191);
                BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Adding single toolset item: " + fullId));
            }
        }
    }

    public static void addArmorSet(class_1792 item, class_1761.class_7704 populator) {
        if (item != null) {
            List<Supplier<class_1792>> armorSets;
            HashSet<class_1792> addedItems = new HashSet<class_1792>();
            String fullId = class_7923.field_41178.method_10221((Object)item).method_12832();
            String[] toolSuffixes = new String[]{"_helmet", "_chestplate", "_leggings", "_boots"};
            String baseId = fullId;
            for (String suffix : toolSuffixes) {
                if (!fullId.endsWith(suffix)) continue;
                baseId = fullId.substring(0, fullId.length() - suffix.length());
                break;
            }
            if ((armorSets = BddItemBuilder.ARMORSETS.get(baseId)) != null) {
                for (Supplier<class_1792> armor : armorSets) {
                    class_1792 armorItem = armor.get();
                    if (armorItem == null || !addedItems.add(armorItem)) continue;
                    populator.method_45417(new class_1799((class_1935)armorItem), class_1761.class_7705.field_40191);
                    BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Adding armor item: " + String.valueOf(class_7923.field_41178.method_10221((Object)armorItem))));
                }
                return;
            }
            if (addedItems.add(item)) {
                populator.method_45417(new class_1799((class_1935)item), class_1761.class_7705.field_40191);
                BaseLogger.log((Level)BaseLogLevel.INFO, (String)("Adding single armor item: " + fullId));
            }
        }
    }

    public static void addSpawnEgg(class_1299<?> entityType, class_1761.class_7704 populator) {
        if (entityType != null) {
            String entityId = class_7923.field_41177.method_10221(entityType).method_12832();
            String spawnEggId = entityId + "_spawn_egg";
            class_1792 spawnEggItem = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60655((String)modId, (String)spawnEggId));
            populator.method_45421((class_1935)spawnEggItem);
        }
    }

    public static void addAllSpawnEggs(class_1761.class_7704 populator) {
        List<String> names = BddEntityBuilder.getDragonNames();
        Iterator<String> iterator = names.iterator();
        while (iterator.hasNext()) {
            String name;
            String entityId = name = iterator.next();
            String spawnEggId = entityId + "_spawn_egg";
            try {
                class_1792 spawnEggItem = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60655((String)modId, (String)spawnEggId));
                populator.method_45421((class_1935)spawnEggItem);
            }
            catch (Exception e) {
                BaseLogger.log((Level)BaseLogLevel.ERROR, (String)("Spawn egg for entity " + entityId + " not found!"));
            }
        }
    }

    static {
        TAB_BUILDERS = new HashMap<Supplier<class_1761>, BddTabBuilder>();
    }
}

