/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.registry.helpers.blockstates;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Map;

public abstract class BddBlockstateTemplates {
    public static final BddBlockstateTemplates SIMPLE_BLOCK = new BddBlockstateTemplates(){

        @Override
        public JsonObject generateBlockstate(String modId, String blockName, Map<String, String> properties) {
            JsonObject blockstate = new JsonObject();
            JsonObject variants = new JsonObject();
            JsonObject variant = new JsonObject();
            variant.addProperty("model", modId + ":block/" + blockName);
            variants.add("", (JsonElement)variant);
            blockstate.add("variants", (JsonElement)variants);
            return blockstate;
        }
    };
    public static final BddBlockstateTemplates ORIENTED_BLOCK = new BddBlockstateTemplates(){

        @Override
        public JsonObject generateBlockstate(String modId, String blockName, Map<String, String> properties) {
            JsonObject blockstate = new JsonObject();
            JsonObject variants = new JsonObject();
            String model = modId + ":block/" + blockName;
            String horizontalModel = properties.getOrDefault("horizontal_model", model);
            JsonObject xVariant = new JsonObject();
            xVariant.addProperty("model", horizontalModel);
            xVariant.addProperty("x", (Number)90);
            xVariant.addProperty("y", (Number)90);
            variants.add("axis=x", (JsonElement)xVariant);
            JsonObject yVariant = new JsonObject();
            yVariant.addProperty("model", model);
            variants.add("axis=y", (JsonElement)yVariant);
            JsonObject zVariant = new JsonObject();
            zVariant.addProperty("model", horizontalModel);
            zVariant.addProperty("x", (Number)90);
            variants.add("axis=z", (JsonElement)zVariant);
            blockstate.add("variants", (JsonElement)variants);
            return blockstate;
        }
    };
    public static final BddBlockstateTemplates VARIANT_BLOCK = new BddBlockstateTemplates(){

        @Override
        public JsonObject generateBlockstate(String modId, String blockName, Map<String, String> properties) {
            String[] values;
            JsonObject blockstate = new JsonObject();
            JsonObject variants = new JsonObject();
            String propertyName = properties.getOrDefault("property", "type");
            for (String value : values = properties.getOrDefault("values", "default").split(",")) {
                JsonObject variant = new JsonObject();
                variant.addProperty("model", modId + ":block/" + blockName + "_" + value.trim());
                variants.add(propertyName + "=" + value.trim(), (JsonElement)variant);
            }
            blockstate.add("variants", (JsonElement)variants);
            return blockstate;
        }
    };
    public static final BddBlockstateTemplates MULTIPART_BLOCK = new BddBlockstateTemplates(){

        @Override
        public JsonObject generateBlockstate(String modId, String blockName, Map<String, String> properties) {
            String[] directions;
            JsonObject blockstate = new JsonObject();
            JsonArray multipart = new JsonArray();
            JsonObject basePart = new JsonObject();
            basePart.addProperty("model", modId + ":block/" + blockName);
            multipart.add((JsonElement)basePart);
            for (String dir : directions = new String[]{"north", "east", "south", "west"}) {
                JsonObject part = new JsonObject();
                JsonObject when = new JsonObject();
                when.addProperty(dir, "true");
                part.add("when", (JsonElement)when);
                JsonObject apply = new JsonObject();
                apply.addProperty("model", modId + ":block/" + blockName + "_" + dir);
                part.add("apply", (JsonElement)apply);
                multipart.add((JsonElement)part);
            }
            blockstate.add("multipart", (JsonElement)multipart);
            return blockstate;
        }
    };
    public static final BddBlockstateTemplates DOOR_BLOCK = new BddBlockstateTemplates(){

        @Override
        public JsonObject generateBlockstate(String modId, String blockName, Map<String, String> properties) {
            JsonObject blockstate = new JsonObject();
            JsonObject variants = new JsonObject();
            String modelPrefix = properties.getOrDefault("model_prefix", modId + ":block/" + blockName);
            String[] facings = new String[]{"east", "north", "south", "west"};
            String[] halves = new String[]{"lower", "upper"};
            String[] hinges = new String[]{"left", "right"};
            String[] opens = new String[]{"false", "true"};
            int[][] rotations = new int[][]{{0, 90, 270}, {270, 0, 180}, {90, 180, 0}, {180, 270, 90}};
            for (int f = 0; f < facings.length; ++f) {
                String facing = facings[f];
                for (String half : halves) {
                    for (String hinge : hinges) {
                        for (String open : opens) {
                            String variantKey = String.format("facing=%s,half=%s,hinge=%s,open=%s", facing, half, hinge, open);
                            JsonObject variant = new JsonObject();
                            String modelSuffix = String.format("%s_%s%s", half.equals("lower") ? "bottom" : "top", hinge, open.equals("true") ? "_open" : "");
                            String model = modelPrefix + "_" + modelSuffix;
                            variant.addProperty("model", model);
                            int rotationIndex = open.equals("true") ? (hinge.equals("left") ? 1 : 2) : 0;
                            int yRotation = rotations[f][rotationIndex];
                            if (yRotation != 0) {
                                variant.addProperty("y", (Number)yRotation);
                            }
                            variants.add(variantKey, (JsonElement)variant);
                        }
                    }
                }
            }
            blockstate.add("variants", (JsonElement)variants);
            return blockstate;
        }
    };
    public static final BddBlockstateTemplates FENCE_BLOCK = new BddBlockstateTemplates(){

        @Override
        public JsonObject generateBlockstate(String modId, String blockName, Map<String, String> properties) {
            JsonObject blockstate = new JsonObject();
            JsonArray multipart = new JsonArray();
            String prefix = properties.getOrDefault("prefix", "");
            String modelPath = prefix.isEmpty() ? modId + ":block/" + blockName : modId + ":block/" + prefix + "/" + blockName;
            JsonObject postPart = new JsonObject();
            postPart.addProperty("model", modelPath + "_fence_post");
            multipart.add((JsonElement)postPart);
            String[] directions = new String[]{"north", "east", "south", "west"};
            int[] rotations = new int[]{0, 90, 180, 270};
            for (int i = 0; i < directions.length; ++i) {
                String dir = directions[i];
                JsonObject part = new JsonObject();
                JsonObject when = new JsonObject();
                when.addProperty(dir, "true");
                part.add("when", (JsonElement)when);
                JsonObject apply = new JsonObject();
                apply.addProperty("model", modelPath + "_fence_side");
                apply.addProperty("uvlock", Boolean.valueOf(true));
                if (rotations[i] != 0) {
                    apply.addProperty("y", (Number)rotations[i]);
                }
                part.add("apply", (JsonElement)apply);
                multipart.add((JsonElement)part);
            }
            blockstate.add("multipart", (JsonElement)multipart);
            return blockstate;
        }
    };
    public static final BddBlockstateTemplates BUTTON_BLOCK = new BddBlockstateTemplates(){

        @Override
        public JsonObject generateBlockstate(String modId, String blockName, Map<String, String> properties) {
            JsonObject blockstate = new JsonObject();
            JsonObject variants = new JsonObject();
            String[] faces = new String[]{"ceiling", "floor", "wall"};
            String[] facings = new String[]{"east", "north", "south", "west"};
            String[] powered = new String[]{"false", "true"};
            int[][] ceilingRotations = new int[][]{{270, 180, 0, 90}};
            int[][] floorRotations = new int[][]{{90, 0, 180, 270}};
            int[][] wallRotations = new int[][]{{90, 0, 180, 270}};
            for (String face : faces) {
                for (int f = 0; f < facings.length; ++f) {
                    String facing = facings[f];
                    for (String power : powered) {
                        String variantKey = String.format("face=%s,facing=%s,powered=%s", face, facing, power);
                        JsonObject variant = new JsonObject();
                        String model = power.equals("true") ? modId + ":block/" + blockName + "_pressed" : modId + ":block/" + blockName;
                        variant.addProperty("model", model);
                        int xRotation = face.equals("ceiling") ? 180 : (face.equals("wall") ? 90 : 0);
                        int yRotation = 0;
                        if (face.equals("ceiling")) {
                            yRotation = ceilingRotations[0][f];
                        } else if (face.equals("floor")) {
                            yRotation = floorRotations[0][f];
                        } else if (face.equals("wall")) {
                            yRotation = wallRotations[0][f];
                        }
                        if (xRotation != 0) {
                            variant.addProperty("x", (Number)xRotation);
                        }
                        if (yRotation != 0) {
                            variant.addProperty("y", (Number)yRotation);
                        }
                        if (face.equals("wall")) {
                            variant.addProperty("uvlock", Boolean.valueOf(true));
                        }
                        variants.add(variantKey, (JsonElement)variant);
                    }
                }
            }
            blockstate.add("variants", (JsonElement)variants);
            return blockstate;
        }
    };
    public static final BddBlockstateTemplates SLAB_BLOCK = new BddBlockstateTemplates(){

        @Override
        public JsonObject generateBlockstate(String modId, String blockName, Map<String, String> properties) {
            JsonObject blockstate = new JsonObject();
            JsonObject variants = new JsonObject();
            String doubleModel = properties.getOrDefault("double_model", modId + ":block/" + blockName.replace("_slab", "_planks"));
            JsonObject bottomVariant = new JsonObject();
            bottomVariant.addProperty("model", modId + ":block/" + blockName);
            variants.add("type=bottom", (JsonElement)bottomVariant);
            JsonObject topVariant = new JsonObject();
            topVariant.addProperty("model", modId + ":block/" + blockName + "_top");
            variants.add("type=top", (JsonElement)topVariant);
            JsonObject doubleVariant = new JsonObject();
            doubleVariant.addProperty("model", doubleModel);
            variants.add("type=double", (JsonElement)doubleVariant);
            blockstate.add("variants", (JsonElement)variants);
            return blockstate;
        }
    };
    public static final BddBlockstateTemplates TRAPDOOR_BLOCK = new BddBlockstateTemplates(){

        @Override
        public JsonObject generateBlockstate(String modId, String blockName, Map<String, String> properties) {
            JsonObject blockstate = new JsonObject();
            JsonObject variants = new JsonObject();
            String[] facings = new String[]{"east", "north", "south", "west"};
            String[] halves = new String[]{"bottom", "top"};
            String[] opens = new String[]{"false", "true"};
            int[][] rotations = new int[][]{{90, 0, 180, 270}, {270, 180, 0, 90}};
            for (String facing : facings) {
                for (String half : halves) {
                    for (String open : opens) {
                        String variantKey = String.format("facing=%s,half=%s,open=%s", facing, half, open);
                        JsonObject variant = new JsonObject();
                        String model = open.equals("true") ? modId + ":block/" + blockName + "_open" : modId + ":block/" + blockName + (half.equals("bottom") ? "_bottom" : "_top");
                        variant.addProperty("model", model);
                        int yRotation = rotations[half.equals("bottom") ? 0 : 1][Arrays.asList(facings).indexOf(facing)];
                        if (yRotation != 0) {
                            variant.addProperty("y", (Number)yRotation);
                        }
                        if (open.equals("true") && half.equals("top")) {
                            variant.addProperty("x", (Number)180);
                        }
                        variants.add(variantKey, (JsonElement)variant);
                    }
                }
            }
            blockstate.add("variants", (JsonElement)variants);
            return blockstate;
        }
    };
    public static final BddBlockstateTemplates STAIRS_BLOCK = new BddBlockstateTemplates(){

        @Override
        public JsonObject generateBlockstate(String modId, String blockName, Map<String, String> properties) {
            JsonObject blockstate = new JsonObject();
            JsonObject variants = new JsonObject();
            String[] facings = new String[]{"east", "north", "south", "west"};
            String[] halves = new String[]{"bottom", "top"};
            String[] shapes = new String[]{"inner_left", "inner_right", "outer_left", "outer_right", "straight"};
            int[][] bottomRotations = new int[][]{{0, 270, 90, 180}, {270, 0, 180, 90}};
            int[][] topRotations = new int[][]{{0, 270, 90, 180}, {90, 0, 180, 270}};
            for (String facing : facings) {
                for (String half : halves) {
                    for (String shape : shapes) {
                        boolean uvlock;
                        String variantKey = String.format("facing=%s,half=%s,shape=%s", facing, half, shape);
                        JsonObject variant = new JsonObject();
                        String modelSuffix = shape.startsWith("inner") ? "_inner" : (shape.startsWith("outer") ? "_outer" : "");
                        variant.addProperty("model", modId + ":block/" + blockName + modelSuffix);
                        int facingIndex = Arrays.asList(facings).indexOf(facing);
                        int yRotation = 0;
                        boolean bl = uvlock = !shape.equals("straight");
                        if (half.equals("bottom")) {
                            if (shape.equals("inner_left") || shape.equals("outer_left")) {
                                yRotation = bottomRotations[0][facingIndex];
                            } else if (shape.equals("inner_right") || shape.equals("outer_right")) {
                                yRotation = bottomRotations[1][facingIndex];
                            } else if (shape.equals("straight")) {
                                yRotation = bottomRotations[1][facingIndex];
                            }
                        } else {
                            variant.addProperty("x", (Number)180);
                            if (shape.equals("inner_left") || shape.equals("outer_left")) {
                                yRotation = topRotations[0][facingIndex];
                            } else if (shape.equals("inner_right") || shape.equals("outer_right")) {
                                yRotation = topRotations[1][facingIndex];
                            } else if (shape.equals("straight")) {
                                yRotation = topRotations[1][facingIndex];
                            }
                        }
                        if (yRotation != 0) {
                            variant.addProperty("y", (Number)yRotation);
                        }
                        if (uvlock) {
                            variant.addProperty("uvlock", Boolean.valueOf(true));
                        }
                        variants.add(variantKey, (JsonElement)variant);
                    }
                }
            }
            blockstate.add("variants", (JsonElement)variants);
            return blockstate;
        }
    };
    public static final BddBlockstateTemplates PRESSURE_PLATE_BLOCK = new BddBlockstateTemplates(){

        @Override
        public JsonObject generateBlockstate(String modId, String blockName, Map<String, String> properties) {
            JsonObject blockstate = new JsonObject();
            JsonObject variants = new JsonObject();
            JsonObject unpoweredVariant = new JsonObject();
            unpoweredVariant.addProperty("model", modId + ":block/" + blockName);
            variants.add("powered=false", (JsonElement)unpoweredVariant);
            JsonObject poweredVariant = new JsonObject();
            poweredVariant.addProperty("model", modId + ":block/" + blockName + "_down");
            variants.add("powered=true", (JsonElement)poweredVariant);
            blockstate.add("variants", (JsonElement)variants);
            return blockstate;
        }
    };
    public static final BddBlockstateTemplates FENCE_GATE_BLOCK = new BddBlockstateTemplates(){

        @Override
        public JsonObject generateBlockstate(String modId, String blockName, Map<String, String> properties) {
            JsonObject blockstate = new JsonObject();
            JsonObject variants = new JsonObject();
            String[] facings = new String[]{"east", "north", "south", "west"};
            String[] inWalls = new String[]{"false", "true"};
            String[] opens = new String[]{"false", "true"};
            int[] yRotations = new int[]{270, 180, 0, 90};
            for (int f = 0; f < facings.length; ++f) {
                String facing = facings[f];
                for (String inWall : inWalls) {
                    for (String open : opens) {
                        String variantKey = String.format("facing=%s,in_wall=%s,open=%s", facing, inWall, open);
                        JsonObject variant = new JsonObject();
                        Object modelSuffix = inWall.equals("true") ? "_wall" : "";
                        modelSuffix = (String)modelSuffix + (open.equals("true") ? "_open" : "");
                        String model = modId + ":block/" + blockName + (String)modelSuffix;
                        variant.addProperty("model", model);
                        variant.addProperty("uvlock", Boolean.valueOf(true));
                        if (yRotations[f] != 0) {
                            variant.addProperty("y", (Number)yRotations[f]);
                        }
                        variants.add(variantKey, (JsonElement)variant);
                    }
                }
            }
            blockstate.add("variants", (JsonElement)variants);
            return blockstate;
        }
    };

    public abstract JsonObject generateBlockstate(String var1, String var2, Map<String, String> var3);
}

