/*
 * Decompiled with CFR 0.152.
 */
package com.bdc.bdd.util;

import com.bdc.bdd.api.entity.core_classes.BddAbilityDragon;
import com.bdc.bdd.api.util.DragonAbilities;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_241;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;

public class BddGuiUtils {
    public static void renderTranslucentBox(class_332 guiGraphics, int x, int y, int width, int height, int color) {
        guiGraphics.method_25294(x, y, x + width, y + height, color);
    }

    public static void renderProgressBar(class_332 guiGraphics, int x, int y, int width, int height, float progress, int emptyColor, int filledColor) {
        int filledWidth = (int)((float)width * progress);
        guiGraphics.method_25294(x, y, x + width, y + height, emptyColor);
        guiGraphics.method_25294(x, y + 1, x + filledWidth, y + height - 1, filledColor);
    }

    public static void renderProgressBarHoriz(class_332 guiGraphics, int x, int y, int width, int height, float progress, int emptyColor, int filledColor) {
        int filledHeight = (int)((float)height * progress);
        guiGraphics.method_25294(x, y, x + width, y - height, emptyColor);
        guiGraphics.method_25294(x, y, x + width, y - filledHeight + 1, filledColor);
    }

    public static void renderItemIcon(class_332 guiGraphics, int x, int y, class_1792 item) {
        guiGraphics.method_51427(new class_1799((class_1935)item), x, y);
    }

    public static void renderBar(class_332 guiGraphics, class_2960 sprite, class_2960 backSprite, int X, int Y, float value, float maxValue, int xOffset, int yOffset) {
        int screenWidth = guiGraphics.method_51421();
        int screenHeight = guiGraphics.method_51443();
        class_241 dimensions = new class_241((float)X, (float)Y);
        int imageWidth = (int)((double)dimensions.field_1343 * 1.5);
        int imageHeight = (int)((double)dimensions.field_1342 * 1.5);
        int x = (screenWidth - imageWidth) / 2 + xOffset;
        int y = screenHeight - yOffset;
        guiGraphics.method_25290(backSprite, x, y, 0.0f, 0.0f, imageWidth, imageHeight, imageWidth, imageHeight);
        float barWidth = value / maxValue;
        int visibleWidth = (int)((float)imageWidth * barWidth);
        int fillX = x + (imageWidth - visibleWidth);
        guiGraphics.method_25290(sprite, fillX, y, (float)(imageWidth - visibleWidth), 0.0f, visibleWidth, imageHeight, imageWidth, imageHeight);
    }

    public static void renderAbilityBar(class_332 guiGraphics, DragonAbilities ability, int xOffset, int yOffset, String keybind) {
        int screenWidth = guiGraphics.method_51421();
        int screenHeight = guiGraphics.method_51443();
        class_241 dimensions = new class_241(26.0f, 26.0f);
        int imageWidth = (int)dimensions.field_1343;
        int imageHeight = (int)dimensions.field_1342;
        int x = (screenWidth - imageWidth) / 2 + xOffset;
        int y = screenHeight - yOffset;
        guiGraphics.method_25290(ability.getSprite(), x, y, 0.0f, 0.0f, imageWidth, imageHeight, imageWidth, imageHeight);
        int textX = x + imageWidth / 2 - 2;
        int textY = y + imageHeight / 2 - 22;
        guiGraphics.method_51433(class_310.method_1551().field_1772, ability.getKeybind(), textX, textY, 0xFFFFFF, true);
    }

    public static int renderAbilityIfHas(class_332 guiGraphics, BddAbilityDragon dragon, DragonAbilities ability, int pos, int yPos, boolean isPositive) {
        if (dragon.hasAbility(ability)) {
            BddGuiUtils.renderAbilityBar(guiGraphics, ability, pos, yPos, ability.getKeybind());
            return isPositive ? pos + 28 : pos - 28;
        }
        return pos;
    }

    public static int renderProjBarIfHas(class_332 guiGraphics, class_2960 sprite, class_2960 backSprite, BddAbilityDragon dragon, DragonAbilities ability, String maxShots, float value, float maxValue, int pos, int yPos, boolean isPositive) {
        if (dragon.hasAbility(ability)) {
            BddGuiUtils.renderAbilityBarWithKeybind(guiGraphics, sprite, backSprite, value, maxValue, pos, yPos, ability.getKeybind() + maxShots, true);
            return isPositive ? pos + 28 : pos - 28;
        }
        return pos;
    }

    public static int renderBreathBarIfHas(class_332 guiGraphics, class_2960 sprite, class_2960 backSprite, BddAbilityDragon dragon, DragonAbilities ability, float value, float maxValue, int pos, int yPos, boolean isPositive) {
        if (dragon.hasAbility(ability)) {
            BddGuiUtils.renderAbilityBarWithKeybind(guiGraphics, sprite, backSprite, value, maxValue, pos, yPos, ability.getKeybind(), false);
            return isPositive ? pos + 28 : pos - 28;
        }
        return pos;
    }

    public static void renderAbilityBarWithKeybind(class_332 guiGraphics, class_2960 sprite, class_2960 backSprite, float value, float maxValue, int xOffset, int yOffset, String keybind, boolean fillBottomToTop) {
        int screenWidth = guiGraphics.method_51421();
        int screenHeight = guiGraphics.method_51443();
        int imageWidth = 26;
        int imageHeight = 26;
        int x = (screenWidth - imageWidth) / 2 + xOffset;
        int y = screenHeight - yOffset;
        guiGraphics.method_25290(backSprite, x, y, 0.0f, 0.0f, imageWidth, imageHeight, imageWidth, imageHeight);
        float barHeight = value / maxValue;
        int visibleHeight = (int)((float)imageHeight * barHeight);
        if (fillBottomToTop) {
            int fillY = y + (imageHeight - visibleHeight);
            guiGraphics.method_25290(sprite, x, fillY, 0.0f, (float)(imageHeight - visibleHeight), imageWidth, visibleHeight, imageWidth, imageHeight);
        } else {
            guiGraphics.method_25290(sprite, x, y, 0.0f, 0.0f, imageWidth, visibleHeight, imageWidth, imageHeight);
        }
        int textX = x + imageWidth / 2 - class_310.method_1551().field_1772.method_1727(keybind) / 2;
        int textY = y - 10;
        guiGraphics.method_51433(class_310.method_1551().field_1772, keybind, textX, textY, 0xFFFFFF, true);
    }
}

