/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;
import software.bluelib.BlueLibCommon;
import software.bluelib.FabricEvents;
import software.bluelib.event.FabricReloadHandler;
import software.bluelib.example.event.VariantProvider;
import software.bluelib.net.FabricNetworkManager;

public class BlueLib
implements ModInitializer {
    private boolean hasInitialized = false;

    public void onInitialize() {
        FabricEvents.register();
        BlueLibCommon.doRegistration();
        this.clientEndTick();
        this.registerNetwork();
        FabricReloadHandler.registerProvider(new VariantProvider());
    }

    private void registerNetwork() {
        FabricNetworkManager.registerMessages();
        FabricNetworkManager.registerServerHandlers();
    }

    @NotNull
    private Boolean isClientEnvironment() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    private void clientEndTick() {
        if (this.isClientEnvironment().booleanValue()) {
            BlueLibCommon.doClientRegistration();
            ClientTickEvents.END_CLIENT_TICK.register(client -> {
                FabricNetworkManager.registerClientHandlers();
                if (!this.hasInitialized) {
                    this.hasInitialized = true;
                    BlueLibCommon.init();
                }
            });
        }
    }
}

