/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;
import software.bluelib.config.BlueLibConfig;

public class ConfigBuilder<T extends BlueLibConfig> {
    @NotNull
    private final Path configPath;
    @NotNull
    private final Class<T> configClass;
    @NotNull
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    @NotNull
    private T config;

    public ConfigBuilder(@NotNull Path pConfigPath, @NotNull Class<T> pConfigClass, @NotNull T pDefaultConfig) {
        this.configPath = pConfigPath;
        this.configClass = pConfigClass;
        this.config = pDefaultConfig;
    }

    public void createIfAbsent(@NotNull T pDefaultConfig) {
        if (!Files.exists(this.configPath, new LinkOption[0])) {
            this.config = pDefaultConfig;
            this.save();
        }
    }

    public void load() {
        try {
            if (!Files.exists(this.configPath, new LinkOption[0])) {
                throw new RuntimeException("Config file does not exist: " + String.valueOf(this.configPath));
            }
            String json = Files.readString(this.configPath);
            BlueLibConfig loadedConfig = (BlueLibConfig)this.gson.fromJson(json, this.configClass);
            for (Field field : this.configClass.getDeclaredFields()) {
                field.setAccessible(true);
                Object loadedValue = field.get(loadedConfig);
                if (loadedValue == null) continue;
                field.set(this.config, loadedValue);
            }
        }
        catch (IOException | IllegalAccessException pException) {
            throw new RuntimeException("Failed to load config", pException);
        }
    }

    public void save() {
        try {
            Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
            String json = this.gson.toJson(this.config);
            Files.writeString(this.configPath, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException pIoException) {
            throw new RuntimeException("Failed to save config", pIoException);
        }
    }

    @NotNull
    public T getConfig() {
        return this.config;
    }
}

