/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.event.mod;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.BlueLibConstants;
import software.bluelib.api.event.mod.ExcludedMods;
import software.bluelib.api.event.mod.ModMeta;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.internal.BlueTranslation;

public class ModIntegration {
    @NotNull
    private static final List<ModMeta> loadedModMetas = new ArrayList<ModMeta>();
    @NotNull
    private static ExcludedMods excludedModsProvider = new ExcludedMods();

    public static void setExcludedModsProvider(@NotNull ExcludedMods pProvider) {
        excludedModsProvider = pProvider;
    }

    public static void checkSupportMods() {
        Set<String> excludedMods = excludedModsProvider.getExcludedMods();
        Set loadedMods = BlueLibConstants.PlatformHelper.PLATFORM.getLoadedMods().stream().filter(mod -> !excludedMods.contains(mod)).collect(Collectors.toSet());
        if (!loadedMods.isEmpty()) {
            StringBuilder modsMessage = new StringBuilder();
            for (String mod2 : loadedMods) {
                ModMeta modMeta = ModIntegration.getModMeta(mod2);
                if (modMeta != null) {
                    loadedModMetas.add(modMeta);
                    BlueLibConstants.PlatformHelper.EVENT_PROXY.onModLoaded(modMeta);
                }
                modsMessage.append(mod2).append("\n");
            }
            BlueLibConstants.PlatformHelper.EVENT_PROXY.onAllModsLoaded(loadedModMetas);
            BaseLogger.log((Boolean)true, BaseLogLevel.INFO, BlueTranslation.translate("mod.loaded", class_2561.method_43470((String)modsMessage.toString())));
        } else {
            BlueLibConstants.PlatformHelper.EVENT_PROXY.onAllModsLoaded(loadedModMetas);
            BaseLogger.log((Boolean)true, BaseLogLevel.INFO, BlueTranslation.translate("mod.loaded.empty"));
        }
    }

    @Nullable
    public static ModMeta getModMeta(@NotNull String pModId) {
        return BlueLibConstants.PlatformHelper.PLATFORM.getLoadedModMetadata().stream().filter(modMeta -> modMeta.modId().equals(pModId)).findFirst().orElse(null);
    }

    @NotNull
    public static List<ModMeta> getLoadedModMetas() {
        return loadedModMetas;
    }
}

