/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.net;

import java.util.function.Predicate;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import software.bluelib.BlueLibConstants;
import software.bluelib.api.net.Encodable;
import software.bluelib.api.net.NetworkRegistry;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.internal.BlueTranslation;

public interface NetworkPacket<T extends NetworkPacket<T>>
extends class_8710,
Encodable {
    @NotNull
    public class_2960 getId();

    default public void sendToPlayer(@NotNull class_3222 pPlayer) {
        NetworkRegistry.sendPacketToPlayer(pPlayer, this);
    }

    default public void sendToPlayers(@NotNull Iterable<class_3222> pPlayers) {
        if (pPlayers.iterator().hasNext()) {
            NetworkRegistry.sendPacketToPlayers(pPlayers, this);
        }
    }

    default public void sendToAllPlayers() {
        NetworkRegistry.sendToAllPlayers(this);
    }

    default public void sendToServer() {
        NetworkRegistry.sendToServer(this);
    }

    default public void sendToPlayersAround(@NotNull Double pX, @NotNull Double pY, @NotNull Double pZ, @NotNull Double pDistance, @NotNull class_5321<class_1937> pWorldKey, @NotNull Predicate<class_3222> pExclusionCondition) {
        MinecraftServer server = BlueLibConstants.PlatformHelper.PLATFORM.getServer();
        if (server == null) {
            BaseLogger.log((Boolean)true, BaseLogLevel.ERROR, BlueTranslation.translate("server.null"));
            return;
        }
        for (class_3222 player : server.method_3760().method_14571()) {
            double zDiff;
            double yDiff;
            double xDiff;
            if (pExclusionCondition.test(player) || !player.method_37908().method_27983().equals(pWorldKey) || !((xDiff = pX - player.method_23317()) * xDiff + (yDiff = pY - player.method_23318()) * yDiff + (zDiff = pZ - player.method_23321()) * zDiff < pDistance * pDistance)) continue;
            NetworkRegistry.sendPacketToPlayer(player, this);
        }
    }

    default public void sendToPlayersAround(@NotNull Double pX, @NotNull Double pY, @NotNull Double pZ, @NotNull Double pDistance, @NotNull class_5321<class_1937> pWorldKey) {
        this.sendToPlayersAround(pX, pY, pZ, pDistance, pWorldKey, player -> false);
    }

    @NotNull
    default public class_8710.class_9154<T> method_56479() {
        return new class_8710.class_9154(this.getId());
    }
}

