/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.utils.loader;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.animation.math.Easing;
import software.bluelib.loader.cache.animations.AnimationCache;
import software.bluelib.loader.geckolib.constant.DataTickets;
import software.bluelib.loader.geckolib.constant.dataticket.SerializableDataTicket;

public final class LoaderUtils {
    @NotNull
    private static final Int2ObjectMap<String> ANIMATABLE_IDENTITIES = new Int2ObjectOpenHashMap();
    @NotNull
    public static final Map<String, BlueAnimatable> SYNCED_ANIMATABLES = new Object2ObjectOpenHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <F> void addCustomFactory(@NotNull String pNamespace, @NotNull F pFactory, @NotNull BiConsumer<String, F> pRegisterFunction) {
        Class<LoaderUtils> clazz = LoaderUtils.class;
        synchronized (LoaderUtils.class) {
            pRegisterFunction.accept(pNamespace, pFactory);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @NotNull
    public static synchronized AnimationCache.LoopType addCustomLoopType(@NotNull String pName, @NotNull AnimationCache.LoopType pLoopType) {
        return AnimationCache.LoopType.register(pName, pLoopType);
    }

    @NotNull
    public static synchronized Easing addCustomEasingType(@NotNull String pName, @NotNull Easing pEasing) {
        return Easing.register(pName, pEasing);
    }

    @NotNull
    public static synchronized <D> SerializableDataTicket<D> addDataTicket(@NotNull SerializableDataTicket<D> pDataTicket) {
        return DataTickets.registerSerializable(pDataTicket);
    }

    public static synchronized void registerSyncedAnimatable(@NotNull BlueAnimatable pAnimatable) {
        BlueAnimatable existing = SYNCED_ANIMATABLES.put(LoaderUtils.getSyncedSingletonAnimatableId(pAnimatable), pAnimatable);
    }

    @Nullable
    public static BlueAnimatable getSyncedAnimatable(@NotNull String pSyncedAnimatableId) {
        return SYNCED_ANIMATABLES.get(pSyncedAnimatableId);
    }

    @NotNull
    public static String getSyncedSingletonAnimatableId(@NotNull BlueAnimatable pAnimatable) {
        return (String)ANIMATABLE_IDENTITIES.computeIfAbsent(System.identityHashCode(pAnimatable), i -> {
            String baseId = pAnimatable.getClass().getName();
            i = 0;
            while (SYNCED_ANIMATABLES.containsKey(baseId + i)) {
                ++i;
            }
            return baseId + i;
        });
    }

    @NotNull
    public static class_2960 stripSuffix(@NotNull String pSuffix, @NotNull class_2960 pLocation) {
        String path = pLocation.method_12832();
        if (path.endsWith(pSuffix)) {
            String newPath = path.substring(0, path.length() - pSuffix.length());
            return pLocation.method_45136(newPath);
        }
        throw new RuntimeException("Invalid file type: expected a " + pSuffix + " file, got: " + path);
    }
}

