/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.api.utils.logging;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.logging.ConsoleHandler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.utils.logging.ILogColorProvider;
import software.bluelib.api.utils.logging.LogCache;

public abstract class LoggerConfig {
    @NotNull
    protected static final String RESET = "\u001b[0m";

    public static void configureLogger(@NotNull Logger pLogger, final @NotNull ILogColorProvider pColorProvider) {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new SimpleFormatter(){

            @Override
            @NotNull
            public synchronized String format(@NotNull LogRecord pRecord) {
                String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("HH:mm:ss"));
                int color = pColorProvider.getColor(pRecord.getLevel());
                String ansiColor = LoggerConfig.rgbToAnsi(color);
                StringBuilder coloredMessage = new StringBuilder(ansiColor + "[" + timestamp + "] [" + String.valueOf(pRecord.getLevel()) + "]: " + pRecord.getMessage() + LoggerConfig.RESET);
                String plainMessage = "[" + timestamp + "] [" + String.valueOf(pRecord.getLevel()) + "]: " + pRecord.getMessage();
                if (pRecord.getThrown() != null) {
                    String exceptionDetails = 1.getExceptionDetails(pRecord);
                    coloredMessage.append(exceptionDetails);
                    plainMessage = plainMessage + exceptionDetails;
                }
                LogCache.addLog(plainMessage, color);
                return String.valueOf(coloredMessage) + "\n";
            }

            @NotNull
            private static String getExceptionDetails(@NotNull LogRecord pRecord) {
                StringBuilder exceptionDetails = new StringBuilder("\nException: " + pRecord.getThrown().getMessage());
                for (StackTraceElement element : pRecord.getThrown().getStackTrace()) {
                    String packageName = element.getClassName().substring(0, element.getClassName().lastIndexOf(46));
                    String className = element.getClassName().substring(element.getClassName().lastIndexOf(46) + 1);
                    String methodName = element.getMethodName();
                    int lineNumber = element.getLineNumber();
                    exceptionDetails.append("\n\tat ").append(packageName).append(".").append(className).append(".").append(methodName).append("(Line: ").append(lineNumber).append(")");
                }
                return exceptionDetails.toString();
            }
        });
        pLogger.setUseParentHandlers(false);
        pLogger.addHandler(handler);
    }

    @NotNull
    private static String rgbToAnsi(@NotNull Integer pRgb) {
        int red = pRgb >> 16 & 0xFF;
        int green = pRgb >> 8 & 0xFF;
        int blue = pRgb & 0xFF;
        return String.format("\u001b[38;2;%d;%d;%dm", red, green, blue);
    }
}

