/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.client.gui.logging;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.utils.logging.LogCache;
import software.bluelib.internal.BlueTranslation;

public class LoggerScreen
extends class_437 {
    private int scrollOffset = 0;
    private static final int LINE_HEIGHT = 10;
    private boolean isDragging = false;
    private int dragStartY = 0;
    private int initialScrollOffset = 0;

    public LoggerScreen() {
        super(BlueTranslation.translate("ui.logger.title"));
    }

    protected void method_25426() {
        super.method_25426();
        this.scrollOffset = 0;
    }

    public void method_25394(@NotNull class_332 pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        int boxWidth = (int)((double)this.field_22789 * 0.9);
        int boxHeight = (int)((double)this.field_22790 * 0.9);
        int boxX = (this.field_22789 - boxWidth) / 2;
        int boxY = (this.field_22790 - boxHeight) / 2;
        pGuiGraphics.method_25294(boxX - 2, boxY - 22, boxX + boxWidth + 2, boxY + boxHeight + 2, -587202560);
        pGuiGraphics.method_25294(boxX, boxY - 20, boxX + boxWidth, boxY, -12303292);
        pGuiGraphics.method_27534(this.field_22793, this.field_22785, boxX + boxWidth / 2, boxY - 15, 0xFFFFFF);
        List<LogCache.LogEntry> logEntries = LogCache.getLogs();
        ArrayList<RenderedLine> renderedLines = new ArrayList<RenderedLine>();
        for (LogCache.LogEntry entry : logEntries) {
            List<String> wrapped = this.wrapText(entry.message(), boxWidth - 15);
            for (String string : wrapped) {
                renderedLines.add(new RenderedLine(string, entry.color()));
            }
        }
        int maxVisibleLines = (boxHeight - 10) / 10;
        int maxOffset = Math.max(0, renderedLines.size() - maxVisibleLines);
        this.scrollOffset = Math.min(this.scrollOffset, maxOffset);
        int y = boxY + 5;
        for (int i = this.scrollOffset; i < renderedLines.size() && y < boxY + boxHeight - 10; y += 10, ++i) {
            RenderedLine renderedLine = (RenderedLine)renderedLines.get(i);
            pGuiGraphics.method_25303(this.field_22793, renderedLine.text(), boxX + 7, y, renderedLine.color().intValue());
        }
        if (renderedLines.size() > maxVisibleLines) {
            int scrollbarHeight = (int)((float)maxVisibleLines / (float)renderedLines.size() * (float)(boxHeight - 10));
            int n = boxY + 5 + (int)((float)this.scrollOffset / (float)renderedLines.size() * (float)(boxHeight - 10));
            pGuiGraphics.method_25294(boxX + boxWidth - 6, n, boxX + boxWidth - 3, n + scrollbarHeight, -7829368);
        }
    }

    @NotNull
    private List<String> wrapText(@NotNull String pText, @NotNull Integer pMaxWidth) {
        String[] segments;
        ArrayList<String> lines = new ArrayList<String>();
        for (String segment : segments = pText.split("\n")) {
            String[] words = segment.split(" ");
            StringBuilder currentLine = new StringBuilder();
            for (String word : words) {
                int wordWidth = this.field_22793.method_1727(word);
                if (wordWidth > pMaxWidth) {
                    while (!word.isEmpty()) {
                        int splitIndex = this.getSplitIndex(word, pMaxWidth);
                        lines.add(word.substring(0, splitIndex));
                        word = word.substring(splitIndex);
                    }
                    continue;
                }
                int lineWidth = this.field_22793.method_1727(String.valueOf(currentLine) + word + " ");
                if (lineWidth > pMaxWidth) {
                    lines.add(currentLine.toString().trim());
                    currentLine = new StringBuilder(word + " ");
                    continue;
                }
                currentLine.append(word).append(" ");
            }
            if (currentLine.isEmpty()) continue;
            lines.add(currentLine.toString().trim());
        }
        return lines;
    }

    @NotNull
    private Integer getSplitIndex(@NotNull String pWord, @NotNull Integer pMaxWidth) {
        for (int i = 1; i <= pWord.length(); ++i) {
            if (this.field_22793.method_1727(pWord.substring(0, i)) <= pMaxWidth) continue;
            return i - 1;
        }
        return pWord.length();
    }

    public boolean method_25402(double pMouseX, double pMouseY, int pButton) {
        int boxWidth = (int)((double)this.field_22789 * 0.9);
        int boxHeight = (int)((double)this.field_22790 * 0.9);
        int boxX = (this.field_22789 - boxWidth) / 2;
        int boxY = (this.field_22790 - boxHeight) / 2;
        int maxVisibleLines = (boxHeight - 10) / 10;
        List<LogCache.LogEntry> logEntries = LogCache.getLogs();
        List<RenderedLine> renderedLines = logEntries.stream().map(entry -> new RenderedLine(entry.message(), entry.color())).toList();
        if (renderedLines.size() <= maxVisibleLines) {
            return super.method_25402(pMouseX, pMouseY, pButton);
        }
        int scrollbarXStart = boxX + boxWidth - 6;
        int scrollbarXEnd = boxX + boxWidth - 3;
        int scrollbarHeight = (int)((float)maxVisibleLines / (float)renderedLines.size() * (float)(boxHeight - 10));
        int scrollbarYStart = boxY + 5 + (int)((float)this.scrollOffset / (float)renderedLines.size() * (float)(boxHeight - 10));
        int scrollbarYEnd = scrollbarYStart + scrollbarHeight;
        if (!(pMouseX >= (double)scrollbarXStart && pMouseX <= (double)scrollbarXEnd && pMouseY >= (double)scrollbarYStart && pMouseY <= (double)scrollbarYEnd)) {
            return super.method_25402(pMouseX, pMouseY, pButton);
        }
        this.isDragging = true;
        this.dragStartY = (int)pMouseY;
        this.initialScrollOffset = this.scrollOffset;
        return true;
    }

    public boolean method_25406(double pMouseX, double pMouseY, int pButton) {
        this.isDragging = false;
        return super.method_25406(pMouseX, pMouseY, pButton);
    }

    public boolean method_25403(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (!this.isDragging) {
            return super.method_25403(pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        int boxHeight = (int)((double)this.field_22790 * 0.9);
        List<LogCache.LogEntry> logEntries = LogCache.getLogs();
        ArrayList<RenderedLine> renderedLines = new ArrayList<RenderedLine>();
        for (LogCache.LogEntry entry : logEntries) {
            renderedLines.add(new RenderedLine(entry.message(), entry.color()));
        }
        int maxVisibleLines = (boxHeight - 10) / 10;
        int maxOffset = Math.max(0, renderedLines.size() - maxVisibleLines);
        int deltaY = (int)pMouseY - this.dragStartY;
        int scrollableHeight = boxHeight - 10;
        this.scrollOffset = this.initialScrollOffset + (int)((float)deltaY / (float)scrollableHeight * (float)renderedLines.size());
        this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, maxOffset));
        return true;
    }

    public boolean method_25401(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (pScrollY > 0.0) {
            this.scrollOffset = Math.max(0, this.scrollOffset - 1);
        } else if (pScrollY < 0.0) {
            ++this.scrollOffset;
        }
        return true;
    }

    private record RenderedLine(@NotNull String text, @NotNull Integer color) {
    }
}

