/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.client.utils;

import it.unimi.dsi.fastutil.ints.IntIntImmutablePair;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.io.InputStream;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3673;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5151;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import net.minecraft.class_897;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import software.bluelib.BlueLibConstants;
import software.bluelib.api.utils.Color;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.client.utils.ResourceUtils;
import software.bluelib.client.utils.TextureUtils;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.cache.model.BoneCache;
import software.bluelib.loader.cache.model.CubeCache;
import software.bluelib.loader.model.BlueModel;
import software.bluelib.loader.renderer.base.BlueRenderer;
import software.bluelib.loader.renderer.client.BlueRenderProvider;
import software.bluelib.loader.renderer.entity.BlueReplacedEntityRenderer;

public final class RenderUtils {
    public static void translateMatrixToBone(@NotNull class_4587 pPoseStack, @NotNull BoneCache pBone) {
        pPoseStack.method_46416(-pBone.getPosX() / 16.0f, pBone.getPosY() / 16.0f, pBone.getPosZ() / 16.0f);
    }

    public static void rotateMatrixAroundBone(@NotNull class_4587 pPoseStack, @NotNull BoneCache pBone) {
        if (pBone.getRotZ() != 0.0f) {
            pPoseStack.method_22907(class_7833.field_40718.rotation(pBone.getRotZ()));
        }
        if (pBone.getRotY() != 0.0f) {
            pPoseStack.method_22907(class_7833.field_40716.rotation(pBone.getRotY()));
        }
        if (pBone.getRotX() != 0.0f) {
            pPoseStack.method_22907(class_7833.field_40714.rotation(pBone.getRotX()));
        }
    }

    public static void rotateMatrixAroundCube(@NotNull class_4587 pPoseStack, @NotNull CubeCache pCube) {
        class_243 rotation = pCube.rotation();
        pPoseStack.method_22907(new Quaternionf().rotationXYZ(0.0f, 0.0f, (float)rotation.method_10215()));
        pPoseStack.method_22907(new Quaternionf().rotationXYZ(0.0f, (float)rotation.method_10214(), 0.0f));
        pPoseStack.method_22907(new Quaternionf().rotationXYZ((float)rotation.method_10216(), 0.0f, 0.0f));
    }

    public static void scaleMatrixForBone(@NotNull class_4587 pPoseStack, @NotNull BoneCache pBone) {
        pPoseStack.method_22905(pBone.getScaleX().floatValue(), pBone.getScaleY().floatValue(), pBone.getScaleZ().floatValue());
    }

    public static void translateToPivotPoint(@NotNull class_4587 pPoseStack, @NotNull CubeCache pCube) {
        class_243 pivot = pCube.pivot();
        pPoseStack.method_22904(pivot.method_10216() / 16.0, pivot.method_10214() / 16.0, pivot.method_10215() / 16.0);
    }

    public static void translateToPivotPoint(@NotNull class_4587 pPoseStack, @NotNull BoneCache pBone) {
        pPoseStack.method_46416(pBone.getPivotX() / 16.0f, pBone.getPivotY() / 16.0f, pBone.getPivotZ() / 16.0f);
    }

    public static void translateAwayFromPivotPoint(@NotNull class_4587 pPoseStack, @NotNull CubeCache pCube) {
        class_243 pivot = pCube.pivot();
        pPoseStack.method_22904(-pivot.method_10216() / 16.0, -pivot.method_10214() / 16.0, -pivot.method_10215() / 16.0);
    }

    public static void translateAwayFromPivotPoint(@NotNull class_4587 pPoseStack, @NotNull BoneCache pBone) {
        pPoseStack.method_46416(-pBone.getPivotX() / 16.0f, -pBone.getPivotY() / 16.0f, -pBone.getPivotZ() / 16.0f);
    }

    public static void translateAndRotateMatrixForBone(@NotNull class_4587 pPoseStack, @NotNull BoneCache pBone) {
        RenderUtils.translateToPivotPoint(pPoseStack, pBone);
        RenderUtils.rotateMatrixAroundBone(pPoseStack, pBone);
    }

    public static void prepMatrixForBone(@NotNull class_4587 pPoseStack, @NotNull BoneCache pBone) {
        RenderUtils.translateMatrixToBone(pPoseStack, pBone);
        RenderUtils.translateToPivotPoint(pPoseStack, pBone);
        RenderUtils.rotateMatrixAroundBone(pPoseStack, pBone);
        RenderUtils.scaleMatrixForBone(pPoseStack, pBone);
        RenderUtils.translateAwayFromPivotPoint(pPoseStack, pBone);
    }

    public static Matrix4f invertAndMultiplyMatrices(@NotNull Matrix4f pBaseMatrix, @NotNull Matrix4f pInputMatrix) {
        pInputMatrix = new Matrix4f((Matrix4fc)pInputMatrix);
        pInputMatrix.invert();
        pInputMatrix.mul((Matrix4fc)pBaseMatrix);
        return pInputMatrix;
    }

    public static void faceRotation(@NotNull class_4587 pPoseStack, @NotNull class_1297 pAnimatable, @NotNull Float pPartialTick) {
        pPoseStack.method_22907(class_7833.field_40716.rotationDegrees(class_3532.method_16439((float)pPartialTick.floatValue(), (float)pAnimatable.field_5982, (float)pAnimatable.method_36454()) - 90.0f));
        pPoseStack.method_22907(class_7833.field_40718.rotationDegrees(class_3532.method_16439((float)pPartialTick.floatValue(), (float)pAnimatable.field_6004, (float)pAnimatable.method_36455())));
    }

    public static Matrix4f translateMatrix(@NotNull Matrix4f pMatrix, @NotNull Vector3f pVector) {
        return pMatrix.add((Matrix4fc)new Matrix4f().m30(pVector.x).m31(pVector.y).m32(pVector.z));
    }

    @Nullable
    public static IntIntPair getTextureDimensions(@NotNull class_2960 pTexture) {
        class_1044 originalTexture = null;
        try {
            originalTexture = (class_1044)class_310.method_1551().method_5385(() -> TextureUtils.getTexture(pTexture)).get();
        }
        catch (Exception pException) {
            BaseLogger.log(BaseLogLevel.ERROR, "Failed to get texture dimensions for: " + String.valueOf(pTexture), pException);
        }
        if (originalTexture == null) {
            return null;
        }
        class_1011 image = null;
        try {
            class_1011 class_10112;
            if (originalTexture instanceof class_1043) {
                class_1043 dynamicTexture = (class_1043)originalTexture;
                class_10112 = dynamicTexture.method_4525();
            } else {
                class_10112 = ResourceUtils.getResource(pTexture).map(resource -> {
                    try {
                        return class_1011.method_4309((InputStream)resource.method_14482());
                    }
                    catch (Exception e) {
                        BaseLogger.log(BaseLogLevel.ERROR, "Failed to read texture image for: " + String.valueOf(pTexture), e);
                        return null;
                    }
                }).orElse(null);
            }
            image = class_10112;
        }
        catch (Exception pException) {
            BaseLogger.log(BaseLogLevel.ERROR, "Failed to read texture image for: " + String.valueOf(pTexture), pException);
        }
        return image == null ? null : IntIntImmutablePair.of((int)image.method_4307(), (int)image.method_4323());
    }

    @NotNull
    public static Double getCurrentSystemTick() {
        return (double)System.nanoTime() / 1000000.0 / 50.0;
    }

    @NotNull
    public static Double getCurrentTick() {
        return class_3673.method_15974() * 20.0;
    }

    @NotNull
    public static Float booleanToFloat(boolean pInput) {
        return Float.valueOf(pInput ? 1.0f : 0.0f);
    }

    @NotNull
    public static class_243 listToVec(@NotNull List<Float> pArray) {
        if (pArray.size() < 3) {
            return new class_243(0.0, 0.0, 0.0);
        }
        return new class_243((double)pArray.get(0).floatValue(), (double)pArray.get(1).floatValue(), (double)pArray.get(2).floatValue());
    }

    public static void matchModelPartRot(@NotNull class_630 pModelPart, @NotNull BoneCache pBone) {
        pBone.updateRotation(-pModelPart.field_3654, -pModelPart.field_3675, pModelPart.field_3674);
    }

    public static void fixInvertedFlatCube(@NotNull CubeCache pCube, @NotNull Vector3f pNormal) {
        if (pNormal.x() < 0.0f && (pCube.size().method_10214() == 0.0 || pCube.size().method_10215() == 0.0)) {
            pNormal.mul(-1.0f, 1.0f, 1.0f);
        }
        if (pNormal.y() < 0.0f && (pCube.size().method_10216() == 0.0 || pCube.size().method_10215() == 0.0)) {
            pNormal.mul(1.0f, -1.0f, 1.0f);
        }
        if (pNormal.z() < 0.0f && (pCube.size().method_10216() == 0.0 || pCube.size().method_10214() == 0.0)) {
            pNormal.mul(1.0f, 1.0f, -1.0f);
        }
    }

    @NotNull
    public static Float getDirectionAngle(@NotNull class_2350 pDirection) {
        return switch (pDirection) {
            case class_2350.field_11035 -> Float.valueOf(90.0f);
            case class_2350.field_11043 -> Float.valueOf(270.0f);
            case class_2350.field_11034 -> Float.valueOf(180.0f);
            default -> Float.valueOf(0.0f);
        };
    }

    @NotNull
    public static Double lerpYaw(@NotNull Double pDelta, @NotNull Double pStart, @NotNull Double pEnd) {
        pStart = class_3532.method_15338((double)pStart);
        pEnd = class_3532.method_15338((double)pEnd);
        double diff = pStart - pEnd;
        pEnd = diff > 180.0 || diff < -180.0 ? pStart + Math.copySign(360.0 - Math.abs(diff), diff) : pEnd;
        return class_3532.method_16436((double)pDelta, (double)pStart, (double)pEnd);
    }

    @Nullable
    public static BlueModel<?> getBlueModelForEntityType(@NotNull class_1299<?> pEntityType) {
        BlueModel blueModel;
        class_897 renderer = (class_897)class_310.method_1551().method_1561().field_4696.get(pEntityType);
        if (renderer instanceof BlueRenderer) {
            BlueRenderer blueRenderer = (BlueRenderer)renderer;
            blueModel = blueRenderer.getBlueModel();
        } else {
            blueModel = null;
        }
        return blueModel;
    }

    @Nullable
    public static BlueAnimatable getReplacedAnimatable(@NotNull class_1299<?> pEntityType) {
        BlueAnimatable blueAnimatable;
        class_897 renderer = (class_897)class_310.method_1551().method_1561().field_4696.get(pEntityType);
        if (renderer instanceof BlueReplacedEntityRenderer) {
            BlueReplacedEntityRenderer replacedEntityRenderer = (BlueReplacedEntityRenderer)renderer;
            blueAnimatable = (BlueAnimatable)replacedEntityRenderer.getOptionalAnimatable();
        } else {
            blueAnimatable = null;
        }
        return blueAnimatable;
    }

    @Nullable
    public static BlueModel<?> getBlueModelForEntity(@NotNull class_1297 pEntity) {
        BlueModel blueModel;
        class_897 renderer = class_310.method_1551().method_1561().method_3953(pEntity);
        if (renderer instanceof BlueRenderer) {
            BlueRenderer blueRenderer = (BlueRenderer)renderer;
            blueModel = blueRenderer.getBlueModel();
        } else {
            blueModel = null;
        }
        return blueModel;
    }

    @Nullable
    public static BlueModel<?> getBlueModelForItem(@NotNull class_1799 pItem) {
        return BlueLibConstants.PlatformHelper.ITEM_RENDERING.getBlueModelForItem(pItem);
    }

    @Nullable
    public static BlueModel<?> getBlueModelForBlock(@NotNull class_2586 pBlockEntity) {
        BlueModel blueModel;
        class_827 renderer = class_310.method_1551().method_31975().method_3550(pBlockEntity);
        if (renderer instanceof BlueRenderer) {
            BlueRenderer blueRenderer = (BlueRenderer)renderer;
            blueModel = blueRenderer.getBlueModel();
        } else {
            blueModel = null;
        }
        return blueModel;
    }

    @Nullable
    public static BlueModel<?> getBlueModelForArmor(@NotNull class_1799 pStack) {
        return BlueLibConstants.PlatformHelper.ITEM_RENDERING.getBlueModelForArmor(pStack);
    }

    @NotNull
    public static <T extends class_1309, M extends class_572<T>, A extends class_572<T>> Boolean tryRenderArmorPiece(@NotNull class_4587 pPoseStack, @NotNull class_4597 pBufferSource, @NotNull T pEntity, @NotNull class_1799 pStack, @NotNull class_1304 pEquipmentSlot, @NotNull M pParentModel, @NotNull A pBaseModel, @NotNull Float pPartialTick, @NotNull Integer pPackedLight, @NotNull Float pLimbSwing, @NotNull Float pLimbSwingAmount, @NotNull Float pLerpedTickCount, @NotNull Float pNetHeadYaw, @NotNull Float pHeadPitch, @NotNull BiConsumer<A, class_1304> pPartVisibilitySetter) {
        class_5151 equipable;
        class_1792 item = pStack.method_7909();
        if (!(item instanceof class_5151) || (equipable = (class_5151)item).method_7685() != pEquipmentSlot) {
            return false;
        }
        class_572<?> model = BlueRenderProvider.of(item).getBlueArmorRenderer(pEntity, pStack, pEquipmentSlot, pBaseModel);
        if (model == null) {
            return false;
        }
        pParentModel.method_2818(pBaseModel);
        pPartVisibilitySetter.accept(pBaseModel, pEquipmentSlot);
        pBaseModel.method_2818(model);
        model.method_2828(pPoseStack, null, pPackedLight.intValue(), class_4608.field_21444, Color.WHITE.argbInt());
        return true;
    }
}

