/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.config;

import java.nio.file.Path;
import net.minecraft.class_5218;
import net.minecraft.class_6860;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.config.ConfigBuilder;
import software.bluelib.config.BlueLibConfig;
import software.bluelib.config.bluelib.LoggerConfig;
import software.bluelib.config.bluelib.MarkdownConfig;

public class ConfigLoader {
    @Nullable
    private static ConfigBuilder<MarkdownConfig> markdownConfigBuilder;
    @Nullable
    private static ConfigBuilder<LoggerConfig> loggerConfigBuilder;

    public static void createConfigs(@NotNull MinecraftServer pServer) {
        ConfigLoader.createMarkdownConfig(pServer);
        ConfigLoader.createLoggerConfig(pServer);
    }

    public static void createMarkdownConfig(@NotNull MinecraftServer pServer) {
        Path MARKDOWN_CONFIG = pServer.method_27050(class_5218.field_24188).resolve("serverConfig/bluelib-markdown.json");
        MarkdownConfig defaultMarkdownConfig = new MarkdownConfig();
        markdownConfigBuilder = new ConfigBuilder<MarkdownConfig>(MARKDOWN_CONFIG, MarkdownConfig.class, defaultMarkdownConfig);
        markdownConfigBuilder.createIfAbsent(defaultMarkdownConfig);
        markdownConfigBuilder.load();
        BlueLibConfig.bakeMarkdown(markdownConfigBuilder.getConfig());
    }

    public static void createLoggerConfig(@NotNull MinecraftServer pServer) {
        Path LOGGER_CONFIG = pServer.method_27050(class_5218.field_24188).resolve("serverConfig/bluelib-logger.json");
        LoggerConfig defaultLoggerConfig = new LoggerConfig();
        loggerConfigBuilder = new ConfigBuilder<LoggerConfig>(LOGGER_CONFIG, LoggerConfig.class, defaultLoggerConfig);
        loggerConfigBuilder.createIfAbsent(defaultLoggerConfig);
        loggerConfigBuilder.load();
        BlueLibConfig.bakeLogger(loggerConfigBuilder.getConfig());
    }

    public static void reloadConfigs(@NotNull MinecraftServer pServer, @NotNull class_6860 pCloseableResourceManager, @NotNull Boolean pBoolean) {
        if (markdownConfigBuilder == null || loggerConfigBuilder == null) {
            ConfigLoader.createConfigs(pServer);
            return;
        }
        markdownConfigBuilder.load();
        BlueLibConfig.bakeMarkdown(markdownConfigBuilder.getConfig());
        BlueLibConfig.bakeLogger(loggerConfigBuilder.getConfig());
    }
}

