/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.animatable.base;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.loader.animatable.base.AnimatableManager;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.animation.AnimationController;
import software.bluelib.loader.animation.bone.BoneSnapshot;
import software.bluelib.loader.geckolib.constant.dataticket.DataTicket;

public abstract class ContextAwareAnimatableManager<T extends BlueAnimatable, C>
extends AnimatableManager<T> {
    @NotNull
    private final Map<C, AnimatableManager<T>> managers;

    public ContextAwareAnimatableManager(@NotNull BlueAnimatable pAnimatable) {
        super(pAnimatable);
        this.managers = this.buildContextOptions(pAnimatable);
    }

    @NotNull
    protected abstract Map<C, AnimatableManager<T>> buildContextOptions(@NotNull BlueAnimatable var1);

    @NotNull
    public abstract C getCurrentContext();

    @NotNull
    public AnimatableManager<T> getManagerForContext(@NotNull C pContext) {
        return this.managers.get(pContext);
    }

    @Override
    public void addController(@NotNull AnimationController<T> pController) {
        this.getManagerForContext(this.getCurrentContext()).addController(pController);
    }

    @Override
    public void removeController(@NotNull String pName) {
        this.getManagerForContext(this.getCurrentContext()).removeController(pName);
    }

    @Override
    @NotNull
    public Map<String, AnimationController<T>> getAnimationControllers() {
        return this.getManagerForContext(this.getCurrentContext()).getAnimationControllers();
    }

    @Override
    @NotNull
    public Map<String, BoneSnapshot> getBoneSnapshotCollection() {
        return this.getManagerForContext(this.getCurrentContext()).getBoneSnapshotCollection();
    }

    @Override
    public void clearSnapshotCache() {
        this.getManagerForContext(this.getCurrentContext()).clearSnapshotCache();
    }

    @Override
    @NotNull
    public Double getLastUpdateTime() {
        return this.getManagerForContext(this.getCurrentContext()).getLastUpdateTime();
    }

    @Override
    public void updatedAt(@NotNull Double pUpdateTime) {
        this.getManagerForContext(this.getCurrentContext()).updatedAt(pUpdateTime);
    }

    @Override
    @NotNull
    public Double getFirstTickTime() {
        return this.getManagerForContext(this.getCurrentContext()).getFirstTickTime();
    }

    @Override
    public void startedAt(@NotNull Double pTime) {
        this.getManagerForContext(this.getCurrentContext()).startedAt(pTime);
    }

    @Override
    public boolean isFirstTick() {
        return this.getManagerForContext(this.getCurrentContext()).isFirstTick();
    }

    @Override
    public void finishFirstTick() {
        this.getManagerForContext(this.getCurrentContext()).finishFirstTick();
    }

    @Override
    public void tryTriggerAnimation(@NotNull String pAnimName) {
        for (AnimatableManager<T> manager : this.managers.values()) {
            manager.tryTriggerAnimation(pAnimName);
        }
    }

    @Override
    public void tryTriggerAnimation(@NotNull String pControllerName, @NotNull String pAnimName) {
        for (AnimatableManager<T> manager : this.managers.values()) {
            manager.tryTriggerAnimation(pControllerName, pAnimName);
        }
    }

    @Override
    public void stopTriggeredAnimation(@Nullable String pAnimName) {
        for (AnimatableManager<T> manager : this.managers.values()) {
            manager.stopTriggeredAnimation(pAnimName);
        }
    }

    @Override
    public void stopTriggeredAnimation(@Nullable String pControllerName, @Nullable String pAnimName) {
        for (AnimatableManager<T> manager : this.managers.values()) {
            manager.stopTriggeredAnimation(pControllerName, pAnimName);
        }
    }

    @Override
    public <D> void setData(@NotNull DataTicket<D> pDataTicket, @NotNull D pData) {
        super.setData(pDataTicket, pData);
    }

    @Override
    @Nullable
    public <D> D getData(@NotNull DataTicket<D> pDataTicket) {
        return super.getData(pDataTicket);
    }
}

