/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.animation;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.loader.cache.animations.AnimationCache;

public final class Animation {
    @NotNull
    private final List<Stage> animationList = new ObjectArrayList();

    private Animation() {
    }

    @NotNull
    public static Animation begin() {
        return new Animation();
    }

    @NotNull
    public Animation thenPlay(@NotNull String pAnimationName) {
        return this.then(pAnimationName, AnimationCache.LoopType.DEFAULT);
    }

    @NotNull
    public Animation thenLoop(@NotNull String pAnimationName) {
        return this.then(pAnimationName, AnimationCache.LoopType.LOOP);
    }

    @NotNull
    public Animation thenWait(int pTicks) {
        this.animationList.add(new Stage("internal.wait", AnimationCache.LoopType.PLAY_ONCE, pTicks));
        return this;
    }

    @NotNull
    public Animation thenPlayAndHold(@NotNull String pAnimation) {
        return this.then(pAnimation, AnimationCache.LoopType.HOLD_ON_LAST_FRAME);
    }

    @NotNull
    public Animation thenPlayXTimes(@NotNull String pAnimationName, int pPlayCount) {
        for (int i = 0; i < pPlayCount; ++i) {
            this.then(pAnimationName, i == pPlayCount - 1 ? AnimationCache.LoopType.DEFAULT : AnimationCache.LoopType.PLAY_ONCE);
        }
        return this;
    }

    @NotNull
    public Animation then(@NotNull String pAnimationName, @NotNull AnimationCache.LoopType pLoopType) {
        this.animationList.add(new Stage(pAnimationName, pLoopType));
        return this;
    }

    @NotNull
    public List<Stage> getAnimationStages() {
        return this.animationList;
    }

    @NotNull
    public static Animation copyOf(@NotNull Animation pOther) {
        Animation newInstance = Animation.begin();
        newInstance.animationList.addAll(pOther.animationList);
        return newInstance;
    }

    public boolean equals(@Nullable Object pObj) {
        if (this == pObj) {
            return true;
        }
        if (pObj == null || this.getClass() != pObj.getClass()) {
            return false;
        }
        return this.hashCode() == pObj.hashCode();
    }

    public int hashCode() {
        return Objects.hash(this.animationList);
    }

    public record Stage(@NotNull String animationName, @NotNull AnimationCache.LoopType loopType, int additionalTicks) {
        @NotNull
        public static final String WAIT = "internal.wait";

        public Stage(@NotNull String pAnimationName, @NotNull AnimationCache.LoopType pLoopType) {
            this(pAnimationName, pLoopType, 0);
        }

        @Override
        public boolean equals(@Nullable Object pObj) {
            if (this == pObj) {
                return true;
            }
            if (pObj == null || this.getClass() != pObj.getClass()) {
                return false;
            }
            return this.hashCode() == pObj.hashCode();
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.animationName, this.loopType);
        }
    }
}

