/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.animation;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_2350;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.animation.Animation;
import software.bluelib.loader.animation.AnimationProcessor;
import software.bluelib.loader.animation.AnimationState;
import software.bluelib.loader.animation.bone.BoneSnapshot;
import software.bluelib.loader.animation.keyframe.AnimationPoint;
import software.bluelib.loader.animation.keyframe.BoneAnimationFrame;
import software.bluelib.loader.animation.keyframe.KeyframeLocation;
import software.bluelib.loader.animation.keyframe.data.CustomInstructionKeyframeData;
import software.bluelib.loader.animation.keyframe.data.KeyFrameData;
import software.bluelib.loader.animation.keyframe.data.ParticleKeyframeData;
import software.bluelib.loader.animation.keyframe.data.SoundKeyframeData;
import software.bluelib.loader.animation.keyframe.event.CustomInstructionKeyframeEvent;
import software.bluelib.loader.animation.keyframe.event.ParticleKeyframeEvent;
import software.bluelib.loader.animation.keyframe.event.SoundKeyframeEvent;
import software.bluelib.loader.animation.math.Easing;
import software.bluelib.loader.animation.state.PlayState;
import software.bluelib.loader.cache.animations.keyframe.BoneAnimationCache;
import software.bluelib.loader.cache.animations.keyframe.KeyframeCache;
import software.bluelib.loader.cache.animations.keyframe.KeyframeStackCache;
import software.bluelib.loader.cache.model.BoneCache;
import software.bluelib.loader.geckolib.math.MathParser;
import software.bluelib.loader.geckolib.math.MathValue;
import software.bluelib.loader.geckolib.math.value.Constant;
import software.bluelib.loader.model.BlueModel;

public class AnimationController<T extends BlueAnimatable> {
    @NotNull
    protected final T animatable;
    @NotNull
    protected final String name;
    @NotNull
    protected final AnimationStateHandler<T> stateHandler;
    @NotNull
    protected final Map<String, BoneAnimationFrame> boneAnimationQueues = new Object2ObjectOpenHashMap();
    @NotNull
    protected final Map<String, BoneSnapshot> boneSnapshots = new Object2ObjectOpenHashMap();
    @NotNull
    protected Queue<AnimationProcessor.QueuedAnimation> animationQueue = new LinkedList<AnimationProcessor.QueuedAnimation>();
    protected boolean isJustStarting = false;
    protected boolean needsAnimationReload = false;
    protected boolean shouldResetTick = false;
    private boolean justStopped = true;
    protected boolean justStartedTransition = false;
    @Nullable
    protected SoundKeyframeHandler<T> soundKeyframeHandler = null;
    @Nullable
    protected ParticleKeyframeHandler<T> particleKeyframeHandler = null;
    @Nullable
    protected CustomKeyframeHandler<T> customKeyframeHandler = null;
    @NotNull
    public final Map<String, Animation> triggerableAnimations = new Object2ObjectOpenHashMap(0);
    @Nullable
    protected Animation triggeredAnimation = null;
    protected boolean handlingTriggeredAnimations = false;
    protected double transitionLength;
    @Nullable
    protected Animation currentRawAnimation;
    @Nullable
    protected AnimationProcessor.QueuedAnimation currentAnimation;
    @NotNull
    public State animationState = State.STOPPED;
    protected double tickOffset;
    protected double lastPollTime = -1.0;
    @NotNull
    protected Function<T, Double> animationSpeedModifier = animatable -> 1.0;
    @NotNull
    protected Function<T, Easing> overrideEasingTypeFunction = animatable -> null;
    @NotNull
    private final Set<KeyFrameData> executedKeyFrames = new ObjectOpenHashSet();
    @Nullable
    protected BlueModel<T> lastModel;
    private double lastAdjustedTick = 0.0;

    public AnimationController(@NotNull T pAnimatable, @NotNull AnimationStateHandler<T> pAnimationHandler) {
        this(pAnimatable, "base_controller", 0, pAnimationHandler);
    }

    public AnimationController(@NotNull T pAnimatable, @NotNull String pName, @NotNull AnimationStateHandler<T> pAnimationHandler) {
        this(pAnimatable, pName, 0, pAnimationHandler);
    }

    public AnimationController(@NotNull T pAnimatable, int pTransitionTickTime, @NotNull AnimationStateHandler<T> pAnimationHandler) {
        this(pAnimatable, "base_controller", pTransitionTickTime, pAnimationHandler);
    }

    public AnimationController(@NotNull T pAnimatable, @NotNull String pName, int pTransitionTickTime, @NotNull AnimationStateHandler<T> pAnimationHandler) {
        this.animatable = pAnimatable;
        this.name = pName;
        this.transitionLength = pTransitionTickTime;
        this.stateHandler = pAnimationHandler;
    }

    @NotNull
    public AnimationController<T> setSoundKeyframeHandler(@NotNull SoundKeyframeHandler<T> pSoundHandler) {
        this.soundKeyframeHandler = pSoundHandler;
        return this;
    }

    @NotNull
    public AnimationController<T> setParticleKeyframeHandler(@NotNull ParticleKeyframeHandler<T> pParticleHandler) {
        this.particleKeyframeHandler = pParticleHandler;
        return this;
    }

    @NotNull
    public AnimationController<T> setCustomInstructionKeyframeHandler(@NotNull CustomKeyframeHandler<T> pCustomInstructionHandler) {
        this.customKeyframeHandler = pCustomInstructionHandler;
        return this;
    }

    @NotNull
    public AnimationController<T> setAnimationSpeedHandler(@NotNull Function<T, Double> pSpeedModFunction) {
        this.animationSpeedModifier = pSpeedModFunction;
        return this;
    }

    @NotNull
    public AnimationController<T> setAnimationSpeed(@NotNull Double pSpeed) {
        return this.setAnimationSpeedHandler(animatable -> pSpeed);
    }

    @NotNull
    public AnimationController<T> setOverrideEasingType(@NotNull Easing pEasingFunction) {
        return this.setOverrideEasingTypeFunction(animatable -> pEasingFunction);
    }

    @NotNull
    public AnimationController<T> setOverrideEasingTypeFunction(@NotNull Function<T, Easing> pEasingType) {
        this.overrideEasingTypeFunction = pEasingType;
        return this;
    }

    @NotNull
    public AnimationController<T> triggerableAnim(@NotNull String pName, @NotNull Animation pAnimation) {
        this.triggerableAnimations.put(pName, pAnimation);
        return this;
    }

    @NotNull
    public AnimationController<T> receiveTriggeredAnimations() {
        this.handlingTriggeredAnimations = true;
        return this;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public AnimationProcessor.QueuedAnimation getCurrentAnimation() {
        return this.currentAnimation;
    }

    @Nullable
    public Animation getTriggeredAnimation() {
        return this.triggeredAnimation;
    }

    @NotNull
    public State getAnimationState() {
        return this.animationState;
    }

    @NotNull
    public Map<String, BoneAnimationFrame> getBoneAnimationQueues() {
        return this.boneAnimationQueues;
    }

    public double getAnimationSpeed() {
        return this.animationSpeedModifier.apply(this.animatable);
    }

    public void forceAnimationReset() {
        this.needsAnimationReload = true;
    }

    public void stop() {
        this.animationState = State.STOPPED;
    }

    @NotNull
    public AnimationController<T> transitionLength(int pTicks) {
        this.transitionLength = pTicks;
        return this;
    }

    public boolean hasAnimationFinished() {
        return this.currentRawAnimation != null && this.animationState == State.STOPPED;
    }

    @NotNull
    public Animation getCurrentRawAnimation() {
        return this.currentRawAnimation;
    }

    public boolean isPlayingTriggeredAnimation() {
        return this.triggeredAnimation != null && !this.hasAnimationFinished();
    }

    public void setAnimation(@NotNull Animation pAnimation) {
        if (pAnimation.getAnimationStages().isEmpty()) {
            this.stop();
            return;
        }
        if (this.needsAnimationReload || !pAnimation.equals(this.currentRawAnimation)) {
            Queue<AnimationProcessor.QueuedAnimation> animations;
            if (this.lastModel != null && (animations = this.lastModel.getAnimationProcessor().buildAnimationQueue(this.animatable, pAnimation)) != null) {
                this.animationQueue = animations;
                this.currentRawAnimation = pAnimation;
                this.shouldResetTick = true;
                this.animationState = State.TRANSITIONING;
                this.justStartedTransition = true;
                this.needsAnimationReload = false;
                return;
            }
            this.stop();
        }
    }

    public boolean tryTriggerAnimation(@NotNull String pAnimName) {
        Animation anim = this.triggerableAnimations.get(pAnimName);
        if (anim == null) {
            return false;
        }
        this.triggeredAnimation = anim;
        if (this.animationState == State.STOPPED) {
            this.animationState = State.TRANSITIONING;
            this.shouldResetTick = true;
            this.justStartedTransition = true;
        }
        return true;
    }

    public boolean stopTriggeredAnimation() {
        if (this.triggeredAnimation == null) {
            return false;
        }
        if (this.currentRawAnimation == this.triggeredAnimation) {
            this.currentAnimation = null;
            this.currentRawAnimation = null;
        }
        this.triggeredAnimation = null;
        this.needsAnimationReload = true;
        return true;
    }

    @NotNull
    protected PlayState handleAnimationState(@NotNull AnimationState<T> pState) {
        if (this.triggeredAnimation != null) {
            if (this.currentRawAnimation != this.triggeredAnimation) {
                this.currentAnimation = null;
            }
            this.setAnimation(this.triggeredAnimation);
            if (!(this.hasAnimationFinished() || this.handlingTriggeredAnimations && this.stateHandler.handle(pState) != PlayState.PLAY)) {
                return PlayState.PLAY;
            }
            this.triggeredAnimation = null;
            this.needsAnimationReload = true;
        }
        return this.stateHandler.handle(pState);
    }

    public void process(@NotNull BlueModel<T> pModel, @NotNull AnimationState<T> pState, @NotNull Map<String, BoneCache> pBones, @NotNull Map<String, BoneSnapshot> pSnapshots, double pSeekTime, boolean pCrashWhenCantFindBone) {
        PlayState playState;
        double adjustedTick = this.adjustTick(pSeekTime);
        this.lastModel = pModel;
        if (this.animationState == State.TRANSITIONING && adjustedTick >= this.transitionLength) {
            this.shouldResetTick = true;
            this.animationState = State.RUNNING;
            adjustedTick = this.adjustTick(pSeekTime);
        }
        if ((playState = this.handleAnimationState(pState)) == PlayState.STOP || this.currentAnimation == null && this.animationQueue.isEmpty()) {
            this.animationState = State.STOPPED;
            this.justStopped = true;
            return;
        }
        this.createInitialQueues(pBones.values());
        if (this.justStartedTransition && (this.shouldResetTick || this.justStopped)) {
            this.justStopped = false;
            adjustedTick = this.adjustTick(pSeekTime);
            if (this.currentAnimation == null) {
                this.animationState = State.TRANSITIONING;
            }
        } else if (this.currentAnimation == null) {
            this.shouldResetTick = true;
            this.animationState = State.TRANSITIONING;
            this.justStartedTransition = true;
            this.needsAnimationReload = false;
            adjustedTick = this.adjustTick(pSeekTime);
        } else if (this.animationState != State.TRANSITIONING) {
            this.animationState = State.RUNNING;
        }
        if (this.getAnimationState() == State.RUNNING) {
            this.processCurrentAnimation(adjustedTick, pSeekTime, pCrashWhenCantFindBone);
        } else if (this.animationState == State.TRANSITIONING) {
            if (this.lastPollTime != pSeekTime && (adjustedTick == 0.0 || this.isJustStarting)) {
                this.justStartedTransition = false;
                this.lastPollTime = pSeekTime;
                this.currentAnimation = this.animationQueue.poll();
                this.resetEventKeyFrames();
                if (this.currentAnimation == null) {
                    return;
                }
                this.saveSnapshotsForAnimation(this.currentAnimation, pSnapshots);
            }
            if (this.currentAnimation != null) {
                MathParser.setVariable("q.anim_time", () -> 0.0);
                for (BoneAnimationCache boneAnimationCache : this.currentAnimation.animationCache().boneAnimationCaches()) {
                    BoneAnimationFrame boneAnimationFrame = this.boneAnimationQueues.get(boneAnimationCache.boneName());
                    BoneSnapshot boneSnapshot = this.boneSnapshots.get(boneAnimationCache.boneName());
                    BoneCache bone = pBones.get(boneAnimationCache.boneName());
                    if (boneSnapshot == null) continue;
                    if (bone == null) {
                        if (!pCrashWhenCantFindBone) continue;
                        throw new RuntimeException("Could not find bone: " + boneAnimationCache.boneName());
                    }
                    KeyframeStackCache<KeyframeCache<MathValue>> rotationKeyFrames = boneAnimationCache.rotationKeyFrames();
                    KeyframeStackCache<KeyframeCache<MathValue>> positionKeyFrames = boneAnimationCache.positionKeyFrames();
                    KeyframeStackCache<KeyframeCache<MathValue>> scaleKeyFrames = boneAnimationCache.scaleKeyFrames();
                    if (!rotationKeyFrames.xKeyframes().isEmpty()) {
                        boneAnimationFrame.addNextRotation(null, adjustedTick, this.transitionLength, boneSnapshot, bone.getInitialSnapshot(), this.getAnimationPointAtTick(rotationKeyFrames.xKeyframes(), 0.0, true, class_2350.class_2351.field_11048), this.getAnimationPointAtTick(rotationKeyFrames.yKeyframes(), 0.0, true, class_2350.class_2351.field_11052), this.getAnimationPointAtTick(rotationKeyFrames.zKeyframes(), 0.0, true, class_2350.class_2351.field_11051));
                    }
                    if (!positionKeyFrames.xKeyframes().isEmpty()) {
                        boneAnimationFrame.addNextPosition(null, adjustedTick, this.transitionLength, boneSnapshot, this.getAnimationPointAtTick(positionKeyFrames.xKeyframes(), 0.0, false, class_2350.class_2351.field_11048), this.getAnimationPointAtTick(positionKeyFrames.yKeyframes(), 0.0, false, class_2350.class_2351.field_11052), this.getAnimationPointAtTick(positionKeyFrames.zKeyframes(), 0.0, false, class_2350.class_2351.field_11051));
                    }
                    if (scaleKeyFrames.xKeyframes().isEmpty()) continue;
                    boneAnimationFrame.addNextScale(null, adjustedTick, this.transitionLength, boneSnapshot, this.getAnimationPointAtTick(scaleKeyFrames.xKeyframes(), 0.0, false, class_2350.class_2351.field_11048), this.getAnimationPointAtTick(scaleKeyFrames.yKeyframes(), 0.0, false, class_2350.class_2351.field_11052), this.getAnimationPointAtTick(scaleKeyFrames.zKeyframes(), 0.0, false, class_2350.class_2351.field_11051));
                }
            }
        }
    }

    private void processCurrentAnimation(double pAdjustedTick, double pSeekTime, boolean pCrashWhenCantFindBone) {
        if (pAdjustedTick >= this.currentAnimation.animationCache().length()) {
            if (this.currentAnimation.loopType().shouldPlayAgain((BlueAnimatable)this.animatable, this, this.currentAnimation.animationCache())) {
                if (this.animationState != State.PAUSED) {
                    this.shouldResetTick = true;
                    pAdjustedTick = this.adjustTick(pSeekTime);
                    this.resetEventKeyFrames();
                }
            } else {
                AnimationProcessor.QueuedAnimation nextAnimation = this.animationQueue.peek();
                this.resetEventKeyFrames();
                if (nextAnimation == null) {
                    this.animationState = State.STOPPED;
                    return;
                }
                this.animationState = State.TRANSITIONING;
                this.shouldResetTick = true;
                pAdjustedTick = this.adjustTick(pSeekTime);
                this.currentAnimation = this.animationQueue.poll();
            }
        }
        double finalAdjustedTick = pAdjustedTick;
        MathParser.setVariable("q.anim_time", () -> finalAdjustedTick / 20.0);
        for (BoneAnimationCache boneAnimationCache : this.currentAnimation.animationCache().boneAnimationCaches()) {
            BoneAnimationFrame boneAnimationFrame = this.boneAnimationQueues.get(boneAnimationCache.boneName());
            if (boneAnimationFrame == null) {
                if (!pCrashWhenCantFindBone) continue;
                throw new RuntimeException("Could not find bone: " + boneAnimationCache.boneName());
            }
            KeyframeStackCache<KeyframeCache<MathValue>> rotationKeyFrames = boneAnimationCache.rotationKeyFrames();
            KeyframeStackCache<KeyframeCache<MathValue>> positionKeyFrames = boneAnimationCache.positionKeyFrames();
            KeyframeStackCache<KeyframeCache<MathValue>> scaleKeyFrames = boneAnimationCache.scaleKeyFrames();
            if (!rotationKeyFrames.xKeyframes().isEmpty()) {
                boneAnimationFrame.addRotations(this.getAnimationPointAtTick(rotationKeyFrames.xKeyframes(), pAdjustedTick, true, class_2350.class_2351.field_11048), this.getAnimationPointAtTick(rotationKeyFrames.yKeyframes(), pAdjustedTick, true, class_2350.class_2351.field_11052), this.getAnimationPointAtTick(rotationKeyFrames.zKeyframes(), pAdjustedTick, true, class_2350.class_2351.field_11051));
            }
            if (!positionKeyFrames.xKeyframes().isEmpty()) {
                boneAnimationFrame.addPositions(this.getAnimationPointAtTick(positionKeyFrames.xKeyframes(), pAdjustedTick, false, class_2350.class_2351.field_11048), this.getAnimationPointAtTick(positionKeyFrames.yKeyframes(), pAdjustedTick, false, class_2350.class_2351.field_11052), this.getAnimationPointAtTick(positionKeyFrames.zKeyframes(), pAdjustedTick, false, class_2350.class_2351.field_11051));
            }
            if (scaleKeyFrames.xKeyframes().isEmpty()) continue;
            boneAnimationFrame.addScales(this.getAnimationPointAtTick(scaleKeyFrames.xKeyframes(), pAdjustedTick, false, class_2350.class_2351.field_11048), this.getAnimationPointAtTick(scaleKeyFrames.yKeyframes(), pAdjustedTick, false, class_2350.class_2351.field_11052), this.getAnimationPointAtTick(scaleKeyFrames.zKeyframes(), pAdjustedTick, false, class_2350.class_2351.field_11051));
        }
        pAdjustedTick += this.transitionLength;
        for (SoundKeyframeData soundKeyframeData : this.currentAnimation.animationCache().keyFrames().sounds()) {
            if (!(pAdjustedTick >= soundKeyframeData.getStartTick()) || !this.executedKeyFrames.add(soundKeyframeData)) continue;
            if (this.soundKeyframeHandler == null) {
                BaseLogger.log(BaseLogLevel.WARNING, "Sound Keyframe found for " + this.animatable.getClass().getSimpleName() + " -> " + this.getName() + ", but no keyframe handler registered");
                break;
            }
            this.soundKeyframeHandler.handle(new SoundKeyframeEvent<T>(this.animatable, pAdjustedTick, this, soundKeyframeData));
        }
        for (ParticleKeyframeData particleKeyframeData : this.currentAnimation.animationCache().keyFrames().particles()) {
            if (!(pAdjustedTick >= particleKeyframeData.getStartTick()) || !this.executedKeyFrames.add(particleKeyframeData)) continue;
            if (this.particleKeyframeHandler == null) {
                BaseLogger.log(BaseLogLevel.WARNING, "Particle Keyframe found for " + this.animatable.getClass().getSimpleName() + " -> " + this.getName() + ", but no keyframe handler registered");
                break;
            }
            this.particleKeyframeHandler.handle(new ParticleKeyframeEvent<T>(this.animatable, pAdjustedTick, this, particleKeyframeData));
        }
        for (CustomInstructionKeyframeData customInstructionKeyframeData : this.currentAnimation.animationCache().keyFrames().customInstructions()) {
            if (!(pAdjustedTick >= customInstructionKeyframeData.getStartTick()) || !this.executedKeyFrames.add(customInstructionKeyframeData)) continue;
            if (this.customKeyframeHandler == null) {
                BaseLogger.log(BaseLogLevel.WARNING, "Custom Instruction Keyframe found for " + this.animatable.getClass().getSimpleName() + " -> " + this.getName() + ", but no keyframe handler registered");
                break;
            }
            this.customKeyframeHandler.handle(new CustomInstructionKeyframeEvent<T>(this.animatable, pAdjustedTick, this, customInstructionKeyframeData));
        }
        if (this.transitionLength == 0.0 && this.shouldResetTick && this.animationState == State.TRANSITIONING) {
            this.currentAnimation = this.animationQueue.poll();
        }
    }

    public double getAnimTime() {
        return this.lastAdjustedTick / 20.0;
    }

    private void createInitialQueues(@NotNull Collection<BoneCache> pModelRendererList) {
        this.boneAnimationQueues.clear();
        for (BoneCache modelRenderer : pModelRendererList) {
            this.boneAnimationQueues.put(modelRenderer.getName(), new BoneAnimationFrame(modelRenderer));
        }
    }

    private void saveSnapshotsForAnimation(@NotNull AnimationProcessor.QueuedAnimation pAnimation, @NotNull Map<String, BoneSnapshot> pSnapshots) {
        block0: for (BoneSnapshot snapshot : pSnapshots.values()) {
            if (pAnimation.animationCache().boneAnimationCaches() == null) continue;
            for (BoneAnimationCache boneAnimationCache : pAnimation.animationCache().boneAnimationCaches()) {
                if (!boneAnimationCache.boneName().equals(snapshot.getBone().getName())) continue;
                this.boneSnapshots.put(boneAnimationCache.boneName(), BoneSnapshot.copy(snapshot));
                continue block0;
            }
        }
    }

    protected double adjustTick(double pTick) {
        if (!this.shouldResetTick) {
            return this.animationSpeedModifier.apply(this.animatable) * Math.max(pTick - this.tickOffset, 0.0);
        }
        if (this.getAnimationState() != State.STOPPED) {
            this.tickOffset = pTick;
        }
        this.shouldResetTick = false;
        return 0.0;
    }

    @NotNull
    private AnimationPoint getAnimationPointAtTick(@NotNull List<KeyframeCache<MathValue>> pFrames, double pTick, boolean pIsRotation, @NotNull class_2350.class_2351 pAxis) {
        KeyframeLocation<KeyframeCache<MathValue>> location = this.getCurrentKeyFrameLocation(pFrames, pTick);
        KeyframeCache<MathValue> currentFrame = location.keyframe();
        double startValue = currentFrame.startValue().get();
        double endValue = currentFrame.endValue().get();
        if (pIsRotation) {
            if (!(currentFrame.startValue() instanceof Constant)) {
                startValue = Math.toRadians(startValue);
                if (pAxis == class_2350.class_2351.field_11048 || pAxis == class_2350.class_2351.field_11052) {
                    startValue *= -1.0;
                }
            }
            if (!(currentFrame.endValue() instanceof Constant)) {
                endValue = Math.toRadians(endValue);
                if (pAxis == class_2350.class_2351.field_11048 || pAxis == class_2350.class_2351.field_11052) {
                    endValue *= -1.0;
                }
            }
        }
        return new AnimationPoint(currentFrame, location.startTick(), currentFrame.length(), startValue, endValue);
    }

    @NotNull
    private KeyframeLocation<KeyframeCache<MathValue>> getCurrentKeyFrameLocation(@NotNull List<KeyframeCache<MathValue>> pFrames, double pAgeInTicks) {
        double totalFrameTime = 0.0;
        for (KeyframeCache<MathValue> frame : pFrames) {
            if (!((totalFrameTime += frame.length()) > pAgeInTicks)) continue;
            return new KeyframeLocation<KeyframeCache<MathValue>>(frame, pAgeInTicks - (totalFrameTime - frame.length()));
        }
        return new KeyframeLocation<KeyframeCache<MathValue>>(pFrames.getLast(), pAgeInTicks);
    }

    private void resetEventKeyFrames() {
        this.executedKeyFrames.clear();
    }

    @FunctionalInterface
    public static interface AnimationStateHandler<A extends BlueAnimatable> {
        @NotNull
        public PlayState handle(@NotNull AnimationState<A> var1);
    }

    @FunctionalInterface
    public static interface SoundKeyframeHandler<A extends BlueAnimatable> {
        public void handle(@NotNull SoundKeyframeEvent<A> var1);
    }

    @FunctionalInterface
    public static interface ParticleKeyframeHandler<A extends BlueAnimatable> {
        public void handle(@NotNull ParticleKeyframeEvent<A> var1);
    }

    @FunctionalInterface
    public static interface CustomKeyframeHandler<A extends BlueAnimatable> {
        public void handle(@NotNull CustomInstructionKeyframeEvent<A> var1);
    }

    public static enum State {
        RUNNING,
        TRANSITIONING,
        PAUSED,
        STOPPED;

    }
}

