/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.animation;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.loader.animatable.base.AnimatableManager;
import software.bluelib.loader.animatable.base.BlueAnimatable;
import software.bluelib.loader.animation.Animation;
import software.bluelib.loader.animation.AnimationController;
import software.bluelib.loader.animation.AnimationState;
import software.bluelib.loader.animation.bone.BoneSnapshot;
import software.bluelib.loader.animation.keyframe.AnimationPoint;
import software.bluelib.loader.animation.keyframe.BoneAnimationFrame;
import software.bluelib.loader.animation.math.Easing;
import software.bluelib.loader.cache.animations.AnimationCache;
import software.bluelib.loader.cache.model.BoneCache;
import software.bluelib.loader.cache.model.ModelCache;
import software.bluelib.loader.geckolib.math.MathParser;
import software.bluelib.loader.geckolib.math.MoLangQueries;
import software.bluelib.loader.model.BlueModel;

public class AnimationProcessor<T extends BlueAnimatable> {
    @NotNull
    private final Map<String, BoneCache> bones = new Object2ObjectOpenHashMap();
    @NotNull
    private final BlueModel<T> model;
    public boolean reloadAnimations = false;

    public AnimationProcessor(@NotNull BlueModel<T> pModel) {
        this.model = pModel;
    }

    @Nullable
    public Queue<QueuedAnimation> buildAnimationQueue(@NotNull T pAnimatable, @NotNull Animation pAnimation) {
        LinkedList<QueuedAnimation> animations = new LinkedList<QueuedAnimation>();
        boolean error = false;
        for (Animation.Stage stage : pAnimation.getAnimationStages()) {
            AnimationCache animationCache = null;
            if (stage.animationName() == "internal.wait") {
                animationCache = AnimationCache.generateWaitAnimation(stage.additionalTicks());
            } else {
                try {
                    animationCache = this.model.getAnimation(pAnimatable, stage.animationName());
                }
                catch (RuntimeException ex) {
                    BaseLogger.log(BaseLogLevel.ERROR, "Unable to find animation: " + stage.animationName() + " for " + pAnimatable.getClass().getSimpleName(), ex);
                    error = true;
                }
            }
            if (animationCache == null) continue;
            animations.add(new QueuedAnimation(animationCache, stage.loopType()));
        }
        return error ? null : animations;
    }

    public void tickAnimation(@NotNull T pAnimatable, @NotNull BlueModel<T> pModel, @NotNull AnimatableManager<T> pAnimatableManager, double pAnimTime, @NotNull AnimationState<T> pState, boolean pCrashWhenCantFindBone) {
        Map<String, BoneSnapshot> boneSnapshots = this.updateBoneSnapshots(pAnimatableManager.getBoneSnapshotCollection());
        for (AnimationController<T> controller : pAnimatableManager.getAnimationControllers().values()) {
            if (this.reloadAnimations) {
                controller.forceAnimationReset();
                controller.getBoneAnimationQueues().clear();
            }
            controller.isJustStarting = pAnimatableManager.isFirstTick();
            pState.withController(controller);
            MathParser.setVariable("q.anim_time", () -> pState.getController() != null ? pState.getController().getAnimTime() : 0.0);
            controller.process(pModel, pState, this.bones, boneSnapshots, pAnimTime, pCrashWhenCantFindBone);
            for (BoneAnimationFrame boneAnimation : controller.getBoneAnimationQueues().values()) {
                BoneCache bone = boneAnimation.bone();
                BoneSnapshot snapshot = boneSnapshots.get(bone.getName());
                BoneSnapshot initialSnapshot = bone.getInitialSnapshot();
                AnimationPoint rotXPoint = (AnimationPoint)boneAnimation.rotationXQueue().poll();
                AnimationPoint rotYPoint = (AnimationPoint)boneAnimation.rotationYQueue().poll();
                AnimationPoint rotZPoint = (AnimationPoint)boneAnimation.rotationZQueue().poll();
                AnimationPoint posXPoint = (AnimationPoint)boneAnimation.positionXQueue().poll();
                AnimationPoint posYPoint = (AnimationPoint)boneAnimation.positionYQueue().poll();
                AnimationPoint posZPoint = (AnimationPoint)boneAnimation.positionZQueue().poll();
                AnimationPoint scaleXPoint = (AnimationPoint)boneAnimation.scaleXQueue().poll();
                AnimationPoint scaleYPoint = (AnimationPoint)boneAnimation.scaleYQueue().poll();
                AnimationPoint scaleZPoint = (AnimationPoint)boneAnimation.scaleZQueue().poll();
                Easing easing = controller.overrideEasingTypeFunction.apply(pAnimatable);
                if (rotXPoint != null && rotYPoint != null && rotZPoint != null) {
                    bone.setRotX((float)Easing.lerpWithOverride(rotXPoint, easing) + initialSnapshot.getRotX());
                    bone.setRotY((float)Easing.lerpWithOverride(rotYPoint, easing) + initialSnapshot.getRotY());
                    bone.setRotZ((float)Easing.lerpWithOverride(rotZPoint, easing) + initialSnapshot.getRotZ());
                    snapshot.updateRotation(bone.getRotX(), bone.getRotY(), bone.getRotZ());
                    snapshot.startRotAnim();
                    bone.markRotationAsChanged();
                }
                if (posXPoint != null && posYPoint != null && posZPoint != null) {
                    bone.setPosX((float)Easing.lerpWithOverride(posXPoint, easing));
                    bone.setPosY((float)Easing.lerpWithOverride(posYPoint, easing));
                    bone.setPosZ((float)Easing.lerpWithOverride(posZPoint, easing));
                    snapshot.updateOffset(bone.getPosX(), bone.getPosY(), bone.getPosZ());
                    snapshot.startPosAnim();
                    bone.markPositionAsChanged();
                }
                if (scaleXPoint == null || scaleYPoint == null || scaleZPoint == null) continue;
                bone.setScaleX(Float.valueOf((float)Easing.lerpWithOverride(scaleXPoint, easing)));
                bone.setScaleY(Float.valueOf((float)Easing.lerpWithOverride(scaleYPoint, easing)));
                bone.setScaleZ(Float.valueOf((float)Easing.lerpWithOverride(scaleZPoint, easing)));
                snapshot.updateScale(bone.getScaleX().floatValue(), bone.getScaleY().floatValue(), bone.getScaleZ().floatValue());
                snapshot.startScaleAnim();
                bone.markScaleAsChanged();
            }
        }
        this.reloadAnimations = false;
        double resetTickLength = pAnimatable.boneResetTime();
        for (BoneCache bone : this.getRegisteredBones()) {
            double percentageReset;
            BoneSnapshot saveSnapshot;
            BoneSnapshot initialSnapshot;
            if (!bone.hasRotationChanged()) {
                initialSnapshot = bone.getInitialSnapshot();
                saveSnapshot = boneSnapshots.get(bone.getName());
                if (saveSnapshot.isRotAnimInProgress()) {
                    saveSnapshot.stopRotAnim(pAnimTime);
                }
                percentageReset = resetTickLength == 0.0 ? 1.0 : Math.min((pAnimTime - saveSnapshot.getLastResetRotationTick()) / resetTickLength, 1.0);
                float initialRotX = initialSnapshot.getRotX();
                float initialRotY = initialSnapshot.getRotY();
                float initialRotZ = initialSnapshot.getRotZ();
                float lastXRot = saveSnapshot.getRotX();
                float lastYRot = saveSnapshot.getRotY();
                float lastZRot = saveSnapshot.getRotZ();
                if (percentageReset == 0.0) {
                    if (lastXRot != initialRotX && this.isSuspectedCompletedRotation(lastXRot)) {
                        lastXRot = initialRotX;
                        percentageReset = 1.0;
                    }
                    if (lastYRot != initialRotY && this.isSuspectedCompletedRotation(lastYRot)) {
                        lastYRot = initialRotY;
                        percentageReset = 1.0;
                    }
                    if (lastZRot != initialRotZ && this.isSuspectedCompletedRotation(lastZRot)) {
                        lastZRot = initialRotZ;
                        percentageReset = 1.0;
                    }
                }
                bone.setRotX((float)class_3532.method_16436((double)percentageReset, (double)lastXRot, (double)initialRotX));
                bone.setRotY((float)class_3532.method_16436((double)percentageReset, (double)lastYRot, (double)initialRotY));
                bone.setRotZ((float)class_3532.method_16436((double)percentageReset, (double)lastZRot, (double)initialRotZ));
                if (percentageReset >= 1.0) {
                    saveSnapshot.updateRotation(bone.getRotX(), bone.getRotY(), bone.getRotZ());
                }
            }
            if (!bone.hasPositionChanged()) {
                initialSnapshot = bone.getInitialSnapshot();
                saveSnapshot = boneSnapshots.get(bone.getName());
                if (saveSnapshot.isPosAnimInProgress()) {
                    saveSnapshot.stopPosAnim(pAnimTime);
                }
                percentageReset = resetTickLength == 0.0 ? 1.0 : Math.min((pAnimTime - saveSnapshot.getLastResetPositionTick()) / resetTickLength, 1.0);
                bone.setPosX((float)class_3532.method_16436((double)percentageReset, (double)saveSnapshot.getOffsetX(), (double)initialSnapshot.getOffsetX()));
                bone.setPosY((float)class_3532.method_16436((double)percentageReset, (double)saveSnapshot.getOffsetY(), (double)initialSnapshot.getOffsetY()));
                bone.setPosZ((float)class_3532.method_16436((double)percentageReset, (double)saveSnapshot.getOffsetZ(), (double)initialSnapshot.getOffsetZ()));
                if (percentageReset >= 1.0) {
                    saveSnapshot.updateOffset(bone.getPosX(), bone.getPosY(), bone.getPosZ());
                }
            }
            if (bone.hasScaleChanged()) continue;
            initialSnapshot = bone.getInitialSnapshot();
            saveSnapshot = boneSnapshots.get(bone.getName());
            if (saveSnapshot.isScaleAnimInProgress()) {
                saveSnapshot.stopScaleAnim(pAnimTime);
            }
            percentageReset = resetTickLength == 0.0 ? 1.0 : Math.min((pAnimTime - saveSnapshot.getLastResetScaleTick()) / resetTickLength, 1.0);
            bone.setScaleX(Float.valueOf((float)class_3532.method_16436((double)percentageReset, (double)saveSnapshot.getScaleX(), (double)initialSnapshot.getScaleX())));
            bone.setScaleY(Float.valueOf((float)class_3532.method_16436((double)percentageReset, (double)saveSnapshot.getScaleY(), (double)initialSnapshot.getScaleY())));
            bone.setScaleZ(Float.valueOf((float)class_3532.method_16436((double)percentageReset, (double)saveSnapshot.getScaleZ(), (double)initialSnapshot.getScaleZ())));
            if (!(percentageReset >= 1.0)) continue;
            saveSnapshot.updateScale(bone.getScaleX().floatValue(), bone.getScaleY().floatValue(), bone.getScaleZ().floatValue());
        }
        this.resetBoneTransformationMarkers();
        pAnimatableManager.finishFirstTick();
    }

    private boolean isSuspectedCompletedRotation(float pLastRotation) {
        float rotations = class_3532.method_15379((float)(pLastRotation / ((float)Math.PI * 2)));
        float partialRotation = 1.0f - (rotations - (float)((int)rotations));
        return partialRotation == 1.0f || (double)partialRotation < 0.026 * (double)rotations;
    }

    private void resetBoneTransformationMarkers() {
        this.getRegisteredBones().forEach(BoneCache::resetStateChanges);
    }

    @NotNull
    private Map<String, BoneSnapshot> updateBoneSnapshots(@NotNull Map<String, BoneSnapshot> pSnapshots) {
        for (BoneCache bone : this.getRegisteredBones()) {
            if (pSnapshots.containsKey(bone.getName())) continue;
            pSnapshots.put(bone.getName(), BoneSnapshot.copy(bone.getInitialSnapshot()));
        }
        return pSnapshots;
    }

    @NotNull
    public BoneCache getBone(@NotNull String pBoneName) {
        return this.bones.get(pBoneName);
    }

    public void registerBlueBone(@NotNull BoneCache pBone) {
        pBone.saveInitialSnapshot();
        this.bones.put(pBone.getName(), pBone);
        for (BoneCache child : pBone.getChildBones()) {
            this.registerBlueBone(child);
        }
    }

    public void setActiveModel(@NotNull ModelCache pModel) {
        this.bones.clear();
        for (BoneCache bone : pModel.topLevelBones()) {
            this.registerBlueBone(bone);
        }
    }

    @NotNull
    public Collection<BoneCache> getRegisteredBones() {
        return this.bones.values();
    }

    public void preAnimationSetup(@NotNull AnimationState<T> pAnimationState, double pAnimTime) {
        MoLangQueries.updateActor(pAnimationState, pAnimTime);
        this.model.applyMolangQueries(pAnimationState, pAnimTime);
    }

    public record QueuedAnimation(@NotNull AnimationCache animationCache, @NotNull AnimationCache.LoopType loopType) {
    }
}

