/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.cache;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3304;
import net.minecraft.class_3695;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.entity.variant.IVariantProvider;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.loader.BlueLoader;
import software.bluelib.loader.cache.animations.AnimationLibraryCache;
import software.bluelib.loader.cache.controller.ControllerCache;
import software.bluelib.loader.cache.model.ModelCache;
import software.bluelib.loader.cache.variants.EntityCache;
import software.bluelib.loader.geckolib.math.value.Constant;
import software.bluelib.loader.json.deserialize.animation.BakedAnimationsAdapter;

public class ResourceCache
extends BlueLoader {

    public static class Server {
        @NotNull
        public static Map<class_2960, EntityCache> VARIANTS = Collections.emptyMap();
        @NotNull
        private static Map<class_2960, ControllerCache> CONTROLLERS = Collections.emptyMap();

        @NotNull
        public static Map<class_2960, EntityCache> getVariants() {
            return VARIANTS;
        }

        @NotNull
        public static Map<class_2960, ControllerCache> getControllers() {
            return CONTROLLERS;
        }

        public static void registerReloadListener(@NotNull MinecraftServer pServer, @NotNull List<IVariantProvider> pProviders) {
            Server.reload(pProviders, pServer.method_34864(), class_156.method_18349(), (Executor)pServer);
        }

        public static CompletableFuture<Void> reload(@NotNull List<IVariantProvider> pProviders, @NotNull class_3300 pResourceManager, @NotNull Executor pBackgroundExecutor, @NotNull Executor pGameExecutor) {
            Server.clearCaches();
            CompletionStage controllers = ResourceCache.loadControllers(pBackgroundExecutor, pResourceManager).exceptionally(ex -> {
                BaseLogger.log((Boolean)true, BaseLogLevel.ERROR, "controllers failed: " + ex.getMessage());
                return Collections.emptyMap();
            });
            CompletionStage variants = ResourceCache.loadVariants(pBackgroundExecutor, pResourceManager, pProviders).exceptionally(ex -> {
                BaseLogger.log((Boolean)true, BaseLogLevel.ERROR, "variants failed: " + ex.getMessage());
                return Collections.emptyMap();
            });
            return ((CompletableFuture)controllers).thenCombineAsync(variants, (c, v) -> {
                CONTROLLERS = c;
                VARIANTS = v;
                System.out.println("Variants Cache: " + String.valueOf(VARIANTS));
                System.out.println("Controllers Cache: " + String.valueOf(CONTROLLERS));
                return null;
            }, pGameExecutor);
        }

        public static void clearCaches() {
            VARIANTS = Collections.emptyMap();
            CONTROLLERS = Collections.emptyMap();
        }
    }

    public static class Client {
        @NotNull
        private static Map<class_2960, AnimationLibraryCache> ANIMATIONS = Collections.emptyMap();
        @NotNull
        private static Map<class_2960, ModelCache> MODELS = Collections.emptyMap();

        @NotNull
        public static Map<class_2960, AnimationLibraryCache> getBakedAnimations() {
            return ANIMATIONS;
        }

        @NotNull
        public static Map<class_2960, ModelCache> getBakedModels() {
            return MODELS;
        }

        public static void registerReloadListener() {
            class_310 mc = class_310.method_1551();
            class_3300 class_33002 = mc.method_1478();
            if (class_33002 instanceof class_3304) {
                class_3304 pResourceManager = (class_3304)class_33002;
                pResourceManager.method_14477(Client::reload);
            }
        }

        @NotNull
        public static CompletableFuture<Void> reload(@NotNull class_3302.class_4045 pStage, @NotNull class_3300 pResourceManager, @NotNull class_3695 pProfilerFiller, @NotNull class_3695 pProfilerFiller1, @NotNull Executor pBackgroundExecutor, @NotNull Executor pGameExecutor) {
            Client.clearCaches();
            CompletableFuture animations = ResourceCache.loadAnimations(pBackgroundExecutor, pResourceManager);
            CompletableFuture models = ResourceCache.loadModels(pBackgroundExecutor, pResourceManager);
            return CompletableFuture.runAsync(() -> {
                BakedAnimationsAdapter.COMPRESSION_CACHE = new ConcurrentHashMap<Double, Constant>();
            }, pBackgroundExecutor).thenCompose(ignored -> ((CompletableFuture)CompletableFuture.allOf(animations, models).thenCompose(arg_0 -> ((class_3302.class_4045)pStage).method_18352(arg_0))).thenRunAsync(() -> {
                ANIMATIONS = (Map)animations.join();
                MODELS = (Map)models.join();
                BakedAnimationsAdapter.COMPRESSION_CACHE = null;
                System.out.println("Model Cache: " + String.valueOf(MODELS));
                System.out.println("Animations Cache: " + String.valueOf(ANIMATIONS));
            }, pGameExecutor));
        }

        private static void clearCaches() {
            ANIMATIONS = Collections.emptyMap();
            MODELS = Collections.emptyMap();
        }
    }
}

