/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.cache.texture;

import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.minecraft.class_1011;
import net.minecraft.class_1044;
import net.minecraft.class_1049;
import net.minecraft.class_1079;
import net.minecraft.class_2960;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3532;
import net.minecraft.class_4573;
import net.minecraft.class_7771;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.client.utils.RenderUtils;
import software.bluelib.client.utils.TextureUtils;
import software.bluelib.loader.cache.texture.AutoGlowingTexture;

public class AnimatableTexture
extends class_1049 {
    @Nullable
    protected AnimationContents animationContents = null;
    protected boolean isAnimated = false;

    public AnimatableTexture(@NotNull class_2960 pLocation) {
        super(pLocation);
    }

    public void method_4625(@NotNull class_3300 pManager) throws IOException {
        class_3298 resource = pManager.getResourceOrThrow(this.field_5224);
        class_1079 animMeta = resource.method_14481().method_43041((class_3270)class_1079.field_5337).orElse(null);
        if (animMeta != null) {
            class_1011 nativeImage;
            try (InputStream inputstream = resource.method_14482();){
                nativeImage = class_1011.method_4309((InputStream)inputstream);
            }
            this.animationContents = new AnimationContents(nativeImage, animMeta);
            if (!this.animationContents.isValid()) {
                nativeImage.close();
                return;
            }
            this.isAnimated = true;
            AnimatableTexture.onRenderThread(() -> {
                TextureUtil.prepareImage((int)this.method_4624(), (int)0, (int)this.animationContents.frameSize.comp_1049(), (int)this.animationContents.frameSize.comp_1050());
                nativeImage.method_4312(0, 0, 0, 0, 0, this.animationContents.frameSize.comp_1049(), this.animationContents.frameSize.comp_1050(), false, false);
            });
        }
    }

    public boolean isAnimated() {
        return this.isAnimated;
    }

    public static void setAndUpdate(@NotNull class_2960 pTexturePath) {
        AnimatableTexture.setAndUpdate(pTexturePath, RenderUtils.getCurrentTick().intValue());
    }

    public static void setAndUpdate(@NotNull class_2960 pTexturePath, int pFrameTick) {
        class_1044 texture = TextureUtils.getTexture(pTexturePath);
        if (texture instanceof AnimatableTexture) {
            AnimatableTexture animatableTexture = (AnimatableTexture)texture;
            animatableTexture.setAnimationFrame(pFrameTick);
        }
        RenderSystem.setShaderTexture((int)0, (int)texture.method_4624());
    }

    public void setAnimationFrame(int pTick) {
        if (this.animationContents == null || this.animationContents.animatedTexture == null) {
            return;
        }
        this.animationContents.animatedTexture.setCurrentFrame(pTick);
    }

    private static void onRenderThread(@NotNull class_4573 pRenderCall) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall((class_4573)pRenderCall);
        } else {
            pRenderCall.execute();
        }
    }

    protected class AnimationContents {
        @NotNull
        protected final class_7771 frameSize;
        @Nullable
        protected final Texture animatedTexture;

        private AnimationContents(@NotNull class_1011 pImage, class_1079 pAnimMeta) {
            this.frameSize = pAnimMeta.method_24143(pImage.method_4307(), pImage.method_4323());
            this.animatedTexture = this.generateAnimatedTexture(pImage, pAnimMeta);
        }

        private boolean isValid() {
            return this.animatedTexture != null;
        }

        @Nullable
        private Texture generateAnimatedTexture(@NotNull class_1011 pImage, @NotNull class_1079 pAnimMeta) {
            if (!class_3532.method_48117((int)pImage.method_4307(), (int)this.frameSize.comp_1049()) || !class_3532.method_48117((int)pImage.method_4323(), (int)this.frameSize.comp_1050())) {
                BaseLogger.log(BaseLogLevel.ERROR, "Image " + String.valueOf(AnimatableTexture.this.field_5224) + " size " + pImage.method_4307() + "," + pImage.method_4323() + " is not multiple of frame size " + this.frameSize.comp_1049() + "," + this.frameSize.comp_1050());
                return null;
            }
            int columns = pImage.method_4307() / this.frameSize.comp_1049();
            int rows = pImage.method_4323() / this.frameSize.comp_1050();
            int frameCount = columns * rows;
            ObjectArrayList frames = new ObjectArrayList();
            pAnimMeta.method_33460((arg_0, arg_1) -> AnimationContents.lambda$generateAnimatedTexture$0((List)frames, arg_0, arg_1));
            if (frames.isEmpty()) {
                for (int frame = 0; frame < frameCount; ++frame) {
                    frames.add(new Frame(frame, pAnimMeta.method_4684()));
                }
            } else {
                int index = 0;
                IntOpenHashSet unusedFrames = new IntOpenHashSet();
                for (Frame frame : frames) {
                    if (frame.time <= 0) {
                        BaseLogger.log(BaseLogLevel.WARNING, "Invalid frame duration on sprite " + String.valueOf(AnimatableTexture.this.field_5224) + " frame " + index + ": " + frame.time);
                        unusedFrames.add(frame.index);
                    } else if (frame.index < 0 || frame.index >= frameCount) {
                        BaseLogger.log(BaseLogLevel.WARNING, "Invalid frame index on sprite " + String.valueOf(AnimatableTexture.this.field_5224) + " frame " + index + ": " + frame.index);
                        unusedFrames.add(frame.index);
                    }
                    ++index;
                }
            }
            return frames.size() <= 1 ? null : new Texture(pImage, frames.toArray(new Frame[0]), columns, pAnimMeta.method_4685());
        }

        private static /* synthetic */ void lambda$generateAnimatedTexture$0(List frames, int frame, int frameTime) {
            frames.add(new Frame(frame, frameTime));
        }

        protected class Texture
        implements AutoCloseable {
            @NotNull
            protected final class_1011 baseImage;
            @NotNull
            protected final Frame[] frames;
            @NotNull
            protected final Integer framePanelSize;
            protected final boolean interpolating;
            @Nullable
            protected final class_1011 interpolatedFrame;
            @NotNull
            protected final Integer totalFrameTime;
            @NotNull
            protected Integer glowMaskTextureId = -1;
            @Nullable
            protected class_1011 glowmaskImage = null;
            @Nullable
            protected class_1011 glowmaskInterpolatedFrame = null;
            protected int currentFrame;
            protected int currentSubframe;

            private Texture(@NotNull class_1011 pBaseImage, @NotNull Frame[] pFrames, Integer pFramePanelSize, boolean pInterpolating) {
                this.baseImage = pBaseImage;
                this.frames = pFrames;
                this.framePanelSize = pFramePanelSize;
                this.interpolating = pInterpolating;
                this.interpolatedFrame = pInterpolating ? new class_1011(AnimationContents.this.frameSize.comp_1049(), AnimationContents.this.frameSize.comp_1050(), false) : null;
                int time = 0;
                for (Frame frame : this.frames) {
                    time += frame.time.intValue();
                }
                this.totalFrameTime = time;
            }

            private int getFrameX(@NotNull Integer pFrameIndex) {
                return pFrameIndex % this.framePanelSize;
            }

            private int getFrameY(@NotNull Integer pFrameIndex) {
                return pFrameIndex / this.framePanelSize;
            }

            public void setGlowMaskTexture(@NotNull AutoGlowingTexture pTexture, @NotNull class_1011 pBaseImage, @NotNull class_1011 pGlowMask) {
                this.glowMaskTextureId = pTexture.method_4624();
                this.glowmaskImage = pGlowMask;
                this.glowmaskInterpolatedFrame = this.interpolating ? new class_1011(AnimationContents.this.frameSize.comp_1049(), AnimationContents.this.frameSize.comp_1050(), false) : null;
                this.baseImage.method_4317(pBaseImage);
            }

            public void setCurrentFrame(int pTicks) {
                if ((pTicks %= this.totalFrameTime.intValue()) == this.currentSubframe) {
                    return;
                }
                int lastSubframe = this.currentSubframe;
                int lastFrame = this.currentFrame;
                int time = 0;
                for (Frame frame : this.frames) {
                    if (pTicks >= (time += frame.time.intValue())) continue;
                    this.currentFrame = frame.index;
                    this.currentSubframe = pTicks % frame.time;
                    break;
                }
                if (this.currentFrame != lastFrame && this.currentSubframe == 0) {
                    AnimatableTexture.onRenderThread(() -> {
                        TextureUtil.prepareImage((int)AnimatableTexture.this.method_4624(), (int)0, (int)AnimationContents.this.frameSize.comp_1049(), (int)AnimationContents.this.frameSize.comp_1050());
                        this.baseImage.method_4312(0, 0, 0, this.getFrameX(this.currentFrame) * AnimationContents.this.frameSize.comp_1049(), this.getFrameY(this.currentFrame) * AnimationContents.this.frameSize.comp_1050(), AnimationContents.this.frameSize.comp_1049(), AnimationContents.this.frameSize.comp_1050(), false, false);
                        if (this.glowmaskImage != null) {
                            TextureUtil.prepareImage((int)this.glowMaskTextureId, (int)0, (int)AnimationContents.this.frameSize.comp_1049(), (int)AnimationContents.this.frameSize.comp_1050());
                            this.glowmaskImage.method_4312(0, 0, 0, this.getFrameX(this.currentFrame) * AnimationContents.this.frameSize.comp_1049(), this.getFrameY(this.currentFrame) * AnimationContents.this.frameSize.comp_1050(), AnimationContents.this.frameSize.comp_1049(), AnimationContents.this.frameSize.comp_1050(), false, false);
                        }
                    });
                } else if (this.currentSubframe != lastSubframe && this.interpolating) {
                    AnimatableTexture.onRenderThread(() -> {
                        this.generateInterpolatedFrame(AnimatableTexture.this.method_4624(), this.baseImage, this.interpolatedFrame);
                        if (this.glowmaskImage != null) {
                            this.generateInterpolatedFrame(this.glowMaskTextureId, this.glowmaskImage, this.glowmaskInterpolatedFrame);
                        }
                    });
                }
            }

            private void generateInterpolatedFrame(@NotNull Integer pTextureId, @NotNull class_1011 pImage, @Nullable class_1011 pInterpolatedFrame) {
                if (pInterpolatedFrame == null) {
                    return;
                }
                Frame frame = this.frames[this.currentFrame];
                double frameProgress = 1.0 - (double)this.currentSubframe / (double)frame.time.intValue();
                int nextFrameIndex = this.frames[(this.currentFrame + 1) % this.frames.length].index;
                if (frame.index != nextFrameIndex) {
                    for (int y = 0; y < pInterpolatedFrame.method_4323(); ++y) {
                        for (int x = 0; x < pInterpolatedFrame.method_4307(); ++x) {
                            int prevFramePixel = this.getPixel(pImage, frame.index, x, y);
                            int nextFramePixel = this.getPixel(pImage, nextFrameIndex, x, y);
                            int blendedRed = this.interpolate(frameProgress, prevFramePixel >> 16 & 0xFF, nextFramePixel >> 16 & 0xFF);
                            int blendedGreen = this.interpolate(frameProgress, prevFramePixel >> 8 & 0xFF, nextFramePixel >> 8 & 0xFF);
                            int blendedBlue = this.interpolate(frameProgress, prevFramePixel & 0xFF, nextFramePixel & 0xFF);
                            pInterpolatedFrame.method_4305(x, y, prevFramePixel & 0xFF000000 | blendedRed << 16 | blendedGreen << 8 | blendedBlue);
                        }
                    }
                    TextureUtil.prepareImage((int)pTextureId, (int)0, (int)AnimationContents.this.frameSize.comp_1049(), (int)AnimationContents.this.frameSize.comp_1050());
                    pInterpolatedFrame.method_4312(0, 0, 0, 0, 0, AnimationContents.this.frameSize.comp_1049(), AnimationContents.this.frameSize.comp_1050(), false, false);
                }
            }

            @NotNull
            private Integer getPixel(@NotNull class_1011 pImage, @NotNull Integer pFrameIndex, @NotNull Integer pX, @NotNull Integer pY) {
                return pImage.method_4315(pX + this.getFrameX(pFrameIndex) * AnimationContents.this.frameSize.comp_1049(), pY + this.getFrameY(pFrameIndex) * AnimationContents.this.frameSize.comp_1050());
            }

            @NotNull
            private Integer interpolate(@NotNull Double pFrameProgress, @NotNull Integer pPrevColor, @NotNull Integer pNextColor) {
                return (int)(pFrameProgress * (double)pPrevColor.intValue() + (1.0 - pFrameProgress) * (double)pNextColor.intValue());
            }

            @Override
            public void close() {
                this.baseImage.close();
                if (this.interpolatedFrame != null) {
                    this.interpolatedFrame.close();
                }
                if (this.glowmaskImage != null) {
                    this.glowmaskImage.close();
                }
                if (this.glowmaskInterpolatedFrame != null) {
                    this.glowmaskInterpolatedFrame.close();
                }
            }
        }

        protected record Frame(@NotNull Integer index, @NotNull Integer time) {
        }
    }
}

