/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.cache.texture;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_1011;
import net.minecraft.class_3270;
import net.minecraft.class_3518;
import net.minecraft.class_5253;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record GlowingTextureMeta(@NotNull List<Pixel> pixels) {
    @NotNull
    public static final class_3270<GlowingTextureMeta> DESERIALIZER = new class_3270<GlowingTextureMeta>(){

        @NotNull
        public String method_14420() {
            return "glowsections";
        }

        @NotNull
        public GlowingTextureMeta fromJson(@NotNull JsonObject pJson) {
            List<Pixel> pixels = this.fromSections(class_3518.method_15292((JsonObject)pJson, (String)"sections", null));
            if (pixels.isEmpty()) {
                throw new JsonParseException("Empty glowlayer sections file. Must have at least one glow section!");
            }
            return new GlowingTextureMeta(pixels);
        }

        @NotNull
        private List<Pixel> fromSections(@Nullable JsonArray pSectionsArray) {
            if (pSectionsArray == null) {
                return List.of();
            }
            ObjectArrayList pixels = new ObjectArrayList();
            for (JsonElement pElement : pSectionsArray) {
                if (!(pElement instanceof JsonObject)) {
                    throw new JsonParseException("Invalid glowsections json format, expected a JsonObject, found: " + String.valueOf(pElement.getClass()));
                }
                JsonObject obj = (JsonObject)pElement;
                int x1 = class_3518.method_15282((JsonObject)obj, (String)"x1", (int)class_3518.method_15282((JsonObject)obj, (String)"x", (int)0));
                int y1 = class_3518.method_15282((JsonObject)obj, (String)"y1", (int)class_3518.method_15282((JsonObject)obj, (String)"y", (int)0));
                int x2 = class_3518.method_15282((JsonObject)obj, (String)"x2", (int)(class_3518.method_15282((JsonObject)obj, (String)"w", (int)0) + x1));
                int y2 = class_3518.method_15282((JsonObject)obj, (String)"y2", (int)(class_3518.method_15282((JsonObject)obj, (String)"h", (int)0) + y1));
                int alpha = class_3518.method_15282((JsonObject)obj, (String)"alpha", (int)class_3518.method_15282((JsonObject)obj, (String)"a", (int)0));
                if (x1 + y1 + x2 + y2 == 0) {
                    throw new IllegalArgumentException("Invalid glowsections section object, section must be at least one pixel in size");
                }
                for (int x = x1; x <= x2; ++x) {
                    for (int y = y1; y <= y2; ++y) {
                        pixels.add(new Pixel(x, y, alpha));
                    }
                }
            }
            return pixels;
        }
    };

    @NotNull
    public static GlowingTextureMeta fromExistingImage(@NotNull class_1011 pGlowLayer) {
        ObjectArrayList pixels = new ObjectArrayList();
        for (int x = 0; x < pGlowLayer.method_4307(); ++x) {
            for (int y = 0; y < pGlowLayer.method_4323(); ++y) {
                int color = pGlowLayer.method_4315(x, y);
                if (color == 0) continue;
                pixels.add(new Pixel(x, y, class_5253.class_8045.method_48342((int)color)));
            }
        }
        if (pixels.isEmpty()) {
            throw new IllegalStateException("Invalid glow layer texture provided, must have at least one pixel!");
        }
        return new GlowingTextureMeta((List<Pixel>)pixels);
    }

    public void createImageMask(@NotNull class_1011 pOriginalImage, @NotNull class_1011 pNewImage) {
        for (Pixel pixel : this.pixels) {
            int color = pOriginalImage.method_4315(pixel.x.intValue(), pixel.y.intValue());
            if (pixel.alpha > 0) {
                color = class_5253.class_8045.method_48344((int)pixel.alpha, (int)class_5253.class_8045.method_48347((int)color), (int)class_5253.class_8045.method_48346((int)color), (int)class_5253.class_8045.method_48345((int)color));
            }
            pNewImage.method_4305(pixel.x.intValue(), pixel.y.intValue(), color);
            pOriginalImage.method_4305(pixel.x.intValue(), pixel.y.intValue(), 0);
        }
    }

    public record Pixel(@NotNull Integer x, @NotNull Integer y, @NotNull Integer alpha) {
    }
}

