/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.json;

import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface CacheFactory<T, S> {
    @Nullable
    public T construct(@NotNull S var1);

    @Nullable
    public static <T, S, F extends CacheFactory<T, S>> T constructWithFactory(@NotNull Function<String, F> pFactoryGetter, @NotNull String pNamespace, @NotNull S pSource) {
        return ((CacheFactory)pFactoryGetter.apply(pNamespace)).construct(pSource);
    }

    public static interface Registry<T, S, F extends CacheFactory<T, S>> {
        @NotNull
        public Map<String, F> factories();

        @NotNull
        public F defaultFactory();

        @NotNull
        default public F getForNamespace(@NotNull String pNamespace) {
            return (F)((CacheFactory)this.factories().getOrDefault(pNamespace, this.defaultFactory()));
        }

        default public void register(@NotNull String pNamespace, @NotNull F pFactory) {
            this.factories().put(pNamespace, pFactory);
        }
    }
}

