/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.loader.json.deserialize.model;

import com.google.gson.JsonDeserializer;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.List;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.utils.loader.JsonUtils;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;

public record FaceUV(@Nullable String materialInstance, @NotNull List<Float> uv, @NotNull List<Float> uvSize, @NotNull Rotation uvRotation) {
    public FaceUV(@Nullable String pMaterialInstance, @NotNull List<Float> pUv, @NotNull List<Float> pUvSize) {
        this(pMaterialInstance, pUv, pUvSize, Rotation.NONE);
    }

    @NotNull
    public static JsonDeserializer<FaceUV> deserializer() throws JsonParseException {
        return (json, type, context) -> {
            JsonObject obj = json.getAsJsonObject();
            String materialInstance = JsonUtils.getOptionalString(obj, "material_instance");
            List<Float> uv = JsonUtils.jsonArrayToFloatList(JsonUtils.getOptionalJsonArray(obj, "uv"));
            List<Float> uvSize = JsonUtils.jsonArrayToFloatList(JsonUtils.getOptionalJsonArray(obj, "uv_size"));
            Rotation uvRotation = Rotation.fromValue(class_3518.method_15282((JsonObject)obj, (String)"uv_rotation", (int)0));
            return new FaceUV(materialInstance, uv, uvSize, uvRotation);
        };
    }

    public static enum Rotation {
        NONE,
        CLOCKWISE_90,
        CLOCKWISE_180,
        CLOCKWISE_270;


        @NotNull
        public static Rotation fromValue(@NotNull Integer pValue) {
            try {
                return Rotation.values()[pValue % 360 / 90];
            }
            catch (Exception pException) {
                Rotation rotation = Rotation.fromValue(class_3532.method_15375((float)((float)Math.abs(pValue) / 90.0f)) * 90);
                BaseLogger.log(BaseLogLevel.ERROR, "Invalid rotation value: " + pValue + ", defaulting to" + String.valueOf((Object)rotation), pException);
                return rotation;
            }
        }

        @NotNull
        public List<Float> rotateUvs(@NotNull Float pU, @NotNull Float pV, @NotNull Float pUWidth, @NotNull Float pVHeight) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> List.of(pU, pV, pUWidth, pV, pUWidth, pVHeight, pU, pVHeight);
                case 1 -> List.of(pUWidth, pV, pUWidth, pVHeight, pU, pVHeight, pU, pV);
                case 2 -> List.of(pUWidth, pVHeight, pU, pVHeight, pU, pV, pUWidth, pV);
                case 3 -> List.of(pU, pVHeight, pU, pV, pUWidth, pV, pUWidth, pVHeight);
            };
        }
    }
}

