/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.markdown;

import java.util.function.BiConsumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bluelib.api.utils.QuadConsumer;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.internal.BlueTranslation;

public abstract class MarkdownFeature {
    @Nullable
    protected String prefix;
    @Nullable
    protected String suffix;

    @NotNull
    public class_5250 apply(@NotNull class_5250 pComponent) {
        if (!this.isFeatureEnabled().booleanValue()) {
            BaseLogger.log((Boolean)true, BaseLogLevel.INFO, BlueTranslation.log("markdown.feature.disabled", this.getFeatureName()));
            return pComponent;
        }
        if (this.prefix == null || this.suffix == null) {
            BaseLogger.log((Boolean)true, BaseLogLevel.WARNING, BlueTranslation.log("markdown.feature.prefix_suffix_not_set", this.getFeatureName()));
            return pComponent;
        }
        Pattern pattern = Pattern.compile(Pattern.quote(this.prefix) + "(.*?)" + Pattern.quote(this.suffix));
        class_5250 result = class_2561.method_43473();
        if (pComponent.method_10855().isEmpty()) {
            this.processComponentTextWithFormatting(pComponent.getString(), pComponent.method_10866(), result, pattern);
        } else {
            result = this.processSiblingsWithFormatting(pComponent, pattern);
        }
        return result;
    }

    protected void processComponentText(@NotNull String pText, @NotNull class_2583 pOriginalStyle, @NotNull class_5250 pResult, @NotNull Pattern pPattern, @NotNull BiConsumer<Matcher, class_5250> pSpecialTextHandler) {
        Matcher matcher = pPattern.matcher(pText);
        int lastIndex = 0;
        while (matcher.find()) {
            if (matcher.group(1).isEmpty()) {
                this.appendUnstyledText(pText.substring(lastIndex, matcher.end()), pResult, pOriginalStyle);
            } else if (matcher.start() > 0 && pText.charAt(matcher.start() - 1) == '\\') {
                this.appendUnstyledText(pText.substring(lastIndex, matcher.start() - 1), pResult, pOriginalStyle);
                this.appendUnstyledText(matcher.group(0), pResult, pOriginalStyle);
            } else {
                this.appendUnstyledText(pText.substring(lastIndex, matcher.start()), pResult, pOriginalStyle);
                pSpecialTextHandler.accept(matcher, pResult);
            }
            lastIndex = matcher.end();
        }
        this.appendUnstyledText(pText.substring(lastIndex), pResult, pOriginalStyle);
    }

    protected void processComponentTextWithFormatting(@NotNull String pText, @NotNull class_2583 pOriginalStyle, @NotNull class_5250 pResult, @NotNull Pattern pPattern) {
        this.processComponentText(pText, pOriginalStyle, pResult, pPattern, (matcher, res) -> this.appendFormattedText(matcher.group(1), pOriginalStyle, (class_5250)res));
    }

    @NotNull
    protected class_5250 processSiblings(@NotNull class_5250 pComponent, @NotNull Pattern pPattern, @NotNull QuadConsumer<String, class_2583, class_5250, Pattern> pSiblingProcessor) {
        class_5250 result = class_2561.method_43473();
        for (class_2561 sibling : pComponent.method_10855()) {
            if (sibling instanceof class_5250) {
                class_5250 mutableSibling = (class_5250)sibling;
                pSiblingProcessor.accept(mutableSibling.getString(), mutableSibling.method_10866(), result, pPattern);
                continue;
            }
            result.method_10852(sibling);
        }
        return result;
    }

    @NotNull
    protected class_5250 processSiblingsWithFormatting(@NotNull class_5250 pComponent, @NotNull Pattern pPattern) {
        return this.processSiblings(pComponent, pPattern, this::processComponentTextWithFormatting);
    }

    protected void appendFormattedText(@NotNull String pText, @NotNull class_2583 pStyle, @NotNull class_5250 pResult) {
        pResult.method_10852((class_2561)class_2561.method_43470((String)pText).method_10862(pStyle));
    }

    protected void appendUnstyledText(@NotNull String pText, @NotNull class_5250 pResult, @NotNull class_2583 pOriginalStyle) {
        pResult.method_10852((class_2561)class_2561.method_43470((String)pText).method_10862(pOriginalStyle));
    }

    @NotNull
    protected abstract Boolean isFeatureEnabled();

    @NotNull
    protected abstract String getFeatureName();
}

