/*
 * Decompiled with CFR 0.152.
 */
package software.bluelib.markdown.syntax;

import java.util.regex.Pattern;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.jetbrains.annotations.NotNull;
import software.bluelib.api.utils.IsValidUtils;
import software.bluelib.api.utils.logging.BaseLogLevel;
import software.bluelib.api.utils.logging.BaseLogger;
import software.bluelib.config.MarkdownConfig;
import software.bluelib.internal.BlueTranslation;
import software.bluelib.markdown.MarkdownFeature;

public class Hyperlink
extends MarkdownFeature {
    @Override
    @NotNull
    public class_5250 apply(@NotNull class_5250 pComponent) {
        if (!MarkdownConfig.isHyperlinkEnabled) {
            BaseLogger.log((Boolean)true, BaseLogLevel.INFO, BlueTranslation.log("markdown.hyperlink.disabled"));
            return pComponent;
        }
        Pattern pattern = Pattern.compile(Pattern.quote(MarkdownConfig.hyperlinkPrefix) + "(.*?)" + Pattern.quote(MarkdownConfig.hyperlinkSuffix) + "\\((.*?)\\)");
        class_5250 result = class_2561.method_43473();
        if (pComponent.method_10855().isEmpty()) {
            this.processComponentTextWithHyperlinks(pComponent.getString(), pComponent.method_10866(), result, pattern);
        } else {
            result = this.processSiblingsWithHyperlinks(pComponent, pattern);
        }
        return result;
    }

    protected void processComponentTextWithHyperlinks(@NotNull String pText, @NotNull class_2583 pOriginalStyle, @NotNull class_5250 pResult, @NotNull Pattern pPattern) {
        this.processComponentText(pText, pOriginalStyle, pResult, pPattern, (matcher, res) -> {
            String url = matcher.group(2);
            if (url != null && !url.isEmpty()) {
                this.appendHyperlink(matcher.group(1), url, pOriginalStyle, (class_5250)res);
            }
        });
    }

    @NotNull
    public class_5250 processSiblingsWithHyperlinks(@NotNull class_5250 pComponent, @NotNull Pattern pPattern) {
        return this.processSiblings(pComponent, pPattern, this::processComponentTextWithHyperlinks);
    }

    private void appendHyperlink(@NotNull String pText, @NotNull String pUrl, @NotNull class_2583 pOriginalStyle, @NotNull class_5250 pResult) {
        if (!IsValidUtils.isValidURL(pUrl).booleanValue()) {
            pResult.method_10852((class_2561)class_2561.method_43470((String)(MarkdownConfig.hyperlinkPrefix + pText + MarkdownConfig.hyperlinkSuffix + "(" + pUrl + ")")).method_10862(pOriginalStyle));
            return;
        }
        class_5250 hyperlink = class_2561.method_43470((String)pText).method_10862(pOriginalStyle.method_27703(class_5251.method_27717((int)2056161)).method_30938(Boolean.valueOf(true)).method_10958(new class_2558(class_2558.class_2559.field_11749, pUrl)));
        pResult.method_10852((class_2561)hyperlink);
    }

    @Override
    @NotNull
    protected Boolean isFeatureEnabled() {
        return MarkdownConfig.isHyperlinkEnabled;
    }

    @Override
    @NotNull
    protected String getFeatureName() {
        return "Hyperlink";
    }
}

