/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.event.IModBusEvent;
import org.apache.logging.log4j.Logger;
import yesman.epicfight.api.animation.AnimationClip;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.asset.JsonAssetLoader;
import yesman.epicfight.api.client.animation.AnimationSubFileReader;
import yesman.epicfight.api.data.reloader.SkillReloadListener;
import yesman.epicfight.api.exception.AssetLoadingException;
import yesman.epicfight.api.utils.InstantiateInvoker;
import yesman.epicfight.api.utils.MutableBoolean;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.main.EpicFightSharedConstants;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPPairingAnimationRegistry;
import yesman.epicfight.network.server.SPDatapackSync;

public class AnimationManager
extends SimpleJsonResourceReloadListener {
    private static final AnimationManager INSTANCE = new AnimationManager();
    private static ResourceManager serverResourceManager = null;
    private final Map<Integer, AnimationAccessor<? extends StaticAnimation>> animationById = new HashMap<Integer, AnimationAccessor<? extends StaticAnimation>>();
    private final Map<ResourceLocation, AnimationAccessor<? extends StaticAnimation>> animationByName = new HashMap<ResourceLocation, AnimationAccessor<? extends StaticAnimation>>();
    private final Map<AnimationAccessor<? extends StaticAnimation>, StaticAnimation> animations = new HashMap<AnimationAccessor<? extends StaticAnimation>, StaticAnimation>();
    private final Map<AnimationAccessor<? extends StaticAnimation>, String> resourcepackAnimationCommands = new HashMap<AnimationAccessor<? extends StaticAnimation>, String>();
    private static final Set<String> NO_WARNING_MODID = Sets.newHashSet();

    public static AnimationManager getInstance() {
        return INSTANCE;
    }

    public AnimationManager() {
        super(new GsonBuilder().create(), "animmodels/animations");
    }

    public static boolean checkNonNull(AssetAccessor<? extends StaticAnimation> animation) {
        if (animation == null || animation.isEmpty()) {
            if (animation != null) {
                EpicFightMod.stacktraceIfDevSide("Empty animation accessor: " + String.valueOf(animation.registryName()), NoSuchElementException::new);
            } else {
                EpicFightMod.stacktraceIfDevSide("Null animation accessor", NoSuchElementException::new);
            }
            return false;
        }
        return true;
    }

    public static <T extends StaticAnimation> AnimationAccessor<T> byKey(String registryName) {
        return AnimationManager.byKey(ResourceLocation.parse((String)registryName));
    }

    public static <T extends StaticAnimation> AnimationAccessor<T> byKey(ResourceLocation registryName) {
        return AnimationManager.getInstance().animationByName.get(registryName);
    }

    public static <T extends StaticAnimation> AnimationAccessor<T> byId(int animationId) {
        return AnimationManager.getInstance().animationById.get(animationId);
    }

    public Map<ResourceLocation, AnimationAccessor<? extends StaticAnimation>> getAnimations(Predicate<AssetAccessor<? extends StaticAnimation>> filter) {
        Map<ResourceLocation, AnimationAccessor> filteredItems = this.animationByName.entrySet().stream().filter(entry -> filter.test((AssetAccessor)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return ImmutableMap.copyOf(filteredItems);
    }

    public AnimationClip loadAnimationClip(StaticAnimation animation, BiFunction<JsonAssetLoader, StaticAnimation, AnimationClip> clipLoader) {
        try {
            if (AnimationManager.getAnimationResourceManager() == null) {
                return null;
            }
            JsonAssetLoader modelLoader = new JsonAssetLoader(AnimationManager.getAnimationResourceManager(), animation.getLocation());
            AnimationClip loadedClip = clipLoader.apply(modelLoader, animation);
            return loadedClip;
        }
        catch (AssetLoadingException e) {
            throw new AssetLoadingException("Failed to load animation clip from: " + String.valueOf(animation), e);
        }
    }

    public static void readAnimationProperties(StaticAnimation animation) {
        ResourceLocation dataLocation = AnimationManager.getSubAnimationFileLocation(animation.getLocation(), AnimationSubFileReader.SUBFILE_CLIENT_PROPERTY);
        ResourceLocation povLocation = AnimationManager.getSubAnimationFileLocation(animation.getLocation(), AnimationSubFileReader.SUBFILE_POV_ANIMATION);
        AnimationManager.getAnimationResourceManager().getResource(dataLocation).ifPresent(rs -> AnimationSubFileReader.readAndApply(animation, rs, AnimationSubFileReader.SUBFILE_CLIENT_PROPERTY));
        AnimationManager.getAnimationResourceManager().getResource(povLocation).ifPresent(rs -> AnimationSubFileReader.readAndApply(animation, rs, AnimationSubFileReader.SUBFILE_POV_ANIMATION));
    }

    protected Map<ResourceLocation, JsonElement> prepare(ResourceManager resourceManager, ProfilerFiller profilerIn) {
        if (!EpicFightSharedConstants.isPhysicalClient() && serverResourceManager == null) {
            serverResourceManager = resourceManager;
        }
        this.animations.clear();
        this.animationById.entrySet().removeIf(entry -> !((AnimationAccessor)entry.getValue()).inRegistry());
        this.animationByName.entrySet().removeIf(entry -> !((AnimationAccessor)entry.getValue()).inRegistry());
        this.resourcepackAnimationCommands.clear();
        return super.prepare(resourceManager, profilerIn);
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManager, ProfilerFiller profilerIn) {
        Armatures.reload(resourceManager);
        Set registeredAnimation = this.animationById.values().stream().reduce(Sets.newHashSet(), (set, accessor) -> {
            set.add(accessor.registryName());
            for (AssetAccessor<? extends StaticAnimation> subAnimAccessor : ((StaticAnimation)accessor.get()).getSubAnimations()) {
                set.add(subAnimAccessor.registryName());
            }
            return set;
        }, (set1, set2) -> {
            set1.addAll(set2);
            return set1;
        });
        objectIn.entrySet().stream().filter(entry -> !registeredAnimation.contains(entry.getKey()) && !((ResourceLocation)entry.getKey()).getPath().contains("/data/") && !((ResourceLocation)entry.getKey()).getPath().contains("/pov/")).sorted((e1, e2) -> ((ResourceLocation)e1.getKey()).toString().compareTo(((ResourceLocation)e2.getKey()).toString())).forEach(entry -> {
            try {
                this.readResourcepackAnimation((ResourceLocation)entry.getKey(), ((JsonElement)entry.getValue()).getAsJsonObject());
            }
            catch (Exception e) {
                EpicFightMod.LOGGER.error("Failed to load User animation " + String.valueOf(entry.getKey()) + " because of " + String.valueOf(e) + ". Skipped.");
                e.printStackTrace();
            }
        });
        SkillReloadListener.reloadAllSkillsAnimations();
        this.animations.entrySet().stream().reduce(Lists.newArrayList(), (list, entry) -> {
            MutableBoolean init = new MutableBoolean(true);
            if (entry.getValue() == null || ((StaticAnimation)entry.getValue()).getAccessor() == null) {
                EpicFightMod.logAndStacktraceIfDevSide(Logger::error, "Invalid animation implementation: " + String.valueOf(entry.getKey()), AssetLoadingException::new);
                init.set(false);
            }
            ((StaticAnimation)entry.getValue()).getSubAnimations().forEach(subAnimation -> {
                if (subAnimation == null || subAnimation.get() == null) {
                    EpicFightMod.logAndStacktraceIfDevSide(Logger::error, "Invalid sub animation implementation: " + String.valueOf(entry.getKey()), AssetLoadingException::new);
                    init.set(false);
                }
            });
            if (init.value()) {
                list.add(((StaticAnimation)entry.getValue()).getAccessor());
                list.addAll(((StaticAnimation)entry.getValue()).getSubAnimations());
            }
            return list;
        }, (list1, list2) -> {
            list1.addAll(list2);
            return list1;
        }).forEach(accessor -> {
            accessor.doOrThrow(StaticAnimation::postInit);
            if (EpicFightSharedConstants.isPhysicalClient()) {
                AnimationManager.readAnimationProperties((StaticAnimation)accessor.get());
            }
        });
    }

    public static ResourceLocation getSubAnimationFileLocation(ResourceLocation location, AnimationSubFileReader.SubFileType<?> subFileType) {
        int splitIdx = location.getPath().lastIndexOf(47);
        if (splitIdx < 0) {
            splitIdx = 0;
        }
        return ResourceLocation.fromNamespaceAndPath((String)location.getNamespace(), (String)String.format("%s/" + subFileType.getDirectory() + "%s", location.getPath().substring(0, splitIdx), location.getPath().substring(splitIdx)));
    }

    public static void setServerResourceManager(ResourceManager pResourceManager) {
        serverResourceManager = pResourceManager;
    }

    public static ResourceManager getAnimationResourceManager() {
        return EpicFightSharedConstants.isPhysicalClient() ? Minecraft.getInstance().getResourceManager() : serverResourceManager;
    }

    public Stream<CompoundTag> getResourcepackAnimationStream() {
        return this.resourcepackAnimationCommands.entrySet().stream().map(entry -> {
            CompoundTag compTag = new CompoundTag();
            compTag.putString("registry_name", ((AnimationAccessor)entry.getKey()).registryName().toString());
            compTag.putInt("id", ((AnimationAccessor)entry.getKey()).id());
            compTag.putString("invoke_command", (String)entry.getValue());
            return compTag;
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public void processServerPacket(SPDatapackSync packet, boolean mandatoryPack) {
        if (mandatoryPack) {
            for (CompoundTag tag : packet.tags()) {
                String invocationCommand = tag.getString("invoke_command");
                ResourceLocation registryName = ResourceLocation.parse((String)tag.getString("registry_name"));
                int id = tag.getInt("id");
                if (this.animationByName.containsKey(registryName)) continue;
                AnimationAccessor<StaticAnimation> accessor = AnimationAccessorImpl.create(registryName, this.resourcepackAnimationCommands.size(), false, accessor$2 -> {
                    try {
                        return InstantiateInvoker.invoke(invocationCommand, StaticAnimation.class).getResult();
                    }
                    catch (Exception e) {
                        EpicFightMod.LOGGER.warn("Failed at creating animation from server resource pack");
                        e.printStackTrace();
                        return Animations.EMPTY_ANIMATION;
                    }
                });
                this.animationById.put(id, accessor);
                this.animationByName.put(registryName, accessor);
            }
        }
        int animationCount = this.animations.size();
        ArrayList registryNames = Lists.newArrayList();
        for (int i = 0; i < animationCount; ++i) {
            registryNames.add(this.animationById.get(i + 1).registryName().toString());
        }
        CPPairingAnimationRegistry registrySyncPacket = new CPPairingAnimationRegistry(registryNames);
        EpicFightNetworkManager.sendToServer(registrySyncPacket, new CustomPacketPayload[0]);
    }

    public void validateClientAnimationRegistry(CPPairingAnimationRegistry msg, ServerGamePacketListenerImpl connection) {
        StringBuilder messageBuilder = new StringBuilder();
        int count = 0;
        HashSet<String> clientAnimationRegistry = new HashSet<String>(Set.copyOf(msg.registryNames()));
        for (String registryName : this.animations.keySet().stream().map(rl -> rl.toString()).toList()) {
            if (!clientAnimationRegistry.contains(registryName)) {
                if (count < 10) {
                    messageBuilder.append(registryName);
                    messageBuilder.append("\n");
                }
                ++count;
                continue;
            }
            clientAnimationRegistry.remove(registryName);
        }
        for (String registryName : clientAnimationRegistry) {
            if (registryName.equals("empty")) continue;
            if (count < 10) {
                messageBuilder.append(registryName);
                messageBuilder.append("\n");
            }
            ++count;
        }
        if (count >= 10) {
            messageBuilder.append(Component.translatable((String)"gui.epicfight.warn.animation_unsync.etc", (Object[])new Object[]{count - 9}).getString());
            messageBuilder.append("\n");
        }
        if (!messageBuilder.isEmpty()) {
            connection.disconnect((Component)Component.translatable((String)"gui.epicfight.warn.animation_unsync", (Object[])new Object[]{messageBuilder.toString()}));
        }
    }

    public static void addNoWarningModId(String modid) {
        NO_WARNING_MODID.add(modid);
    }

    private void readResourcepackAnimation(ResourceLocation rl, JsonObject json) throws Exception {
        JsonElement constructorElement = json.get("constructor");
        if (constructorElement == null) {
            if (NO_WARNING_MODID.contains(rl.getNamespace())) {
                return;
            }
            EpicFightMod.logAndStacktraceIfDevSide(Logger::error, "Datapack animation reading failed: No constructor information has provided: " + String.valueOf(rl), IllegalStateException::new, "No constructor information has provided in User animation, " + String.valueOf(rl) + "\nPlease remove this resource if it's unnecessary to optimize your project.");
            return;
        }
        JsonObject constructorObject = constructorElement.getAsJsonObject();
        String invocationCommand = constructorObject.get("invocation_command").getAsString();
        StaticAnimation animation = InstantiateInvoker.invoke(invocationCommand, StaticAnimation.class).getResult();
        JsonElement propertiesElement = json.getAsJsonObject().get("properties");
        if (propertiesElement != null) {
            JsonObject propertiesObject = propertiesElement.getAsJsonObject();
            for (Map.Entry entry : propertiesObject.entrySet()) {
                AnimationProperty propertyKey = AnimationProperty.getSerializableProperty((String)entry.getKey());
                Object value = propertyKey.parseFrom((JsonElement)entry.getValue());
                animation.addPropertyUnsafe(propertyKey, value);
            }
        }
        AnimationAccessor accessor = AnimationAccessorImpl.create(rl, this.animations.size() + 1, false, null);
        animation.setAccessor(accessor);
        this.resourcepackAnimationCommands.put(accessor, invocationCommand);
        this.animationById.put(accessor.id(), accessor);
        this.animationByName.put(accessor.registryName(), accessor);
        this.animations.put(accessor, animation);
    }

    public static interface AnimationAccessor<A extends DynamicAnimation>
    extends AssetAccessor<A> {
        public int id();

        default public boolean idBetween(AnimationAccessor<? extends StaticAnimation> a1, AnimationAccessor<? extends StaticAnimation> a2) {
            return a1.id() <= this.id() && a2.id() >= this.id();
        }
    }

    public record AnimationAccessorImpl<A extends StaticAnimation>(ResourceLocation registryName, int id, boolean inRegistry, Function<AnimationAccessor<A>, A> onLoad) implements AnimationAccessor<A>
    {
        private static <A extends StaticAnimation> AnimationAccessor<A> create(ResourceLocation registryName, int id, boolean inRegistry, Function<AnimationAccessor<A>, A> onLoad) {
            return new AnimationAccessorImpl<A>(registryName, id, inRegistry, onLoad);
        }

        @Override
        public A get() {
            if (!AnimationManager.INSTANCE.animations.containsKey(this)) {
                AnimationManager.INSTANCE.animations.put(this, (StaticAnimation)this.onLoad.apply(this));
            }
            return (A)AnimationManager.INSTANCE.animations.get(this);
        }

        @Override
        public String toString() {
            return this.registryName.toString();
        }

        @Override
        public int hashCode() {
            return this.registryName.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof AnimationAccessor) {
                AnimationAccessor armatureAccessor = (AnimationAccessor)obj;
                return this.registryName.equals((Object)armatureAccessor.registryName());
            }
            if (obj instanceof ResourceLocation) {
                ResourceLocation rl = (ResourceLocation)obj;
                return this.registryName.equals((Object)rl);
            }
            if (obj instanceof String) {
                String name = (String)obj;
                return this.registryName.toString().equals(name);
            }
            return false;
        }
    }

    public record AnimationBuilder(String namespace, Consumer<AnimationBuilder> task) {
        public <T extends StaticAnimation> AnimationAccessor<T> nextAccessor(String id, Function<AnimationAccessor<T>, T> onLoad) {
            AnimationAccessor<T> accessor = AnimationAccessorImpl.create(ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)id), AnimationManager.INSTANCE.animations.size() + 1, true, onLoad);
            AnimationManager.INSTANCE.animationById.put(accessor.id(), accessor);
            AnimationManager.INSTANCE.animationByName.put(accessor.registryName(), accessor);
            AnimationManager.INSTANCE.animations.put(accessor, null);
            return accessor;
        }
    }

    public static class AnimationRegistryEvent
    extends Event
    implements IModBusEvent {
        private List<AnimationBuilder> builders = Lists.newArrayList();
        private Set<String> namespaces = Sets.newHashSet();

        public void newBuilder(String namespace, Consumer<AnimationBuilder> build) {
            if (this.namespaces.contains(namespace)) {
                throw new IllegalArgumentException("Animation builder namespace '" + namespace + "' already exists!");
            }
            this.namespaces.add(namespace);
            this.builders.add(new AnimationBuilder(namespace, build));
        }

        public List<AnimationBuilder> getBuilders() {
            return this.builders;
        }
    }
}

