/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation;

import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.LinkAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class ServerAnimator
extends Animator {
    private final LinkAnimation linkAnimation = new LinkAnimation();
    public final AnimationPlayer animationPlayer = new AnimationPlayer();
    protected AssetAccessor<? extends DynamicAnimation> nextAnimation;
    public boolean hardPaused = false;
    public boolean softPaused = false;

    public static Animator getAnimator(LivingEntityPatch<?> entitypatch) {
        return new ServerAnimator(entitypatch);
    }

    public ServerAnimator(LivingEntityPatch<?> entitypatch) {
        super(entitypatch);
    }

    @Override
    public void playAnimation(AssetAccessor<? extends StaticAnimation> nextAnimation, float transitionTimeModifier) {
        this.softPaused = false;
        Pose lastPose = this.animationPlayer.getAnimation().get().getPoseByTime(this.entitypatch, 0.0f, 0.0f);
        if (!this.animationPlayer.isEnd()) {
            this.animationPlayer.getAnimation().get().end(this.entitypatch, nextAnimation, false);
        }
        nextAnimation.get().begin(this.entitypatch);
        if (!nextAnimation.get().isMetaAnimation()) {
            nextAnimation.get().setLinkAnimation(this.animationPlayer.getAnimation(), lastPose, true, transitionTimeModifier, this.entitypatch, this.linkAnimation);
            this.linkAnimation.putOnPlayer(this.animationPlayer, this.entitypatch);
            this.entitypatch.updateEntityState();
            this.nextAnimation = nextAnimation;
        }
    }

    @Override
    public void playAnimationInstantly(AssetAccessor<? extends StaticAnimation> nextAnimation) {
        this.softPaused = false;
        if (!this.animationPlayer.isEnd()) {
            this.animationPlayer.getAnimation().get().end(this.entitypatch, nextAnimation, false);
        }
        nextAnimation.get().begin(this.entitypatch);
        nextAnimation.get().putOnPlayer(this.animationPlayer, this.entitypatch);
        this.entitypatch.updateEntityState();
    }

    @Override
    public void reserveAnimation(AssetAccessor<? extends StaticAnimation> nextAnimation) {
        this.softPaused = false;
        this.nextAnimation = nextAnimation;
    }

    @Override
    public boolean stopPlaying(AssetAccessor<? extends StaticAnimation> targetAnimation) {
        if (this.animationPlayer.getRealAnimation() == targetAnimation) {
            this.animationPlayer.terminate(this.entitypatch);
            return true;
        }
        return false;
    }

    @Override
    public void playShootingAnimation() {
    }

    @Override
    public void tick() {
        if (this.hardPaused || this.softPaused) {
            this.entitypatch.updateEntityState();
            return;
        }
        this.animationPlayer.tick(this.entitypatch);
        this.entitypatch.updateEntityState();
        if (this.animationPlayer.isEnd()) {
            if (this.nextAnimation == null) {
                Animations.EMPTY_ANIMATION.putOnPlayer(this.animationPlayer, this.entitypatch);
                this.softPaused = true;
            } else {
                if (!this.animationPlayer.getAnimation().get().isLinkAnimation() && !this.nextAnimation.get().isLinkAnimation()) {
                    this.nextAnimation.get().begin(this.entitypatch);
                }
                this.nextAnimation.get().putOnPlayer(this.animationPlayer, this.entitypatch);
                this.nextAnimation = null;
            }
        } else {
            this.animationPlayer.getAnimation().get().tick(this.entitypatch);
        }
    }

    @Override
    public Pose getPose(float partialTicks) {
        return this.animationPlayer.getCurrentPose(this.entitypatch, partialTicks);
    }

    @Override
    public AnimationPlayer getPlayerFor(AssetAccessor<? extends DynamicAnimation> playingAnimation) {
        return this.animationPlayer;
    }

    @Override
    public Optional<AnimationPlayer> getPlayer(AssetAccessor<? extends DynamicAnimation> playingAnimation) {
        if (this.animationPlayer.getRealAnimation() == playingAnimation.get().getRealAnimation()) {
            return Optional.of(this.animationPlayer);
        }
        return Optional.empty();
    }

    @Override
    public <T> Pair<AnimationPlayer, T> findFor(Class<T> animationType) {
        return animationType.isAssignableFrom(this.animationPlayer.getAnimation().getClass()) ? Pair.of((Object)this.animationPlayer, this.animationPlayer.getAnimation()) : null;
    }

    @Override
    public EntityState getEntityState() {
        return this.animationPlayer.getAnimation().get().getState(this.entitypatch, this.animationPlayer.getElapsedTime());
    }

    @Override
    public void setSoftPause(boolean paused) {
        this.softPaused = paused;
    }

    @Override
    public void setHardPause(boolean paused) {
        this.hardPaused = paused;
    }

    @Override
    public boolean isPlaying(AssetAccessor<? extends DynamicAnimation> animation) {
        return this.animationPlayer.getRealAnimation().equals(animation);
    }
}

