/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.world.damagesource.DamageSource;
import net.neoforged.neoforge.event.entity.ProjectileImpactEvent;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.datastructure.ParameterizedHashMap;
import yesman.epicfight.api.utils.datastructure.ParameterizedMap;

public class EntityState {
    public static final EntityState DEFAULT_STATE = new EntityState(new ParameterizedHashMap());
    public static final StateFactor<Boolean> TURNING_LOCKED = new StateFactor<Boolean>("turningLocked", false);
    public static final StateFactor<Boolean> MOVEMENT_LOCKED = new StateFactor<Boolean>("movementLocked", false);
    public static final StateFactor<Boolean> ATTACKING = new StateFactor<Boolean>("attacking", false);
    public static final StateFactor<Boolean> COMBO_ATTACKS_DOABLE = new StateFactor<Boolean>("comboAttacksDoable", true);
    public static final StateFactor<Boolean> SKILL_EXECUTABLE = new StateFactor<Boolean>("skillExecutable", true);
    public static final StateFactor<Boolean> CAN_USE_ITEM = new StateFactor<Boolean>("canUseItem", true);
    public static final StateFactor<Boolean> CAN_SWITCH_HAND_ITEM = new StateFactor<Boolean>("canSwitchHandItem", true);
    public static final StateFactor<Boolean> INACTION = new StateFactor<Boolean>("takingAction", false);
    public static final StateFactor<Boolean> KNOCKDOWN = new StateFactor<Boolean>("knockdown", false);
    public static final StateFactor<Boolean> LOOK_TARGET = new StateFactor<Boolean>("lookTarget", false);
    public static final StateFactor<Boolean> UPDATE_LIVING_MOTION = new StateFactor<Boolean>("updateLivingMotion", true);
    public static final StateFactor<Integer> HURT_LEVEL = new StateFactor<Integer>("hurtLevel", 0);
    public static final StateFactor<Integer> PHASE_LEVEL = new StateFactor<Integer>("phaseLevel", 0);
    public static final StateFactor<Function<DamageSource, AttackResult.ResultType>> ATTACK_RESULT = new StateFactor<Function<DamageSource, AttackResult.ResultType>>("attackResultModifier", damagesource -> AttackResult.ResultType.SUCCESS);
    public static final StateFactor<Consumer<ProjectileImpactEvent>> PROJECTILE_IMPACT_RESULT = new StateFactor<Consumer<ProjectileImpactEvent>>("projectileImpactResult", event -> {});
    private final ParameterizedHashMap<StateFactor<?>> stateMap;

    public EntityState(ParameterizedHashMap<StateFactor<?>> states) {
        this.stateMap = states;
    }

    public <T> T getState(StateFactor<T> stateFactor) {
        return this.stateMap.getOrDefault(stateFactor);
    }

    public ParameterizedHashMap<StateFactor<?>> getStateMap() {
        return this.stateMap;
    }

    public boolean turningLocked() {
        return this.getState(TURNING_LOCKED);
    }

    public boolean movementLocked() {
        return this.getState(MOVEMENT_LOCKED);
    }

    public boolean attacking() {
        return this.getState(ATTACKING);
    }

    public AttackResult.ResultType attackResult(DamageSource damagesource) {
        return this.getState(ATTACK_RESULT).apply(damagesource);
    }

    public void setProjectileImpactResult(ProjectileImpactEvent event) {
        this.getState(PROJECTILE_IMPACT_RESULT).accept(event);
    }

    public boolean canBasicAttack() {
        return this.getState(COMBO_ATTACKS_DOABLE);
    }

    public boolean canUseSkill() {
        return this.getState(SKILL_EXECUTABLE);
    }

    public boolean canUseItem() {
        return this.canUseSkill() && this.getState(CAN_USE_ITEM) != false;
    }

    public boolean canSwitchHoldingItem() {
        return !this.inaction() && this.getState(CAN_SWITCH_HAND_ITEM) != false;
    }

    public boolean inaction() {
        return this.getState(INACTION);
    }

    public boolean updateLivingMotion() {
        return this.getState(UPDATE_LIVING_MOTION);
    }

    public boolean hurt() {
        return this.getState(HURT_LEVEL) > 0;
    }

    public int hurtLevel() {
        return this.getState(HURT_LEVEL);
    }

    public boolean knockDown() {
        return this.getState(KNOCKDOWN);
    }

    public boolean lookTarget() {
        return this.getState(LOOK_TARGET);
    }

    public int getLevel() {
        return this.getState(PHASE_LEVEL);
    }

    public String toString() {
        return this.stateMap.toString();
    }

    public static class StateFactor<T>
    implements ParameterizedMap.ParameterizedKey<T> {
        private final String name;
        private final T defaultValue;

        public StateFactor(String name, T defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public T defaultValue() {
            return this.defaultValue;
        }
    }
}

