/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import java.util.HashSet;
import java.util.Map;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.LinkAnimation;
import yesman.epicfight.api.animation.types.MainFrameAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class HitAnimation
extends MainFrameAnimation {
    public HitAnimation(float transitionTime, AnimationManager.AnimationAccessor<? extends HitAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        super(transitionTime, accessor, armature);
        this.stateSpectrumBlueprint.clear().newTimePair(0.0f, Float.MAX_VALUE).addState(EntityState.TURNING_LOCKED, true).addState(EntityState.MOVEMENT_LOCKED, true).addState(EntityState.UPDATE_LIVING_MOTION, false).addState(EntityState.COMBO_ATTACKS_DOABLE, false).addState(EntityState.SKILL_EXECUTABLE, false).addState(EntityState.INACTION, true).addState(EntityState.HURT_LEVEL, 1);
    }

    public HitAnimation(float transitionTime, String path, AssetAccessor<? extends Armature> armature) {
        super(transitionTime, path, armature);
        this.stateSpectrumBlueprint.clear().newTimePair(0.0f, Float.MAX_VALUE).addState(EntityState.TURNING_LOCKED, true).addState(EntityState.MOVEMENT_LOCKED, true).addState(EntityState.UPDATE_LIVING_MOTION, false).addState(EntityState.COMBO_ATTACKS_DOABLE, false).addState(EntityState.SKILL_EXECUTABLE, false).addState(EntityState.INACTION, true).addState(EntityState.HURT_LEVEL, 1);
    }

    @Override
    public void begin(LivingEntityPatch<?> entitypatch) {
        entitypatch.cancelItemUse();
        super.begin(entitypatch);
    }

    @Override
    public void setLinkAnimation(AssetAccessor<? extends DynamicAnimation> fromAnimation, Pose startPose, boolean isOnSameLayer, float transitionTimeModifier, LivingEntityPatch<?> entitypatch, LinkAnimation dest) {
        dest.resetNextStartTime();
        dest.getTransfroms().clear();
        dest.setTotalTime(transitionTimeModifier + this.transitionTime);
        dest.setConnectedAnimations(fromAnimation, this.getAccessor());
        Map<String, JointTransform> data1 = startPose.getJointTransformData();
        Map<String, JointTransform> data2 = super.getPoseByTime(entitypatch, 0.0f, 0.0f).getJointTransformData();
        Map<String, JointTransform> data3 = super.getPoseByTime(entitypatch, this.getTotalTime(), 0.0f).getJointTransformData();
        HashSet<String> joint1 = new HashSet<String>(data1.keySet());
        joint1.removeIf(jointName -> !((DynamicAnimation)fromAnimation.get()).hasTransformFor((String)jointName));
        HashSet<String> joint2 = new HashSet<String>(data2.keySet());
        joint2.removeIf(jointName -> !this.hasTransformFor((String)jointName));
        joint1.addAll(joint2);
        for (String jointName2 : joint1) {
            if (!data1.containsKey(jointName2) || !data2.containsKey(jointName2)) continue;
            Keyframe[] keyframes = new Keyframe[]{new Keyframe(0.0f, data1.get(jointName2)), new Keyframe(this.transitionTime, data2.get(jointName2)), new Keyframe(this.transitionTime + 0.033f, data3.get(jointName2)), new Keyframe(transitionTimeModifier + this.transitionTime, data3.get(jointName2))};
            TransformSheet sheet = new TransformSheet(keyframes);
            dest.getAnimationClip().addJointTransform(jointName2, sheet);
        }
    }

    @Override
    public Pose getPoseByTime(LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
        return super.getPoseByTime(entitypatch, this.getTotalTime() - 1.0E-6f, 0.0f);
    }
}

