/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationClip;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Keyframe;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.TransformSheet;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.property.JointMaskEntry;
import yesman.epicfight.api.utils.datastructure.ParameterizedHashMap;
import yesman.epicfight.api.utils.datastructure.ParameterizedMap;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class LinkAnimation
extends DynamicAnimation
implements AnimationManager.AnimationAccessor<LinkAnimation> {
    protected AssetAccessor<? extends DynamicAnimation> fromAnimation;
    protected AssetAccessor<? extends StaticAnimation> toAnimation;
    protected float nextStartTime;

    public LinkAnimation() {
        this.animationClip = new AnimationClip();
    }

    @Override
    public void tick(LivingEntityPatch<?> entitypatch) {
        this.toAnimation.get().linkTick(entitypatch, this);
    }

    @Override
    public void end(LivingEntityPatch<?> entitypatch, AssetAccessor<? extends DynamicAnimation> nextAnimation, boolean isEnd) {
        if (!isEnd) {
            this.toAnimation.get().end(entitypatch, nextAnimation, isEnd);
        } else if (this.nextStartTime > 0.0f) {
            ((Animator)entitypatch.getAnimator()).getPlayer(this).ifPresent((? super T player) -> {
                player.setElapsedTime(this.nextStartTime);
                player.markDoNotResetTime();
            });
        }
    }

    public ParameterizedHashMap<EntityState.StateFactor<?>> getStatesMap(LivingEntityPatch<?> entitypatch, float time) {
        float timeInRealAnimation = Math.max(time - (this.getTotalTime() - this.nextStartTime), 0.0f);
        ParameterizedMap map = this.toAnimation.get().getStatesMap((LivingEntityPatch)entitypatch, timeInRealAnimation);
        for (Map.Entry entry : ((ParameterizedHashMap)map).entrySet()) {
            Object val = this.toAnimation.get().getModifiedLinkState((EntityState.StateFactor)entry.getKey(), entry.getValue(), entitypatch, time);
            ((ParameterizedHashMap)map).put((EntityState.StateFactor)entry.getKey(), val);
        }
        return map;
    }

    @Override
    public EntityState getState(LivingEntityPatch<?> entitypatch, float time) {
        float timeInRealAnimation = Math.max(time - (this.getTotalTime() - this.nextStartTime), 0.0f);
        EntityState state = this.toAnimation.get().getState(entitypatch, timeInRealAnimation);
        ParameterizedHashMap<EntityState.StateFactor<?>> map = state.getStateMap();
        for (Map.Entry<EntityState.StateFactor<?>, Object> entry : map.entrySet()) {
            Object val = this.toAnimation.get().getModifiedLinkState(entry.getKey(), entry.getValue(), entitypatch, time);
            map.put(entry.getKey(), val);
        }
        return state;
    }

    @Override
    public <T> T getState(EntityState.StateFactor<T> stateFactor, LivingEntityPatch<?> entitypatch, float time) {
        float timeInRealAnimation = Math.max(time - (this.getTotalTime() - this.nextStartTime), 0.0f);
        T state = this.toAnimation.get().getState(stateFactor, entitypatch, timeInRealAnimation);
        return (T)this.toAnimation.get().getModifiedLinkState(stateFactor, state, entitypatch, time);
    }

    @Override
    public Pose getPoseByTime(LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
        Pose nextStartingPose = this.toAnimation.get().getPoseByTime(entitypatch, this.nextStartTime, 1.0f);
        for (Map.Entry<String, JointTransform> entry : nextStartingPose.getJointTransformData().entrySet()) {
            if (!this.animationClip.hasJointTransform(entry.getKey())) continue;
            Keyframe[] keyframe = this.animationClip.getJointTransform(entry.getKey()).getKeyframes();
            JointTransform jt = keyframe[keyframe.length - 1].transform();
            JointTransform newJt = nextStartingPose.getJointTransformData().get(entry.getKey());
            newJt.translation().set(jt.translation());
            jt.copyFrom(newJt);
        }
        return super.getPoseByTime(entitypatch, time, partialTicks);
    }

    @Override
    public void modifyPose(DynamicAnimation animation, Pose pose, LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
        StaticAnimation staticAnimation = this.toAnimation.get();
        if (staticAnimation instanceof ActionAnimation) {
            ActionAnimation actionAnimation = (ActionAnimation)staticAnimation;
            if (!this.getTransfroms().containsKey("Coord")) {
                actionAnimation.correctRootJoint(this, pose, entitypatch, time, partialTicks);
            }
        }
    }

    @Override
    public float getPlaySpeed(LivingEntityPatch<?> entitypatch, DynamicAnimation animation) {
        return this.toAnimation.get().getPlaySpeed(entitypatch, animation);
    }

    public void setConnectedAnimations(AssetAccessor<? extends DynamicAnimation> from, AssetAccessor<? extends StaticAnimation> to) {
        this.fromAnimation = from.get().getRealAnimation();
        this.toAnimation = to;
    }

    public AssetAccessor<? extends StaticAnimation> getNextAnimation() {
        return this.toAnimation;
    }

    @Override
    public TransformSheet getCoord() {
        if (this.getTransfroms().containsKey("Coord")) {
            return this.getTransfroms().get("Coord");
        }
        if (this.getTransfroms().containsKey("Root")) {
            return this.getTransfroms().get("Root");
        }
        return TransformSheet.EMPTY_SHEET;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Optional<JointMaskEntry> getJointMaskEntry(LivingEntityPatch<?> entitypatch, boolean useCurrentMotion) {
        return useCurrentMotion ? this.toAnimation.get().getJointMaskEntry(entitypatch, true) : this.fromAnimation.get().getJointMaskEntry(entitypatch, false);
    }

    @Override
    public boolean isMainFrameAnimation() {
        return this.toAnimation.get().isMainFrameAnimation();
    }

    @Override
    public boolean isReboundAnimation() {
        return this.toAnimation.get().isReboundAnimation();
    }

    @Override
    public boolean doesHeadRotFollowEntityHead() {
        return this.fromAnimation.get().doesHeadRotFollowEntityHead() && this.toAnimation.get().doesHeadRotFollowEntityHead();
    }

    @Override
    public AssetAccessor<? extends StaticAnimation> getRealAnimation() {
        return this.toAnimation;
    }

    public AssetAccessor<? extends DynamicAnimation> getFromAnimation() {
        return this.fromAnimation;
    }

    @Override
    public AnimationManager.AnimationAccessor<? extends DynamicAnimation> getAccessor() {
        return this;
    }

    public void copyTo(LinkAnimation dest) {
        dest.setConnectedAnimations(this.fromAnimation, this.toAnimation);
        dest.setTotalTime(this.getTotalTime());
        Map<String, TransformSheet> trnasforms = dest.getTransfroms();
        trnasforms.clear();
        trnasforms.putAll(this.getTransfroms());
    }

    public float getNextStartTime() {
        return this.nextStartTime;
    }

    public void setNextStartTime(float nextStartTime) {
        this.nextStartTime = nextStartTime;
    }

    public void resetNextStartTime() {
        this.nextStartTime = 0.0f;
    }

    @Override
    public boolean isLinkAnimation() {
        return true;
    }

    public String toString() {
        return "From " + String.valueOf(this.fromAnimation) + " to " + String.valueOf(this.toAnimation);
    }

    @Override
    public AnimationClip getAnimationClip() {
        return this.animationClip;
    }

    @Override
    public LinkAnimation get() {
        return this;
    }

    @Override
    public ResourceLocation registryName() {
        return null;
    }

    @Override
    public boolean isPresent() {
        return true;
    }

    @Override
    public int id() {
        return -1;
    }

    @Override
    public boolean inRegistry() {
        return false;
    }
}

