/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.utils;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class HitEntityList {
    private final List<Entity> hitEntites;
    private int index = -1;

    public HitEntityList(LivingEntityPatch<?> attacker, List<Entity> entities, Priority priority) {
        this.hitEntites = priority.sort(attacker, entities);
    }

    public Entity getEntity() {
        return this.hitEntites.get(this.index);
    }

    public boolean next() {
        ++this.index;
        return this.hitEntites.size() > this.index;
    }

    public static enum Priority {
        DISTANCE((attacker, list) -> {
            DoubleArrayList distanceToAttacker = new DoubleArrayList();
            ArrayList hitEntites = Lists.newArrayList();
            block0: for (Entity entity : list) {
                int index;
                double distance = ((LivingEntity)attacker.getOriginal()).distanceToSqr(entity);
                for (index = 0; index < hitEntites.size(); ++index) {
                    if (!(distance < distanceToAttacker.getDouble(index))) continue;
                    hitEntites.add(index, entity);
                    distanceToAttacker.add(index, distance);
                    continue block0;
                }
                hitEntites.add(index, entity);
                distanceToAttacker.add(index, distance);
            }
            return hitEntites;
        }),
        TARGET((attacker, list) -> {
            ArrayList hitEntites = Lists.newArrayList();
            for (Entity entity : list) {
                if (!entity.is((Entity)attacker.getTarget())) continue;
                hitEntites.add(entity);
            }
            return hitEntites;
        }),
        HOSTILITY((attacker, list) -> {
            ArrayList firstTargets = Lists.newArrayList();
            ArrayList secondTargets = Lists.newArrayList();
            ArrayList lastTargets = Lists.newArrayList();
            block0: for (Entity e : list) {
                if (attacker.isTargetInvulnerable(e)) continue;
                if (((LivingEntity)attacker.getOriginal()).getLastHurtByMob() == e || attacker.getTarget() == e) {
                    firstTargets.add(e);
                    continue;
                }
                LivingEntityPatch entitypatch = EpicFightCapabilities.getEntityPatch(e, LivingEntityPatch.class);
                if (entitypatch != null && ((LivingEntity)attacker.getOriginal()).is((Entity)entitypatch.getTarget())) {
                    firstTargets.add(e);
                    continue;
                }
                if (e instanceof Mob) {
                    Mob mob = (Mob)e;
                    if (((LivingEntity)attacker.getOriginal()).is((Entity)mob.getTarget())) {
                        firstTargets.add(mob);
                        continue;
                    }
                    GoalSelector targetingAi = mob.targetSelector;
                    for (WrappedGoal goal : targetingAi.getAvailableGoals()) {
                        Goal patt0$temp = goal.getGoal();
                        if (!(patt0$temp instanceof NearestAttackableTargetGoal)) continue;
                        NearestAttackableTargetGoal targetGoal = (NearestAttackableTargetGoal)patt0$temp;
                        if (!targetGoal.targetConditions.test((LivingEntity)mob, (LivingEntity)attacker.getOriginal())) continue;
                        secondTargets.add(mob);
                        continue block0;
                    }
                }
                lastTargets.add(e);
            }
            secondTargets.addAll(lastTargets);
            firstTargets.addAll(secondTargets);
            return firstTargets;
        });

        BiFunction<LivingEntityPatch<?>, List<Entity>, List<Entity>> sortingFunction;

        private Priority(BiFunction<LivingEntityPatch<?>, List<Entity>, List<Entity>> sortingFunction) {
            this.sortingFunction = sortingFunction;
        }

        public List<Entity> sort(LivingEntityPatch<?> attacker, List<Entity> entities) {
            return this.sortingFunction.apply(attacker, entities);
        }
    }
}

