/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client;

import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.main.AuthenticationHelper;
import yesman.epicfight.network.server.SPPlayUISound;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;

@OnlyIn(value=Dist.CLIENT)
public class ClientEngine {
    private static ClientEngine instance = new ClientEngine();
    public Minecraft minecraft;
    private boolean vanillaModelDebuggingMode = false;
    private AuthenticationHelper authenticationHelper = new AuthenticationHelper(this){

        @Override
        public boolean valid() {
            return false;
        }
    };

    public static ClientEngine getInstance() {
        return instance;
    }

    public ClientEngine() {
        instance = this;
        this.minecraft = Minecraft.getInstance();
    }

    public boolean switchVanillaModelDebuggingMode() {
        this.vanillaModelDebuggingMode = !this.vanillaModelDebuggingMode;
        return this.vanillaModelDebuggingMode;
    }

    public boolean isVanillaModelDebuggingMode() {
        return this.vanillaModelDebuggingMode;
    }

    @Nullable
    public LocalPlayerPatch getPlayerPatch() {
        return EpicFightCapabilities.getEntityPatch((Entity)this.minecraft.player, LocalPlayerPatch.class);
    }

    public void initAuthHelper(AuthenticationHelper authHelper) {
        this.authenticationHelper = authHelper;
    }

    public AuthenticationHelper getAuthHelper() {
        return this.authenticationHelper;
    }

    public void playUISound(SPPlayUISound msg) {
        SimpleSoundInstance soundinstance = SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)msg.sound().value()), (float)msg.pitch(), (float)msg.volume());
        Minecraft.getInstance().getSoundManager().play((SoundInstance)soundinstance);
        Minecraft.getInstance().getSoundManager().play((SoundInstance)soundinstance);
    }

    public boolean isEpicFightMode() {
        LocalPlayerPatch localPlayerPatch = EpicFightCapabilities.getEntityPatch((Entity)this.minecraft.player, LocalPlayerPatch.class);
        if (localPlayerPatch == null) {
            return false;
        }
        return localPlayerPatch.isEpicFightMode();
    }

    public static Comparator<ParticleRenderType> makeCustomLowestParticleRenderTypeComparator(List<ParticleRenderType> renderOrder) {
        Comparator<ParticleRenderType> vanillaComparator = Comparator.comparingInt(renderOrder::indexOf);
        return (typeOne, typeTwo) -> {
            boolean vanillaOne = renderOrder.contains(typeOne);
            boolean vanillaTwo = renderOrder.contains(typeTwo);
            if (vanillaOne && vanillaTwo) {
                return vanillaComparator.compare((ParticleRenderType)typeOne, (ParticleRenderType)typeTwo);
            }
            if (!vanillaOne && !vanillaTwo) {
                return Integer.compare(System.identityHashCode(typeOne), System.identityHashCode(typeTwo));
            }
            if (typeOne == ParticleRenderType.CUSTOM) {
                return 1;
            }
            if (typeTwo == ParticleRenderType.CUSTOM) {
                return -1;
            }
            return vanillaOne ? -1 : 1;
        };
    }
}

